/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.output.metrics.IdealPartitioningBasedMetricDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class PrecisionRecallMetricDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.output.metrics.PrecisionRecallMetric";
    public final String prefix = "";
    public final String title = "Computes precision, recall and F-metric for all partitions against the provided clusters";
    public final String label = "";
    public final String description = "<p> Metrics will be calculated only if all input documents have non-blank <code>Document.PARTITIONS</code>. </p>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "Computes precision, recall and F-metric for all partitions against the provided clusters";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "<p> Metrics will be calculated only if all input documents have non-blank <code>Document.PARTITIONS</code>. </p>";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.weightedAveragePrecision);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.weightedAverageRecall);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.weightedAverageFMeasure);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.precisionByPartition);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.recallByPartition);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.fMeasureByPartition);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.enabled);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.documents);
        ownAttrs.add(PrecisionRecallMetricDescriptor.attributes.clusters);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.weightedAveragePrecision);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.weightedAverageRecall);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.weightedAverageFMeasure);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.precisionByPartition);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.recallByPartition);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.fMeasureByPartition);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.enabled);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.documents);
        allAttrs.add(PrecisionRecallMetricDescriptor.attributes.clusters);
        allAttrs.add(IdealPartitioningBasedMetricDescriptor.attributes.partitionIdFieldName);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends IdealPartitioningBasedMetricDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public Double weightedAveragePrecision() {
            return (Double)this.map.get("org.carrot2.output.metrics.PrecisionRecallMetric.weightedAveragePrecision");
        }

        public Double weightedAverageRecall() {
            return (Double)this.map.get("org.carrot2.output.metrics.PrecisionRecallMetric.weightedAverageRecall");
        }

        public Double weightedAverageFMeasure() {
            return (Double)this.map.get("org.carrot2.output.metrics.PrecisionRecallMetric.weightedAverageFMeasure");
        }

        public Map<Object, Double> precisionByPartition() {
            return (Map)this.map.get("org.carrot2.output.metrics.PrecisionRecallMetric.precisionByPartition");
        }

        public Map<Object, Double> recallByPartition() {
            return (Map)this.map.get("org.carrot2.output.metrics.PrecisionRecallMetric.recallByPartition");
        }

        public Map<Object, Double> fMeasureByPartition() {
            return (Map)this.map.get("org.carrot2.output.metrics.PrecisionRecallMetric.fMeasureByPartition");
        }

        public AttributeBuilder enabled(boolean value) {
            this.map.put("org.carrot2.output.metrics.PrecisionRecallMetric.enabled", value);
            return this;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public AttributeBuilder clusters(List<Cluster> value) {
            this.map.put("clusters", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo weightedAveragePrecision = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.weightedAveragePrecision", "org.carrot2.output.metrics.PrecisionRecallMetric", "weightedAveragePrecision", "Average precision of the whole cluster set, weighted by cluster size.", null, "Average precision of the whole cluster set, weighted by cluster size", null, null, null, null);
        public final AttributeInfo weightedAverageRecall = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.weightedAverageRecall", "org.carrot2.output.metrics.PrecisionRecallMetric", "weightedAverageRecall", "Average recall of the whole cluster set, weighted by cluster size.", null, "Average recall of the whole cluster set, weighted by cluster size", null, null, null, null);
        public final AttributeInfo weightedAverageFMeasure = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.weightedAverageFMeasure", "org.carrot2.output.metrics.PrecisionRecallMetric", "weightedAverageFMeasure", "Average F-measure of the whole cluster set, weighted by cluster size.", null, "Average F-measure of the whole cluster set, weighted by cluster size", null, null, null, null);
        public final AttributeInfo precisionByPartition = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.precisionByPartition", "org.carrot2.output.metrics.PrecisionRecallMetric", "precisionByPartition", "Precision by partition.", null, "Precision by partition", null, null, null, null);
        public final AttributeInfo recallByPartition = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.recallByPartition", "org.carrot2.output.metrics.PrecisionRecallMetric", "recallByPartition", "Recall by partition.", null, "Recall by partition", null, null, null, null);
        public final AttributeInfo fMeasureByPartition = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.fMeasureByPartition", "org.carrot2.output.metrics.PrecisionRecallMetric", "fMeasureByPartition", "F-measure by partition.", null, "F-measure by partition", null, null, null, null);
        public final AttributeInfo enabled = new AttributeInfo("org.carrot2.output.metrics.PrecisionRecallMetric.enabled", "org.carrot2.output.metrics.PrecisionRecallMetric", "enabled", "Calculate F-measure.", null, "Calculate F-measure", null, null, null, null);
        public final AttributeInfo documents = new AttributeInfo("documents", "org.carrot2.output.metrics.PrecisionRecallMetric", "documents", null, null, null, null, null, null, null);
        public final AttributeInfo clusters = new AttributeInfo("clusters", "org.carrot2.output.metrics.PrecisionRecallMetric", "clusters", null, null, null, null, null, null, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends IdealPartitioningBasedMetricDescriptor.Keys {
        public static final String WEIGHTED_AVERAGE_PRECISION = "org.carrot2.output.metrics.PrecisionRecallMetric.weightedAveragePrecision";
        public static final String WEIGHTED_AVERAGE_RECALL = "org.carrot2.output.metrics.PrecisionRecallMetric.weightedAverageRecall";
        public static final String WEIGHTED_AVERAGE_F_MEASURE = "org.carrot2.output.metrics.PrecisionRecallMetric.weightedAverageFMeasure";
        public static final String PRECISION_BY_PARTITION = "org.carrot2.output.metrics.PrecisionRecallMetric.precisionByPartition";
        public static final String RECALL_BY_PARTITION = "org.carrot2.output.metrics.PrecisionRecallMetric.recallByPartition";
        public static final String F_MEASURE_BY_PARTITION = "org.carrot2.output.metrics.PrecisionRecallMetric.fMeasureByPartition";
        public static final String ENABLED = "org.carrot2.output.metrics.PrecisionRecallMetric.enabled";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";

        protected Keys() {
        }
    }
}

