/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.output.metrics.IdealPartitioningBasedMetricDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;

public final class ContaminationMetricDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.output.metrics.ContaminationMetric";
    public final String prefix = "";
    public final String title = "Computes cluster contamination";
    public final String label = "";
    public final String description = "If a cluster groups documents found in the same <code>Document.PARTITIONS</code>, its contamination is 0. If a cluster groups an equally distributed mix of all partitions, its contamination is 1.0. For a full definition, please see section 4.4.1 of <a href=\"http://project.carrot2.org/publications/osinski04-dimensionality.pdf\">this work</a>. <p> Contamination is calculated for top-level clusters only, taking into account documents from the cluster and all subclusters. Finally, contamination will be calculated only if all input documents have non-blank <code>Document.PARTITIONS</code>s. </p>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "Computes cluster contamination";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "If a cluster groups documents found in the same <code>Document.PARTITIONS</code>, its contamination is 0. If a cluster groups an equally distributed mix of all partitions, its contamination is 1.0. For a full definition, please see section 4.4.1 of <a href=\"http://project.carrot2.org/publications/osinski04-dimensionality.pdf\">this work</a>. <p> Contamination is calculated for top-level clusters only, taking into account documents from the cluster and all subclusters. Finally, contamination will be calculated only if all input documents have non-blank <code>Document.PARTITIONS</code>s. </p>";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(ContaminationMetricDescriptor.attributes.weightedAverageContamination);
        ownAttrs.add(ContaminationMetricDescriptor.attributes.enabled);
        ownAttrs.add(ContaminationMetricDescriptor.attributes.documents);
        ownAttrs.add(ContaminationMetricDescriptor.attributes.clusters);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(ContaminationMetricDescriptor.attributes.weightedAverageContamination);
        allAttrs.add(ContaminationMetricDescriptor.attributes.enabled);
        allAttrs.add(ContaminationMetricDescriptor.attributes.documents);
        allAttrs.add(ContaminationMetricDescriptor.attributes.clusters);
        allAttrs.add(IdealPartitioningBasedMetricDescriptor.attributes.partitionIdFieldName);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder
    extends IdealPartitioningBasedMetricDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public double weightedAverageContamination() {
            return (Double)this.map.get("org.carrot2.output.metrics.ContaminationMetric.weightedAverageContamination");
        }

        public AttributeBuilder enabled(boolean value) {
            this.map.put("org.carrot2.output.metrics.ContaminationMetric.enabled", value);
            return this;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public AttributeBuilder clusters(List<Cluster> value) {
            this.map.put("clusters", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo weightedAverageContamination = new AttributeInfo("org.carrot2.output.metrics.ContaminationMetric.weightedAverageContamination", "org.carrot2.output.metrics.ContaminationMetric", "weightedAverageContamination", "Average contamination of the whole cluster set, weighted by the size of cluster.", null, "Average contamination of the whole cluster set, weighted by the size of cluster", null, null, null, null);
        public final AttributeInfo enabled = new AttributeInfo("org.carrot2.output.metrics.ContaminationMetric.enabled", "org.carrot2.output.metrics.ContaminationMetric", "enabled", "Calculate contamination metric.", null, "Calculate contamination metric", null, null, null, null);
        public final AttributeInfo documents = new AttributeInfo("documents", "org.carrot2.output.metrics.ContaminationMetric", "documents", null, null, null, null, null, null, null);
        public final AttributeInfo clusters = new AttributeInfo("clusters", "org.carrot2.output.metrics.ContaminationMetric", "clusters", null, null, null, null, null, null, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends IdealPartitioningBasedMetricDescriptor.Keys {
        public static final String WEIGHTED_AVERAGE_CONTAMINATION = "org.carrot2.output.metrics.ContaminationMetric.weightedAverageContamination";
        public static final String ENABLED = "org.carrot2.output.metrics.ContaminationMetric.enabled";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";

        protected Keys() {
        }
    }
}

