/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlEntityProcessor
extends EntityProcessorBase {
    private static final Logger LOG = LoggerFactory.getLogger(SqlEntityProcessor.class);
    protected DataSource<Iterator<Map<String, Object>>> dataSource;
    private static Pattern SELECT_WHERE_PATTERN = Pattern.compile("^\\s*(select\\b.*?\\b)(where).*", 2);
    public static final String QUERY = "query";
    public static final String DELTA_QUERY = "deltaQuery";
    public static final String DELTA_IMPORT_QUERY = "deltaImportQuery";
    public static final String PARENT_DELTA_QUERY = "parentDeltaQuery";
    public static final String DEL_PK_QUERY = "deletedPkQuery";
    public static final Pattern DOT_PATTERN = Pattern.compile(".*?\\.(.*)$");

    @Override
    public void init(Context context) {
        super.init(context);
        this.dataSource = context.getDataSource();
    }

    protected void initQuery(String q) {
        try {
            DataImporter.QUERY_COUNT.get().incrementAndGet();
            this.rowIterator = this.dataSource.getData(q);
            this.query = q;
        }
        catch (DataImportHandlerException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("The query failed '" + q + "'", (Throwable)e);
            throw new DataImportHandlerException(500, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        if (this.rowIterator == null) {
            String q = this.getQuery();
            this.initQuery(this.context.replaceTokens(q));
        }
        return this.getNext();
    }

    @Override
    public Map<String, Object> nextModifiedRowKey() {
        if (this.rowIterator == null) {
            String deltaQuery = this.context.getEntityAttribute(DELTA_QUERY);
            if (deltaQuery == null) {
                return null;
            }
            this.initQuery(this.context.replaceTokens(deltaQuery));
        }
        return this.getNext();
    }

    @Override
    public Map<String, Object> nextDeletedRowKey() {
        if (this.rowIterator == null) {
            String deletedPkQuery = this.context.getEntityAttribute(DEL_PK_QUERY);
            if (deletedPkQuery == null) {
                return null;
            }
            this.initQuery(this.context.replaceTokens(deletedPkQuery));
        }
        return this.getNext();
    }

    @Override
    public Map<String, Object> nextModifiedParentRowKey() {
        if (this.rowIterator == null) {
            String parentDeltaQuery = this.context.getEntityAttribute(PARENT_DELTA_QUERY);
            if (parentDeltaQuery == null) {
                return null;
            }
            LOG.info("Running parentDeltaQuery for Entity: " + this.context.getEntityAttribute("name"));
            this.initQuery(this.context.replaceTokens(parentDeltaQuery));
        }
        return this.getNext();
    }

    public String getQuery() {
        String deltaImportQuery;
        String queryString = this.context.getEntityAttribute(QUERY);
        if ("FULL_DUMP".equals(this.context.currentProcess())) {
            return queryString;
        }
        if ("DELTA_DUMP".equals(this.context.currentProcess()) && (deltaImportQuery = this.context.getEntityAttribute(DELTA_IMPORT_QUERY)) != null) {
            return deltaImportQuery;
        }
        LOG.warn("'deltaImportQuery' attribute is not specified for entity : " + this.entityName);
        return this.getDeltaImportQuery(queryString);
    }

    public String getDeltaImportQuery(String queryString) {
        String[] primaryKeys;
        StringBuilder sb = new StringBuilder(queryString);
        if (SELECT_WHERE_PATTERN.matcher(queryString).find()) {
            sb.append(" and ");
        } else {
            sb.append(" where ");
        }
        boolean first = true;
        for (String primaryKey : primaryKeys = this.context.getEntityAttribute("pk").split(",")) {
            Matcher m;
            if (!first) {
                sb.append(" and ");
            }
            first = false;
            Object val = this.context.resolve("dataimporter.delta." + primaryKey);
            if (val == null && (m = DOT_PATTERN.matcher(primaryKey)).find()) {
                val = this.context.resolve("dataimporter.delta." + m.group(1));
            }
            sb.append(primaryKey).append(" = ");
            if (val instanceof Number) {
                sb.append(val.toString());
                continue;
            }
            sb.append("'").append(val.toString()).append("'");
        }
        return sb.toString();
    }
}

