/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractEntityDynamicCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnUpdateEntityHandler;

public class TnUpdateEntityDynamicCommand
extends TnAbstractEntityDynamicCommand {
    private static final Integer NON_UPDATE = 1;
    protected boolean _optimisticLockHandling;
    protected boolean _versionNoAutoIncrementOnMemory;

    public TnUpdateEntityDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        if (args == null || args.length == 0) {
            String msg = "The argument 'args' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        Object bean = args[0];
        UpdateOption<ConditionBean> option = this.extractUpdateOptionChecked(args);
        TnPropertyType[] propertyTypes = this.createUpdatePropertyTypes(bean, option);
        if (propertyTypes.length == 0) {
            if (this.isLogEnabled()) {
                this.log(this.createNonUpdateLogMessage(bean));
            }
            return this.getNonUpdateReturn();
        }
        String sql = this.filterExecutedSql(this.createUpdateSql(propertyTypes, option));
        return this.doExecute(bean, propertyTypes, sql, option);
    }

    protected UpdateOption<ConditionBean> extractUpdateOptionChecked(Object[] args) {
        if (args.length < 2 || args[1] == null) {
            return null;
        }
        UpdateOption option = (UpdateOption)args[1];
        option.xcheckSpecifiedUpdateColumnPrimaryKey();
        return option;
    }

    protected Object doExecute(Object bean, TnPropertyType[] propertyTypes, String sql, UpdateOption<ConditionBean> option) {
        TnUpdateEntityHandler handler = this.createUpdateEntityHandler(propertyTypes, sql, option);
        Object[] realArgs = new Object[]{bean};
        handler.setExceptionMessageSqlArgs(realArgs);
        int result = handler.execute(realArgs);
        return result;
    }

    protected TnPropertyType[] createUpdatePropertyTypes(Object bean, UpdateOption<ConditionBean> option) {
        Set<?> modifiedSet = this.getModifiedPropertyNames(bean);
        ArrayList<TnPropertyType> typeList = new ArrayList<TnPropertyType>();
        String timestampProp = this._beanMetaData.getTimestampPropertyName();
        String versionNoProp = this._beanMetaData.getVersionNoPropertyName();
        String[] propertyNames = this._propertyNames;
        for (int i = 0; i < propertyNames.length; ++i) {
            TnPropertyType pt = this._beanMetaData.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() || !this.isOptimisticLockProperty(timestampProp, versionNoProp, pt) && !this.isSpecifiedProperty(option, modifiedSet, pt) && !this.isStatementProperty(option, pt)) continue;
            typeList.add(pt);
        }
        return typeList.toArray(new TnPropertyType[typeList.size()]);
    }

    protected Set<?> getModifiedPropertyNames(Object bean) {
        return this._beanMetaData.getModifiedPropertyNames(bean);
    }

    protected boolean isOptimisticLockProperty(String timestampProp, String versionNoProp, TnPropertyType pt) {
        String propertyName = pt.getPropertyName();
        return propertyName.equalsIgnoreCase(timestampProp) || propertyName.equalsIgnoreCase(versionNoProp);
    }

    protected boolean isSpecifiedProperty(UpdateOption<ConditionBean> option, Set<?> modifiedSet, TnPropertyType pt) {
        if (option != null && option.hasSpecifiedUpdateColumn()) {
            return option.isSpecifiedUpdateColumn(pt.getColumnDbName());
        }
        return this.isModifiedProperty(modifiedSet, pt);
    }

    protected boolean isModifiedProperty(Set<?> modifiedSet, TnPropertyType pt) {
        return modifiedSet.contains(pt.getPropertyName());
    }

    protected boolean isStatementProperty(UpdateOption<ConditionBean> option, TnPropertyType pt) {
        return option != null && option.hasStatement(pt.getColumnDbName());
    }

    protected String createUpdateSql(TnPropertyType[] propertyTypes, UpdateOption<ConditionBean> option) {
        int i;
        String tableDbName = this._targetDBMeta.getTableDbName();
        if (this._beanMetaData.getPrimaryKeySize() == 0) {
            String msg = "The table '" + tableDbName + "' should have primary key.";
            throw new IllegalStateException(msg);
        }
        StringBuilder sb = new StringBuilder(96);
        sb.append("update ").append(this._targetDBMeta.getTableSqlName()).append(" set ");
        String versionNoPropertyName = this._beanMetaData.getVersionNoPropertyName();
        for (i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            String columnDbName = pt.getColumnDbName();
            ColumnSqlName columnSqlName = pt.getColumnSqlName();
            String propertyName = pt.getPropertyName();
            if (i > 0) {
                sb.append(", ");
            }
            if (propertyName.equalsIgnoreCase(versionNoPropertyName) && !this.isVersionNoAutoIncrementOnMemory()) {
                this.setupVersionNoAutoIncrementOnQuery(sb, columnSqlName);
                continue;
            }
            if (option != null && option.hasStatement(columnDbName)) {
                String statement = option.buildStatement(columnDbName);
                sb.append(columnSqlName).append(" = ").append(statement);
                continue;
            }
            sb.append(columnSqlName).append(" = ");
            sb.append(this.encrypt(tableDbName, columnDbName, "?"));
        }
        sb.append(this.ln()).append(" where ");
        for (i = 0; i < this._beanMetaData.getPrimaryKeySize(); ++i) {
            sb.append(this._beanMetaData.getPrimaryKeySqlName(i)).append(" = ? and ");
        }
        sb.setLength(sb.length() - 5);
        if (this._optimisticLockHandling && this._beanMetaData.hasVersionNoPropertyType()) {
            TnPropertyType pt = this._beanMetaData.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        if (this._optimisticLockHandling && this._beanMetaData.hasTimestampPropertyType()) {
            TnPropertyType pt = this._beanMetaData.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        return sb.toString();
    }

    protected void setupVersionNoAutoIncrementOnQuery(StringBuilder sb, ColumnSqlName columnSqlName) {
        sb.append(columnSqlName).append(" = ").append(columnSqlName).append(" + 1");
    }

    protected TnUpdateEntityHandler createUpdateEntityHandler(TnPropertyType[] boundPropTypes, String sql, UpdateOption<ConditionBean> option) {
        TnUpdateEntityHandler handler = new TnUpdateEntityHandler(this._dataSource, this._statementFactory, sql, this._beanMetaData, boundPropTypes);
        handler.setOptimisticLockHandling(this._optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this._versionNoAutoIncrementOnMemory);
        handler.setUpdateOption(option);
        return handler;
    }

    protected String createNonUpdateLogMessage(Object bean) {
        StringBuilder sb = new StringBuilder();
        String tableDbName = this._targetDBMeta.getTableDbName();
        sb.append("...Skipping update because of non-modification: table=").append(tableDbName);
        if (this._targetDBMeta.hasPrimaryKey() && bean instanceof Entity) {
            Entity entity = (Entity)bean;
            Map<String, Object> pkMap = this._targetDBMeta.extractPrimaryKeyMap(entity);
            sb.append(", primaryKey=").append(pkMap);
        }
        return sb.toString();
    }

    protected Object getNonUpdateReturn() {
        return NON_UPDATE;
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this._optimisticLockHandling = optimisticLockHandling;
    }

    protected boolean isVersionNoAutoIncrementOnMemory() {
        return this._versionNoAutoIncrementOnMemory;
    }

    public void setVersionNoAutoIncrementOnMemory(boolean versionNoAutoIncrementOnMemory) {
        this._versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
    }
}

