/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.bhv.SqlStringFilter;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractBasicSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.node.Node;

public abstract class TnAbstractQueryDynamicCommand
extends TnAbstractBasicSqlCommand {
    public TnAbstractQueryDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    protected TnCommandContextHandler createCommandContextHandler(CommandContext context) {
        String executedSql = this.filterSqlStringByCallbackFilter(context.getSql());
        return new TnCommandContextHandler(this._dataSource, this._statementFactory, executedSql, context);
    }

    protected String filterSqlStringByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterQueryUpdate(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    protected CommandContext createCommandContext(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        SqlAnalyzer analyzer = this.createSqlAnalyzer(twoWaySql);
        Node node = analyzer.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext ctx = creator.createCommandContext(args);
        node.accept(ctx);
        return ctx;
    }

    protected SqlAnalyzer createSqlAnalyzer(String twoWaySql) {
        return ResourceContext.createSqlAnalyzer(twoWaySql, true);
    }
}

