/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.outsidesql.executor;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.exception.DangerousResultSizeException;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.seasar.dbflute.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.dbflute.outsidesql.typed.EntityHandlingPmb;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfTypeUtil;

public class OutsideSqlEntityExecutor<BEHAVIOR> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final OutsideSqlExecutorFactory _outsideSqlExecutorFactory;

    public OutsideSqlEntityExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig, OutsideSqlOption outsideSqlOption, OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
        this._outsideSqlOption = outsideSqlOption;
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
    }

    public <ENTITY> ENTITY selectEntity(EntityHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        if (pmb == null) {
            String msg = "The argument 'pmb' (typed parameter-bean) should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.doSelectEntity(pmb.getOutsideSqlPath(), pmb, pmb.getEntityType());
    }

    public <ENTITY> ENTITY selectEntity(String path, Object pmb, Class<ENTITY> entityType) {
        return this.doSelectEntity(path, pmb, entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ENTITY> ENTITY doSelectEntity(String path, Object pmb, Class<ENTITY> entityType) {
        List<ENTITY> ls;
        if (path == null) {
            String msg = "The argument 'path' of outside-SQL should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (entityType == null) {
            String msg = "The argument 'entityType' for result should not be null: path=" + path;
            throw new IllegalArgumentException(msg);
        }
        int preSafetyMaxResultSize = this.xcheckSafetyResultAsOneIfNeed(pmb);
        try {
            ls = this.doSelectList(path, pmb, entityType);
        }
        catch (DangerousResultSizeException e) {
            String searchKey4Log = this.buildSearchKey4Exception(path, pmb, entityType);
            this.throwSelectEntityDuplicatedException("{over safetyMaxResultSize '1'}", searchKey4Log, e);
            ENTITY ENTITY = null;
            return ENTITY;
        }
        finally {
            this.xrestoreSafetyResultIfNeed(pmb, preSafetyMaxResultSize);
        }
        if (ls == null || ls.isEmpty()) {
            return null;
        }
        if (ls.size() > 1) {
            String searchKey4Log = this.buildSearchKey4Exception(path, pmb, entityType);
            this.throwSelectEntityDuplicatedException(String.valueOf(ls.size()), searchKey4Log, null);
        }
        return ls.get(0);
    }

    protected int xcheckSafetyResultAsOneIfNeed(Object pmb) {
        if (pmb instanceof FetchBean) {
            int safetyMaxResultSize = ((FetchBean)pmb).getSafetyMaxResultSize();
            ((FetchBean)pmb).checkSafetyResult(1);
            return safetyMaxResultSize;
        }
        return 0;
    }

    protected void xrestoreSafetyResultIfNeed(Object pmb, int preSafetyMaxResultSize) {
        if (pmb instanceof FetchBean) {
            ((FetchBean)pmb).checkSafetyResult(preSafetyMaxResultSize);
        }
    }

    protected <ENTITY> String buildSearchKey4Exception(String path, Object pmb, Class<ENTITY> entityType) {
        StringBuilder sb = new StringBuilder();
        sb.append("table  = ").append(this._outsideSqlOption.getTableDbName()).append(OutsideSqlEntityExecutor.ln());
        sb.append("path   = ").append(path).append(OutsideSqlEntityExecutor.ln());
        sb.append("pmbean = ").append(DfTypeUtil.toClassTitle(pmb)).append(":").append(pmb).append(OutsideSqlEntityExecutor.ln());
        sb.append("entity = ").append(DfTypeUtil.toClassTitle(entityType)).append(OutsideSqlEntityExecutor.ln());
        sb.append("option = ").append(this._outsideSqlOption);
        return sb.toString();
    }

    protected void throwSelectEntityDuplicatedException(String resultCountExp, Object searchKey, Throwable cause) {
        this.createBhvExThrower().throwSelectEntityDuplicatedException(resultCountExp, searchKey, cause);
    }

    protected <ENTITY> List<ENTITY> doSelectList(String path, Object pmb, Class<ENTITY> entityType) {
        return this.createBasicExecutor().selectList(path, pmb, entityType);
    }

    protected OutsideSqlBasicExecutor<BEHAVIOR> createBasicExecutor() {
        return this._outsideSqlExecutorFactory.createBasic(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public <ENTITY> ENTITY selectEntityWithDeletedCheck(EntityHandlingPmb<BEHAVIOR, ENTITY> pmb) {
        if (pmb == null) {
            String msg = "The argument 'pmb' (typed parameter-bean) should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return this.doSelectEntityWithDeletedCheck(pmb.getOutsideSqlPath(), pmb, pmb.getEntityType());
    }

    public <ENTITY> ENTITY selectEntityWithDeletedCheck(String path, Object pmb, Class<ENTITY> entityType) {
        return this.doSelectEntityWithDeletedCheck(path, pmb, entityType);
    }

    protected <ENTITY> ENTITY doSelectEntityWithDeletedCheck(String path, Object pmb, Class<ENTITY> entityType) {
        ENTITY entity = this.selectEntity(path, pmb, entityType);
        if (entity == null) {
            this.throwSelectEntityAlreadyDeletedException(this.buildSearchKey4Exception(path, pmb, entityType));
        }
        return entity;
    }

    protected void throwSelectEntityAlreadyDeletedException(Object searchKey) {
        this.createBhvExThrower().throwSelectEntityAlreadyDeletedException(searchKey);
    }

    public OutsideSqlEntityExecutor<BEHAVIOR> removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public OutsideSqlEntityExecutor<BEHAVIOR> removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public OutsideSqlEntityExecutor<BEHAVIOR> formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public OutsideSqlEntityExecutor<BEHAVIOR> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }

    protected static String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

