/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.file;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.seasar.dbflute.helper.token.file.FileMakingCallback;
import org.seasar.dbflute.helper.token.file.FileMakingOption;
import org.seasar.dbflute.helper.token.file.FileMakingRowResource;
import org.seasar.dbflute.helper.token.file.FileToken;

public class FileMakingSimpleFacade {
    protected final FileToken fileToken = new FileToken();

    public void makeFromRowList(String filePath, final List<List<String>> rowList, FileMakingOption option) throws FileNotFoundException, IOException {
        FileMakingCallback fileMakingCallback = new FileMakingCallback(){
            protected int rowCount = 0;

            @Override
            public FileMakingRowResource getRowResource() {
                ++this.rowCount;
                if (rowList.size() < this.rowCount) {
                    return null;
                }
                List valueList = (List)rowList.get(this.rowCount - 1);
                FileMakingRowResource rowResource = new FileMakingRowResource();
                rowResource.setValueList(valueList);
                return rowResource;
            }
        };
        FileToken fileToken = new FileToken();
        fileToken.make(filePath, fileMakingCallback, option);
    }

    public byte[] makeFromRowList(final List<List<String>> rowList, FileMakingOption option) throws FileNotFoundException, IOException {
        FileMakingCallback fileMakingCallback = new FileMakingCallback(){
            protected int rowCount = 0;

            @Override
            public FileMakingRowResource getRowResource() {
                ++this.rowCount;
                if (rowList.size() < this.rowCount) {
                    return null;
                }
                List valueList = (List)rowList.get(this.rowCount - 1);
                FileMakingRowResource rowResource = new FileMakingRowResource();
                rowResource.setValueList(valueList);
                return rowResource;
            }
        };
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileToken fileToken = new FileToken();
        fileToken.make(baos, fileMakingCallback, option);
        return baos.toByteArray();
    }
}

