/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorReadable;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.bhv.core.CommonColumnAutoSetupper;
import org.seasar.dbflute.bhv.core.command.AbstractListEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteNonstrictCommand;
import org.seasar.dbflute.bhv.core.command.BatchInsertCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateNonstrictCommand;
import org.seasar.dbflute.bhv.core.command.DeleteEntityCommand;
import org.seasar.dbflute.bhv.core.command.DeleteNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.QueryDeleteCBCommand;
import org.seasar.dbflute.bhv.core.command.QueryInsertCBCommand;
import org.seasar.dbflute.bhv.core.command.QueryUpdateCBCommand;
import org.seasar.dbflute.bhv.core.command.UpdateEntityCommand;
import org.seasar.dbflute.bhv.core.command.UpdateNonstrictEntityCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.exception.IllegalBehaviorStateException;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.exception.OptimisticLockColumnValueNullException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.resource.ResourceContext;

public abstract class AbstractBehaviorWritable
extends AbstractBehaviorReadable
implements BehaviorWritable {
    protected CommonColumnAutoSetupper _commonColumnAutoSetupper;

    @Override
    public void create(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.doCreate(entity, option);
    }

    protected abstract void doCreate(Entity var1, InsertOption<? extends ConditionBean> var2);

    @Override
    public void modify(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doModify(entity, option);
    }

    protected abstract void doModify(Entity var1, UpdateOption<? extends ConditionBean> var2);

    @Override
    public void modifyNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doModifyNonstrict(entity, option);
    }

    protected abstract void doModifyNonstrict(Entity var1, UpdateOption<? extends ConditionBean> var2);

    @Override
    public void createOrModify(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doCreateOrModify(entity, insertOption, updateOption);
    }

    protected abstract void doCreateOrModify(Entity var1, InsertOption<? extends ConditionBean> var2, UpdateOption<? extends ConditionBean> var3);

    @Override
    public void createOrModifyNonstrict(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doCreateOrModifyNonstrict(entity, insertOption, updateOption);
    }

    protected abstract void doCreateOrModifyNonstrict(Entity var1, InsertOption<? extends ConditionBean> var2, UpdateOption<? extends ConditionBean> var3);

    @Override
    public void remove(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doRemove(entity, option);
    }

    protected abstract void doRemove(Entity var1, DeleteOption<? extends ConditionBean> var2);

    @Override
    public void removeNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doRemoveNonstrict(entity, option);
    }

    protected abstract void doRemoveNonstrict(Entity var1, DeleteOption<? extends ConditionBean> var2);

    protected <ENTITY extends Entity> void helpUpdateInternally(ENTITY entity, InternalUpdateCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasOptimisticLockValue(entity);
        int updatedCount = callback.callbackDelegateUpdate(entity);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected <ENTITY extends Entity> void helpUpdateNonstrictInternally(ENTITY entity, InternalUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int updatedCount = callback.callbackDelegateUpdateNonstrict(entity);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected <ENTITY extends Entity> void throwUpdateEntityAlreadyDeletedException(ENTITY entity) {
        this.createBhvExThrower().throwUpdateEntityAlreadyDeletedException(entity);
    }

    protected <ENTITY extends Entity> void throwUpdateEntityDuplicatedException(ENTITY entity, int count) {
        this.createBhvExThrower().throwUpdateEntityDuplicatedException(entity, count);
    }

    protected <ENTITY extends Entity, CB_TYPE extends ConditionBean> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateCallback<ENTITY, CB_TYPE> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            RuntimeException updateException = null;
            try {
                callback.callbackUpdate(entity);
            }
            catch (EntityAlreadyUpdatedException e) {
                updateException = e;
            }
            catch (EntityAlreadyDeletedException e) {
                updateException = e;
            }
            catch (OptimisticLockColumnValueNullException e) {
                updateException = e;
            }
            if (updateException != null) {
                CB_TYPE cb = callback.callbackNewMyConditionBean();
                cb.acceptPrimaryKeyMap(this.getDBMeta().extractPrimaryKeyMap(entity));
                if (callback.callbackSelectCount(cb) == 0) {
                    callback.callbackInsert(entity);
                } else {
                    throw updateException;
                }
            }
        }
    }

    protected <ENTITY extends Entity> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            try {
                callback.callbackUpdateNonstrict(entity);
            }
            catch (EntityAlreadyDeletedException ignored) {
                callback.callbackInsert(entity);
            }
        }
    }

    protected <ENTITY extends Entity> void helpDeleteInternally(ENTITY entity, InternalDeleteCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasOptimisticLockValue(entity);
        int deletedCount = callback.callbackDelegateDelete(entity);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictInternally(ENTITY entity, InternalDeleteNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictIgnoreDeletedInternally(ENTITY entity, InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            return;
        }
        if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    @Override
    public int[] lumpCreate(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpCreate(castList, option);
    }

    protected abstract int[] doLumpCreate(List<Entity> var1, InsertOption<? extends ConditionBean> var2);

    @Override
    public int[] lumpModify(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpModify(castList, option);
    }

    protected abstract int[] doLumpModify(List<Entity> var1, UpdateOption<? extends ConditionBean> var2);

    @Override
    public int[] lumpModifyNonstrict(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpModifyNonstrict(castList, option);
    }

    protected abstract int[] doLumpModifyNonstrict(List<Entity> var1, UpdateOption<? extends ConditionBean> var2);

    @Override
    public int[] lumpRemove(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpRemove(castList, option);
    }

    protected abstract int[] doLumpRemove(List<Entity> var1, DeleteOption<? extends ConditionBean> var2);

    @Override
    public int[] lumpRemoveNonstrict(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpRemoveNonstrict(castList, option);
    }

    protected abstract int[] doLumpRemoveNonstrict(List<Entity> var1, DeleteOption<? extends ConditionBean> var2);

    @Override
    public int rangeCreate(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper, InsertOption<? extends ConditionBean> option) {
        return this.doRangeCreate(setupper, option);
    }

    protected abstract int doRangeCreate(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> var1, InsertOption<? extends ConditionBean> var2);

    @Override
    public int rangeModify(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        return this.doRangeModify(entity, cb, option);
    }

    protected abstract int doRangeModify(Entity var1, ConditionBean var2, UpdateOption<? extends ConditionBean> var3);

    @Override
    public int rangeRemove(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        return this.doRangeRemove(cb, option);
    }

    protected abstract int doRangeRemove(ConditionBean var1, DeleteOption<? extends ConditionBean> var2);

    protected boolean checkCountBeforeQueryUpdate(ConditionBean cb) {
        return this.readCount(cb) > 0;
    }

    protected boolean processBeforeInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.frameworkFilterEntityOfInsert(entity, option);
        this.filterEntityOfInsert(entity, option);
        this.assertEntityOfInsert(entity, option);
        if (!entity.getDBMeta().hasIdentity()) {
            this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        }
        return true;
    }

    protected boolean processBeforeQueryInsert(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, InsertOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.assertObjectNotNull("intoCB", intoCB);
        if (resourceCB == null) {
            String msg = "The set-upper of query-insert should return a condition-bean for resource table:";
            msg = msg + " inserted=" + entity.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.frameworkFilterEntityOfInsert(entity, option);
        this.setupExclusiveControlColumnOfQueryInsert(entity);
        this.filterEntityOfInsert(entity, option);
        this.assertEntityOfInsert(entity, option);
        return true;
    }

    protected void setupExclusiveControlColumnOfQueryInsert(Entity entity) {
        ColumnInfo columnInfo;
        DBMeta dbmeta = this.getDBMeta();
        if (dbmeta.hasVersionNo()) {
            columnInfo = dbmeta.getVersionNoColumnInfo();
            columnInfo.write(entity, InsertOption.VERSION_NO_FIRST_VALUE);
        }
        if (dbmeta.hasUpdateDate()) {
            columnInfo = dbmeta.getUpdateDateColumnInfo();
            columnInfo.write(entity, ResourceContext.getAccessTimestamp());
        }
    }

    protected void frameworkFilterEntityOfInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.injectSequenceToPrimaryKeyIfNeeds(entity);
        this.setupCommonColumnOfInsertIfNeeds(entity, option);
    }

    protected void setupCommonColumnOfInsertIfNeeds(Entity entity, InsertOption<? extends ConditionBean> option) {
        if (option != null && option.isCommonColumnAutoSetupDisabled()) {
            return;
        }
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfInsertIfNeeds(entity);
    }

    private void assertCommonColumnAutoSetupperNotNull() {
        if (this._commonColumnAutoSetupper != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the auto set-upper of common column in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        br.addElement("commonColumnAutoSetupper : " + this._commonColumnAutoSetupper);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    @Override
    protected void filterEntityOfInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
    }

    protected void assertEntityOfInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
    }

    protected void assertInsertOptionNotNull(InsertOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option (for insert)", option);
    }

    protected void assertInsertOptionStatus(InsertOption<? extends ConditionBean> option) {
        if (option.isCommonColumnAutoSetupDisabled() && !this.getDBMeta().hasCommonColumn()) {
            String msg = "The common column auto-setup disabling was set to the table not defined common columns:";
            msg = msg + " table=" + this.getTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
        if (option.isPrimaryKeyIdentityDisabled() && !this.getDBMeta().hasIdentity()) {
            String msg = "The identity disabling was set to the table not defined identity:";
            msg = msg + " table=" + this.getTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
    }

    protected boolean processBeforeUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfUpdate(entity, option);
        this.filterEntityOfUpdate(entity, option);
        this.assertEntityOfUpdate(entity, option);
        return true;
    }

    protected boolean processBeforeQueryUpdate(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        this.assertEntityNotNull(entity);
        this.assertCBStateValid(cb);
        this.frameworkFilterEntityOfUpdate(entity, option);
        this.filterEntityOfUpdate(entity, option);
        this.assertEntityOfUpdate(entity, option);
        this.assertQueryUpdateStatus(entity, cb, option);
        return true;
    }

    protected void frameworkFilterEntityOfUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.setupCommonColumnOfUpdateIfNeeds(entity, option);
    }

    protected void setupCommonColumnOfUpdateIfNeeds(Entity entity, UpdateOption<? extends ConditionBean> option) {
        if (option != null && option.isCommonColumnAutoSetupDisabled()) {
            return;
        }
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfUpdateIfNeeds(entity);
    }

    protected void filterEntityOfUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
    }

    protected void assertEntityOfUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
    }

    protected void assertUpdateColumnSpecificationNotNull(SpecifyQuery<? extends ConditionBean> updateColumnSpec) {
        this.assertObjectNotNull("updateColumnSpec", updateColumnSpec);
    }

    protected void assertUpdateOptionNotNull(UpdateOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option (for update)", option);
    }

    protected void assertUpdateOptionStatus(UpdateOption<? extends ConditionBean> option) {
        if (option.isCommonColumnAutoSetupDisabled() && !this.getDBMeta().hasCommonColumn()) {
            String msg = "The common column auto-setup disabling was set to the table not defined common columns:";
            msg = msg + " table=" + this.getTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertQueryUpdateStatus(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        if (option != null && option.isNonQueryUpdateAllowed()) {
            return;
        }
        if (cb.hasSelectAllPossible()) {
            this.createBhvExThrower().throwNonQueryUpdateNotAllowedException(entity, cb, option);
        }
    }

    protected boolean processBeforeDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfDelete(entity, option);
        this.filterEntityOfDelete(entity, option);
        this.assertEntityOfDelete(entity, option);
        return true;
    }

    protected boolean processBeforeQueryDelete(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        this.assertCBStateValid(cb);
        this.assertQueryDeleteStatus(cb, option);
        return true;
    }

    protected void frameworkFilterEntityOfDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
    }

    protected void filterEntityOfDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
    }

    protected void assertEntityOfDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
    }

    protected void assertDeleteOptionNotNull(DeleteOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option (for delete)", option);
    }

    protected void assertDeleteOptionStatus(DeleteOption<? extends ConditionBean> option) {
    }

    protected void assertQueryDeleteStatus(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        if (option != null && option.isNonQueryDeleteAllowed()) {
            return;
        }
        if (cb.hasSelectAllPossible()) {
            this.createBhvExThrower().throwNonQueryDeleteNotAllowedException(cb, option);
        }
    }

    protected void injectSequenceToPrimaryKeyIfNeeds(Entity entity) {
        DBMeta dbmeta = entity.getDBMeta();
        if (!dbmeta.hasSequence() || dbmeta.hasCompoundPrimaryKey() || entity.hasPrimaryKeyValue()) {
            return;
        }
        dbmeta.getPrimaryUniqueInfo().getFirstColumn().write(entity, this.readNextVal());
    }

    protected <CB extends ConditionBean> UpdateOption<CB> createSpecifiedUpdateOption(SpecifyQuery<CB> updateColumnSpec) {
        this.assertUpdateColumnSpecificationNotNull(updateColumnSpec);
        UpdateOption<CB> option = new UpdateOption<CB>();
        option.specify(updateColumnSpec);
        return option;
    }

    protected void assertEntityHasOptimisticLockValue(Entity entity) {
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
    }

    protected void assertEntityHasVersionNoValue(Entity entity) {
        if (!this.getDBMeta().hasVersionNo()) {
            return;
        }
        if (this.hasVersionNoValue(entity)) {
            return;
        }
        this.throwVersionNoValueNullException(entity);
    }

    protected void throwVersionNoValueNullException(Entity entity) {
        this.createBhvExThrower().throwVersionNoValueNullException(entity);
    }

    protected void assertEntityHasUpdateDateValue(Entity entity) {
        if (!this.getDBMeta().hasUpdateDate()) {
            return;
        }
        if (this.hasUpdateDateValue(entity)) {
            return;
        }
        this.throwUpdateDateValueNullException(entity);
    }

    protected void throwUpdateDateValueNullException(Entity entity) {
        this.createBhvExThrower().throwUpdateDateValueNullException(entity);
    }

    protected <ENTITY extends Entity> List<ENTITY> processBatchInternally(List<ENTITY> entityList, InsertOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("entityList", entityList);
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeInsert(entity, option)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> processBatchInternally(List<ENTITY> entityList, UpdateOption<? extends ConditionBean> option, boolean nonstrict) {
        this.assertObjectNotNull("entityList", entityList);
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeUpdate(entity, option)) continue;
            if (!nonstrict) {
                this.assertEntityHasOptimisticLockValue(entity);
            }
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> processBatchInternally(List<ENTITY> entityList, DeleteOption<? extends ConditionBean> option, boolean nonstrict) {
        this.assertObjectNotNull("entityList", entityList);
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeDelete(entity, option)) continue;
            if (!nonstrict) {
                this.assertEntityHasOptimisticLockValue(entity);
            }
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected UpdateEntityCommand createUpdateEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createUpdateEntityCommand");
        UpdateEntityCommand cmd = this.newUpdateEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateEntityCommand newUpdateEntityCommand() {
        return new UpdateEntityCommand();
    }

    protected UpdateNonstrictEntityCommand createUpdateNonstrictEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createUpdateNonstrictEntityCommand");
        UpdateNonstrictEntityCommand cmd = this.newUpdateNonstrictEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateNonstrictEntityCommand newUpdateNonstrictEntityCommand() {
        return new UpdateNonstrictEntityCommand();
    }

    protected DeleteEntityCommand createDeleteEntityCommand(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createDeleteEntityCommand");
        DeleteEntityCommand cmd = this.newDeleteEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected DeleteEntityCommand newDeleteEntityCommand() {
        return new DeleteEntityCommand();
    }

    protected DeleteNonstrictEntityCommand createDeleteNonstrictEntityCommand(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createDeleteNonstrictEntityCommand");
        DeleteNonstrictEntityCommand cmd = this.newDeleteNonstrictEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected DeleteNonstrictEntityCommand newDeleteNonstrictEntityCommand() {
        return new DeleteNonstrictEntityCommand();
    }

    protected BatchInsertCommand createBatchInsertCommand(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchInsertCommand");
        BatchInsertCommand cmd = this.newBatchInsertCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected BatchInsertCommand newBatchInsertCommand() {
        return new BatchInsertCommand();
    }

    protected BatchUpdateCommand createBatchUpdateCommand(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchUpdateCommand");
        BatchUpdateCommand cmd = this.newBatchUpdateCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected BatchUpdateCommand newBatchUpdateCommand() {
        return new BatchUpdateCommand();
    }

    protected BatchUpdateNonstrictCommand createBatchUpdateNonstrictCommand(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchUpdateNonstrictCommand");
        BatchUpdateNonstrictCommand cmd = this.newBatchUpdateNonstrictCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected BatchUpdateNonstrictCommand newBatchUpdateNonstrictCommand() {
        return new BatchUpdateNonstrictCommand();
    }

    protected BatchDeleteCommand createBatchDeleteCommand(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchDeleteCommand");
        BatchDeleteCommand cmd = this.newBatchDeleteCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected BatchDeleteCommand newBatchDeleteCommand() {
        return new BatchDeleteCommand();
    }

    protected BatchDeleteNonstrictCommand createBatchDeleteNonstrictCommand(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchDeleteNonstrictCommand");
        BatchDeleteNonstrictCommand cmd = this.newBatchDeleteNonstrictCommand();
        this.xsetupListEntityCommand(cmd, entityList);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected BatchDeleteNonstrictCommand newBatchDeleteNonstrictCommand() {
        return new BatchDeleteNonstrictCommand();
    }

    protected void xsetupListEntityCommand(AbstractListEntityCommand command, List<? extends Entity> entityList) {
        if (entityList.isEmpty()) {
            String msg = "The argument 'entityList' should not be empty: " + entityList;
            throw new IllegalStateException(msg);
        }
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entityList.get(0).getClass());
        command.setEntityList(entityList);
    }

    protected QueryInsertCBCommand createQueryInsertCBCommand(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryInsertCBCommand");
        QueryInsertCBCommand cmd = new QueryInsertCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        cmd.setIntoConditionBean(intoCB);
        cmd.setConditionBean(resourceCB);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected QueryUpdateCBCommand createQueryUpdateCBCommand(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryUpdateCBCommand");
        QueryUpdateCBCommand cmd = new QueryUpdateCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        cmd.setConditionBean(cb);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected QueryDeleteCBCommand createQueryDeleteCBCommand(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryDeleteCBCommand");
        QueryDeleteCBCommand cmd = new QueryDeleteCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBean(cb);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected CommonColumnAutoSetupper getCommonColumnAutoSetupper() {
        return this._commonColumnAutoSetupper;
    }

    public void setCommonColumnAutoSetupper(CommonColumnAutoSetupper commonColumnAutoSetupper) {
        this._commonColumnAutoSetupper = commonColumnAutoSetupper;
    }

    protected static interface InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    protected static interface InternalDeleteNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    protected static interface InternalDeleteCallback<ENTITY extends Entity> {
        public int callbackDelegateDelete(ENTITY var1);
    }

    protected static interface InternalInsertOrUpdateNonstrictCallback<ENTITY extends Entity> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdateNonstrict(ENTITY var1);
    }

    protected static interface InternalInsertOrUpdateCallback<ENTITY extends Entity, CB_TYPE extends ConditionBean> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdate(ENTITY var1);

        public CB_TYPE callbackNewMyConditionBean();

        public int callbackSelectCount(CB_TYPE var1);
    }

    protected static interface InternalUpdateNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdateNonstrict(ENTITY var1);
    }

    protected static interface InternalUpdateCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdate(ENTITY var1);
    }
}

