/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.dv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.grouping.AbstractGroupFacetCollector;
import org.apache.lucene.search.grouping.dv.GroupedFacetHit;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;
import org.apache.lucene.util.UnicodeUtil;

public abstract class DVGroupFacetCollector
extends AbstractGroupFacetCollector {
    final DocValues.Type groupDvType;
    final boolean groupDiskResident;
    final DocValues.Type facetFieldDvType;
    final boolean facetDiskResident;
    final List<GroupedFacetHit> groupedFacetHits;
    final SentinelIntSet segmentGroupedFacetHits;

    public static DVGroupFacetCollector createDvGroupFacetCollector(String groupField, DocValues.Type groupDvType, boolean groupDiskResident, String facetField, DocValues.Type facetDvType, boolean facetDiskResident, BytesRef facetPrefix, int initialSize) {
        switch (groupDvType) {
            case VAR_INTS: 
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: 
            case FLOAT_32: 
            case FLOAT_64: 
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_VAR_DEREF: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Group valueType %s not supported", groupDvType));
            }
            case BYTES_VAR_SORTED: 
            case BYTES_FIXED_SORTED: {
                return GroupSortedBR.createGroupSortedFacetCollector(groupField, groupDvType, groupDiskResident, facetField, facetDvType, facetDiskResident, facetPrefix, initialSize);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Group valueType %s not supported", groupDvType));
    }

    DVGroupFacetCollector(String groupField, DocValues.Type groupDvType, boolean groupDiskResident, String facetField, DocValues.Type facetFieldDvType, boolean facetDiskResident, BytesRef facetPrefix, int initialSize) {
        super(groupField, facetField, facetPrefix);
        this.groupDvType = groupDvType;
        this.groupDiskResident = groupDiskResident;
        this.facetFieldDvType = facetFieldDvType;
        this.facetDiskResident = facetDiskResident;
        this.groupedFacetHits = new ArrayList<GroupedFacetHit>(initialSize);
        this.segmentGroupedFacetHits = new SentinelIntSet(initialSize, -1);
    }

    static abstract class GroupSortedBR
    extends DVGroupFacetCollector {
        final BytesRef facetSpare = new BytesRef();
        final BytesRef groupSpare = new BytesRef();
        DocValues.SortedSource groupFieldSource;

        GroupSortedBR(String groupField, DocValues.Type groupDvType, boolean groupDiskResident, String facetField, DocValues.Type facetFieldDvType, boolean facetDiskResident, BytesRef facetPrefix, int initialSize) {
            super(groupField, groupDvType, groupDiskResident, facetField, facetFieldDvType, facetDiskResident, facetPrefix, initialSize);
        }

        static DVGroupFacetCollector createGroupSortedFacetCollector(String groupField, DocValues.Type groupDvType, boolean groupDiskResident, String facetField, DocValues.Type facetDvType, boolean facetDiskResident, BytesRef facetPrefix, int initialSize) {
            switch (facetDvType) {
                case VAR_INTS: 
                case FIXED_INTS_8: 
                case FIXED_INTS_16: 
                case FIXED_INTS_32: 
                case FIXED_INTS_64: 
                case FLOAT_32: 
                case FLOAT_64: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_FIXED_DEREF: 
                case BYTES_VAR_STRAIGHT: 
                case BYTES_VAR_DEREF: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Facet valueType %s not supported", facetDvType));
                }
                case BYTES_VAR_SORTED: 
                case BYTES_FIXED_SORTED: {
                    return new FacetSortedBR(groupField, groupDvType, groupDiskResident, facetField, facetDvType, facetDiskResident, facetPrefix, initialSize);
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Facet valueType %s not supported", facetDvType));
        }

        static class FacetSortedBR
        extends GroupSortedBR {
            private DocValues.SortedSource facetFieldSource;

            FacetSortedBR(String groupField, DocValues.Type groupDvType, boolean groupDiskResident, String facetField, DocValues.Type facetDvType, boolean diskResident, BytesRef facetPrefix, int initialSize) {
                super(groupField, groupDvType, groupDiskResident, facetField, facetDvType, diskResident, facetPrefix, initialSize);
            }

            public void collect(int doc) throws IOException {
                int facetOrd = this.facetFieldSource.ord(doc);
                if (facetOrd < this.startFacetOrd || facetOrd >= this.endFacetOrd) {
                    return;
                }
                int groupOrd = this.groupFieldSource.ord(doc);
                int segmentGroupedFacetsIndex = groupOrd * this.facetFieldSource.getValueCount() + facetOrd;
                if (this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex)) {
                    return;
                }
                ++this.segmentTotalCount;
                int n = facetOrd;
                this.segmentFacetCounts[n] = this.segmentFacetCounts[n] + 1;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
                this.groupedFacetHits.add(new GroupedFacetHit(this.groupFieldSource.getByOrd(groupOrd, new BytesRef()), this.facetFieldSource.getByOrd(facetOrd, new BytesRef())));
            }

            public void setNextReader(AtomicReaderContext context) throws IOException {
                if (this.segmentFacetCounts != null) {
                    this.segmentResults.add(this.createSegmentResult());
                }
                this.groupFieldSource = this.getDocValuesSortedSource(this.groupField, this.groupDvType, this.groupDiskResident, context.reader());
                this.facetFieldSource = this.getDocValuesSortedSource(this.facetField, this.facetFieldDvType, this.facetDiskResident, context.reader());
                this.segmentFacetCounts = new int[this.facetFieldSource.getValueCount()];
                this.segmentTotalCount = 0;
                this.segmentGroupedFacetHits.clear();
                for (GroupedFacetHit groupedFacetHit : this.groupedFacetHits) {
                    int groupOrd;
                    int facetOrd = this.facetFieldSource.getOrdByValue(groupedFacetHit.facetValue, this.facetSpare);
                    if (facetOrd < 0 || (groupOrd = this.groupFieldSource.getOrdByValue(groupedFacetHit.groupValue, this.groupSpare)) < 0) continue;
                    int segmentGroupedFacetsIndex = groupOrd * this.facetFieldSource.getValueCount() + facetOrd;
                    this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
                }
                if (this.facetPrefix != null) {
                    this.startFacetOrd = this.facetFieldSource.getOrdByValue(this.facetPrefix, this.facetSpare);
                    if (this.startFacetOrd < 0) {
                        this.startFacetOrd = -this.startFacetOrd - 1;
                    }
                    BytesRef facetEndPrefix = BytesRef.deepCopyOf((BytesRef)this.facetPrefix);
                    facetEndPrefix.append(UnicodeUtil.BIG_TERM);
                    this.endFacetOrd = this.facetFieldSource.getOrdByValue(facetEndPrefix, this.facetSpare);
                    this.endFacetOrd = -this.endFacetOrd - 1;
                } else {
                    this.startFacetOrd = 0;
                    this.endFacetOrd = this.facetFieldSource.getValueCount();
                }
            }

            @Override
            protected SegmentResult createSegmentResult() throws IOException {
                if (this.startFacetOrd == 0 && this.facetFieldSource.getByOrd((int)this.startFacetOrd, (BytesRef)this.facetSpare).length == 0) {
                    int missing = this.segmentFacetCounts[0];
                    int total = this.segmentTotalCount - this.segmentFacetCounts[0];
                    return new SegmentResult(this.segmentFacetCounts, total, missing, this.facetFieldSource, this.endFacetOrd);
                }
                return new SegmentResult(this.segmentFacetCounts, this.segmentTotalCount, this.facetFieldSource, this.startFacetOrd, this.endFacetOrd);
            }

            private DocValues.SortedSource getDocValuesSortedSource(String field, DocValues.Type dvType, boolean diskResident, AtomicReader reader) throws IOException {
                DocValues dv = reader.docValues(field);
                Object dvSource = dv != null ? (diskResident ? dv.getDirectSource() : dv.getSource()) : DocValues.getDefaultSortedSource((DocValues.Type)dvType, (int)reader.maxDoc());
                return dvSource.asSortedSource();
            }

            private static class SegmentResult
            extends AbstractGroupFacetCollector.SegmentResult {
                final DocValues.SortedSource facetFieldSource;
                final BytesRef spare = new BytesRef();

                SegmentResult(int[] counts, int total, int missing, DocValues.SortedSource facetFieldSource, int endFacetOrd) {
                    super(counts, total, missing, endFacetOrd);
                    this.facetFieldSource = facetFieldSource;
                    this.mergePos = 1;
                    if (this.mergePos < this.maxTermPos) {
                        this.mergeTerm = facetFieldSource.getByOrd(this.mergePos, this.spare);
                    }
                }

                SegmentResult(int[] counts, int total, DocValues.SortedSource facetFieldSource, int startFacetOrd, int endFacetOrd) {
                    super(counts, total, 0, endFacetOrd);
                    this.facetFieldSource = facetFieldSource;
                    this.mergePos = startFacetOrd;
                    if (this.mergePos < this.maxTermPos) {
                        this.mergeTerm = facetFieldSource.getByOrd(this.mergePos, this.spare);
                    }
                }

                @Override
                protected void nextTerm() throws IOException {
                    this.mergeTerm = this.facetFieldSource.getByOrd(this.mergePos, this.spare);
                }
            }
        }
    }
}

