/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.Assert;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util._TestUtil;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.util.AbstractSolrTestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDistributedSearchTestCase
extends SolrTestCaseJ4 {
    public static Random r;
    protected int shardCount = 4;
    protected boolean fixShardCount = false;
    protected JettySolrRunner controlJetty;
    protected List<SolrServer> clients = new ArrayList<SolrServer>();
    protected List<JettySolrRunner> jettys = new ArrayList<JettySolrRunner>();
    protected String context;
    protected String[] deadServers;
    protected String shards;
    protected String[] shardsArr;
    protected File testDir;
    protected SolrServer controlClient;
    protected int stress = TEST_NIGHTLY ? 2 : 0;
    protected boolean verifyStress = true;
    protected int nThreads = 3;
    public static int ORDERED;
    public static int SKIP;
    public static int SKIPVAL;
    public static int UNORDERED;
    protected int flags;
    protected Map<String, Integer> handle = new HashMap<String, Integer>();
    protected String id = "id";
    public static Logger log;
    public static RandVal rint;
    public static RandVal rlong;
    public static RandVal rfloat;
    public static RandVal rdouble;
    public static RandVal rdate;
    public static String[] fieldNames;
    public static RandVal[] randVals;

    @BeforeClass
    public static void initialize() {
        BaseDistributedSearchTestCase.assumeFalse((String)"SOLR-4147: ibm 64bit has jvm bugs!", (Constants.JRE_IS_64BIT && Constants.JAVA_VENDOR.startsWith("IBM") ? 1 : 0) != 0);
        r = new Random(BaseDistributedSearchTestCase.random().nextLong());
    }

    @BeforeClass
    public static void initHostContext() {
        StringBuilder hostContext = new StringBuilder("/");
        if (BaseDistributedSearchTestCase.random().nextBoolean()) {
            hostContext.append(_TestUtil.randomSimpleString((Random)BaseDistributedSearchTestCase.random(), (int)2));
            if (BaseDistributedSearchTestCase.random().nextBoolean()) {
                hostContext.append("_");
            }
            hostContext.append(_TestUtil.randomSimpleString((Random)BaseDistributedSearchTestCase.random(), (int)3));
            if (!"/".equals(hostContext)) {
                hostContext.append("/").append(_TestUtil.randomSimpleString((Random)BaseDistributedSearchTestCase.random(), (int)2));
            }
        }
        String hc = hostContext.toString().replaceAll("\\/+", "/");
        log.info("Setting hostContext system property: " + hc);
        System.setProperty("hostContext", hc);
    }

    @AfterClass
    public static void clearHostContext() throws Exception {
        System.clearProperty("hostContext");
    }

    private static String getHostContextSuitableForServletContext() {
        String ctx = System.getProperty("hostContext", "/solr");
        if ("".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    protected BaseDistributedSearchTestCase() {
        this(BaseDistributedSearchTestCase.getHostContextSuitableForServletContext());
    }

    protected BaseDistributedSearchTestCase(String context) {
        this.context = context;
        this.deadServers = new String[]{"[ff01::114]:33332" + context, "[ff01::083]:33332" + context, "[ff01::213]:33332" + context};
    }

    public abstract void doTest() throws Exception;

    protected String[] getFieldNames() {
        return fieldNames;
    }

    protected RandVal[] getRandValues() {
        return randVals;
    }

    public String getSolrHome() {
        return SolrTestCaseJ4.TEST_HOME();
    }

    @Override
    public void setUp() throws Exception {
        SolrTestCaseJ4.resetExceptionIgnores();
        super.setUp();
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        this.testDir = new File(TEMP_DIR, ((Object)((Object)this)).getClass().getName() + "-" + System.currentTimeMillis());
        this.testDir.mkdirs();
    }

    @Override
    public void tearDown() throws Exception {
        this.destroyServers();
        if (!AbstractSolrTestCase.recurseDelete(this.testDir)) {
            System.err.println("!!!! WARNING: best effort to remove " + this.testDir.getAbsolutePath() + " FAILED !!!!!");
        }
        FieldCache.DEFAULT.purgeAllCaches();
        super.tearDown();
    }

    protected void createServers(int numShards) throws Exception {
        this.controlJetty = this.createJetty(new File(this.getSolrHome()), this.testDir + "/control/data", null, BaseDistributedSearchTestCase.getSolrConfigFile(), BaseDistributedSearchTestCase.getSchemaFile());
        this.controlClient = this.createNewSolrServer(this.controlJetty.getLocalPort());
        this.shardsArr = new String[numShards];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numShards; ++i) {
            String shardStr;
            if (sb.length() > 0) {
                sb.append(',');
            }
            JettySolrRunner j = this.createJetty(new File(this.getSolrHome()), this.testDir + "/shard" + i + "/data", null, BaseDistributedSearchTestCase.getSolrConfigFile(), BaseDistributedSearchTestCase.getSchemaFile());
            this.jettys.add(j);
            this.clients.add(this.createNewSolrServer(j.getLocalPort()));
            this.shardsArr[i] = shardStr = "127.0.0.1:" + j.getLocalPort() + this.context;
            sb.append(shardStr);
        }
        this.shards = sb.toString();
    }

    protected void setDistributedParams(ModifiableSolrParams params) {
        params.set("shards", new String[]{this.getShardsString()});
    }

    protected String getShardsString() {
        if (this.deadServers == null) {
            return this.shards;
        }
        StringBuilder sb = new StringBuilder();
        for (String shard : this.shardsArr) {
            int nDeadServers;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if ((nDeadServers = r.nextInt(this.deadServers.length + 1)) > 0) {
                ArrayList<String> replicas = new ArrayList<String>(Arrays.asList(this.deadServers));
                Collections.shuffle(replicas, r);
                replicas.add(r.nextInt(nDeadServers + 1), shard);
                for (int i = 0; i < nDeadServers + 1; ++i) {
                    if (i != 0) {
                        sb.append('|');
                    }
                    sb.append((String)replicas.get(i));
                }
                continue;
            }
            sb.append(shard);
        }
        return sb.toString();
    }

    protected void destroyServers() throws Exception {
        this.controlJetty.stop();
        ((HttpSolrServer)this.controlClient).shutdown();
        for (JettySolrRunner jetty : this.jettys) {
            jetty.stop();
        }
        for (SolrServer client : this.clients) {
            ((HttpSolrServer)client).shutdown();
        }
        this.clients.clear();
        this.jettys.clear();
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir) throws Exception {
        return this.createJetty(solrHome, dataDir, null, null, null);
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardId) throws Exception {
        return this.createJetty(solrHome, dataDir, shardId, null, null);
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride) throws Exception {
        JettySolrRunner jetty = new JettySolrRunner(solrHome.getAbsolutePath(), this.context, 0, solrConfigOverride, schemaOverride);
        jetty.setShards(shardList);
        jetty.setDataDir(dataDir);
        jetty.start();
        return jetty;
    }

    protected SolrServer createNewSolrServer(int port) {
        try {
            String url = "http://127.0.0.1:" + port + this.context;
            HttpSolrServer s = new HttpSolrServer(url);
            s.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
            s.setSoTimeout(60000);
            s.setDefaultMaxConnectionsPerHost(100);
            s.setMaxTotalConnections(100);
            return s;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void addFields(SolrInputDocument doc, Object ... fields) {
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
    }

    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        this.addFields(doc, fields);
        this.addFields(doc, "rnd_b", true);
        this.addRandFields(doc);
        this.indexDoc(doc);
    }

    protected SolrInputDocument addRandFields(SolrInputDocument sdoc) {
        this.addFields(sdoc, BaseDistributedSearchTestCase.getRandFields(this.getFieldNames(), this.getRandValues()));
        return sdoc;
    }

    protected void index(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        this.addFields(doc, fields);
        this.indexDoc(doc);
    }

    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.controlClient.add(doc);
        int which = (doc.getField(this.id).toString().hashCode() & Integer.MAX_VALUE) % this.clients.size();
        SolrServer client = this.clients.get(which);
        client.add(doc);
    }

    protected UpdateResponse add(SolrServer server, SolrParams params, SolrInputDocument ... sdocs) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (SolrInputDocument sdoc : sdocs) {
            ureq.add(sdoc);
        }
        return ureq.process(server);
    }

    protected UpdateResponse del(SolrServer server, SolrParams params, Object ... ids) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (Object id : ids) {
            ureq.deleteById(id.toString());
        }
        return ureq.process(server);
    }

    protected UpdateResponse delQ(SolrServer server, SolrParams params, String ... queries) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (String q : queries) {
            ureq.deleteByQuery(q);
        }
        return ureq.process(server);
    }

    protected void index_specific(int serverNumber, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        this.controlClient.add(doc);
        SolrServer client = this.clients.get(serverNumber);
        client.add(doc);
    }

    protected void del(String q) throws Exception {
        this.controlClient.deleteByQuery(q);
        for (SolrServer client : this.clients) {
            client.deleteByQuery(q);
        }
    }

    protected void commit() throws Exception {
        this.controlClient.commit();
        for (SolrServer client : this.clients) {
            client.commit();
        }
    }

    protected QueryResponse queryServer(ModifiableSolrParams params) throws SolrServerException {
        int which = r.nextInt(this.clients.size());
        SolrServer client = this.clients.get(which);
        QueryResponse rsp = client.query((SolrParams)params);
        return rsp;
    }

    protected void query(Object ... q) throws Exception {
        this.query(true, q);
    }

    protected void query(boolean setDistribParams, Object[] q) throws Exception {
        final ModifiableSolrParams params = new ModifiableSolrParams();
        for (int i = 0; i < q.length; i += 2) {
            params.add(q[i].toString(), new String[]{q[i + 1].toString()});
        }
        params.set("distrib", new String[]{"false"});
        final QueryResponse controlRsp = this.controlClient.query((SolrParams)params);
        this.validateControlData(controlRsp);
        params.remove("distrib");
        if (setDistribParams) {
            this.setDistributedParams(params);
        }
        QueryResponse rsp = this.queryServer(params);
        this.compareResponses(rsp, controlRsp);
        if (this.stress > 0) {
            log.info("starting stress...");
            Thread[] threads = new Thread[this.nThreads];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        for (int j = 0; j < BaseDistributedSearchTestCase.this.stress; ++j) {
                            int which = r.nextInt(BaseDistributedSearchTestCase.this.clients.size());
                            SolrServer client = BaseDistributedSearchTestCase.this.clients.get(which);
                            try {
                                QueryResponse rsp = client.query((SolrParams)new ModifiableSolrParams((SolrParams)params));
                                if (!BaseDistributedSearchTestCase.this.verifyStress) continue;
                                BaseDistributedSearchTestCase.this.compareResponses(rsp, controlRsp);
                                continue;
                            }
                            catch (SolrServerException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                };
                threads[i].start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
        }
    }

    public QueryResponse queryAndCompare(SolrParams params, SolrServer ... servers) throws SolrServerException {
        QueryResponse first = null;
        for (SolrServer server : servers) {
            QueryResponse rsp = server.query((SolrParams)new ModifiableSolrParams(params));
            if (first == null) {
                first = rsp;
                continue;
            }
            this.compareResponses(first, rsp);
        }
        return first;
    }

    public static boolean eq(String a, String b) {
        return a == b || a != null && a.equals(b);
    }

    public static int flags(Map<String, Integer> handle, Object key) {
        if (handle == null) {
            return 0;
        }
        Integer f = handle.get(key);
        return f == null ? 0 : f;
    }

    public static String compare(NamedList a, NamedList b, int flags, Map<String, Integer> handle) {
        boolean ordered;
        boolean bl = ordered = (flags & UNORDERED) == 0;
        if (!ordered) {
            HashMap<String, Object> mapA = new HashMap<String, Object>(a.size());
            for (int i = 0; i < a.size(); ++i) {
                Object prev = mapA.put(a.getName(i), a.getVal(i));
            }
            HashMap<String, Object> mapB = new HashMap<String, Object>(b.size());
            for (int i = 0; i < b.size(); ++i) {
                Object prev = mapB.put(b.getName(i), b.getVal(i));
            }
            return BaseDistributedSearchTestCase.compare(mapA, mapB, flags, handle);
        }
        int posa = 0;
        int posb = 0;
        int aSkipped = 0;
        int bSkipped = 0;
        while (posa < a.size() || posb < b.size()) {
            String cmp;
            String namea = null;
            String nameb = null;
            Object vala = null;
            Object valb = null;
            int flagsa = 0;
            int flagsb = 0;
            while (posa < a.size()) {
                namea = a.getName(posa);
                vala = a.getVal(posa);
                ++posa;
                flagsa = BaseDistributedSearchTestCase.flags(handle, namea);
                if ((flagsa & SKIP) == 0) break;
                namea = null;
                vala = null;
                ++aSkipped;
            }
            while (posb < b.size()) {
                nameb = b.getName(posb);
                valb = b.getVal(posb);
                ++posb;
                flagsb = BaseDistributedSearchTestCase.flags(handle, nameb);
                if ((flagsb & SKIP) != 0) {
                    nameb = null;
                    valb = null;
                    ++bSkipped;
                    continue;
                }
                if (BaseDistributedSearchTestCase.eq(namea, nameb)) break;
                return "." + namea + "!=" + nameb + " (unordered or missing)";
            }
            if ((flagsa & SKIPVAL) != 0 || (cmp = BaseDistributedSearchTestCase.compare(vala, valb, flagsa, handle)) == null) continue;
            return "." + namea + cmp;
        }
        if (a.size() - aSkipped != b.size() - bSkipped) {
            return ".size()==" + a.size() + "," + b.size() + " skipped=" + aSkipped + "," + bSkipped;
        }
        return null;
    }

    public static String compare1(Map a, Map b, int flags, Map<String, Integer> handle) {
        for (Object keya : a.keySet()) {
            Object valb;
            String cmp;
            Object vala = a.get(keya);
            int flagsa = BaseDistributedSearchTestCase.flags(handle, keya);
            if ((flagsa & SKIP) != 0) continue;
            if (!b.containsKey(keya)) {
                return "[" + keya + "]==null";
            }
            if ((flagsa & SKIPVAL) != 0 || (cmp = BaseDistributedSearchTestCase.compare(vala, valb = b.get(keya), flagsa, handle)) == null) continue;
            return "[" + keya + "]" + cmp;
        }
        return null;
    }

    public static String compare(Map a, Map b, int flags, Map<String, Integer> handle) {
        String cmp = BaseDistributedSearchTestCase.compare1(a, b, flags, handle);
        if (cmp != null) {
            return cmp;
        }
        return BaseDistributedSearchTestCase.compare1(b, a, flags, handle);
    }

    public static String compare(SolrDocument a, SolrDocument b, int flags, Map<String, Integer> handle) {
        return BaseDistributedSearchTestCase.compare(a.getFieldValuesMap(), b.getFieldValuesMap(), flags, handle);
    }

    public static String compare(SolrDocumentList a, SolrDocumentList b, int flags, Map<String, Integer> handle) {
        String cmp;
        boolean ordered = (flags & UNORDERED) == 0;
        int f = BaseDistributedSearchTestCase.flags(handle, "maxScore");
        if ((f & SKIPVAL) == 0) {
            cmp = BaseDistributedSearchTestCase.compare(a.getMaxScore(), b.getMaxScore(), 0, handle);
            if (cmp != null) {
                return ".maxScore" + cmp;
            }
        } else if (b.getMaxScore() != null && a.getMaxScore() == null) {
            return ".maxScore missing";
        }
        if ((cmp = BaseDistributedSearchTestCase.compare(a.getNumFound(), b.getNumFound(), 0, handle)) != null) {
            return ".numFound" + cmp;
        }
        cmp = BaseDistributedSearchTestCase.compare(a.getStart(), b.getStart(), 0, handle);
        if (cmp != null) {
            return ".start" + cmp;
        }
        cmp = BaseDistributedSearchTestCase.compare(a.size(), b.size(), 0, handle);
        if (cmp != null) {
            return ".size()" + cmp;
        }
        if (ordered) {
            for (int i = 0; i < a.size(); ++i) {
                cmp = BaseDistributedSearchTestCase.compare((SolrDocument)a.get(i), (SolrDocument)b.get(i), 0, handle);
                if (cmp == null) continue;
                return "[" + i + "]" + cmp;
            }
            return null;
        }
        for (int i = 0; i < a.size(); ++i) {
            SolrDocument doc = (SolrDocument)a.get(i);
            Object key = doc.getFirstValue("id");
            SolrDocument docb = null;
            if (key == null) {
                docb = (SolrDocument)b.get(i);
            } else {
                for (int j = 0; j < b.size() && !key.equals((docb = (SolrDocument)b.get(j)).getFirstValue("id")); ++j) {
                }
            }
            cmp = BaseDistributedSearchTestCase.compare(doc, docb, 0, handle);
            if (cmp == null) continue;
            return "[id=" + key + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object[] a, Object[] b, int flags, Map<String, Integer> handle) {
        if (a.length != b.length) {
            return ".length:" + a.length + "!=" + b.length;
        }
        for (int i = 0; i < a.length; ++i) {
            String cmp = BaseDistributedSearchTestCase.compare(a[i], b[i], flags, handle);
            if (cmp == null) continue;
            return "[" + i + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object a, Object b, int flags, Map<String, Integer> handle) {
        if (a == b) {
            return null;
        }
        if (a == null || b == null) {
            return ":" + a + "!=" + b;
        }
        if (a instanceof NamedList && b instanceof NamedList) {
            return BaseDistributedSearchTestCase.compare((NamedList)a, (NamedList)b, flags, handle);
        }
        if (a instanceof SolrDocumentList && b instanceof SolrDocumentList) {
            return BaseDistributedSearchTestCase.compare((SolrDocumentList)a, (SolrDocumentList)b, flags, handle);
        }
        if (a instanceof SolrDocument && b instanceof SolrDocument) {
            return BaseDistributedSearchTestCase.compare((SolrDocument)a, (SolrDocument)b, flags, handle);
        }
        if (a instanceof Map && b instanceof Map) {
            return BaseDistributedSearchTestCase.compare((Map)a, (Map)b, flags, handle);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return BaseDistributedSearchTestCase.compare((Object[])a, (Object[])b, flags, handle);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            if (!Arrays.equals((byte[])a, (byte[])b)) {
                return ":" + a + "!=" + b;
            }
            return null;
        }
        if (a instanceof List && b instanceof List) {
            return BaseDistributedSearchTestCase.compare(((List)a).toArray(), ((List)b).toArray(), flags, handle);
        }
        if (!a.equals(b)) {
            return ":" + a + "!=" + b;
        }
        return null;
    }

    protected void compareResponses(QueryResponse a, QueryResponse b) {
        String cmp;
        if (System.getProperty("remove.version.field") != null) {
            if (a.getResults() != null) {
                for (SolrDocument doc : a.getResults()) {
                    doc.removeFields("_version_");
                }
            }
            if (b.getResults() != null) {
                for (SolrDocument doc : b.getResults()) {
                    doc.removeFields("_version_");
                }
            }
        }
        if ((cmp = BaseDistributedSearchTestCase.compare(a.getResponse(), b.getResponse(), this.flags, this.handle)) != null) {
            log.error("Mismatched responses:\n" + a + "\n" + b);
            Assert.fail((String)cmp);
        }
    }

    @Test
    public void testDistribSearch() throws Exception {
        if (this.fixShardCount) {
            this.createServers(this.shardCount);
            RandVal.uniqueValues = new HashSet();
            this.doTest();
            this.destroyServers();
        } else {
            for (int nServers = 1; nServers < this.shardCount; ++nServers) {
                this.createServers(nServers);
                RandVal.uniqueValues = new HashSet();
                this.doTest();
                this.destroyServers();
            }
        }
    }

    public static Object[] getRandFields(String[] fields, RandVal[] randVals) {
        Object[] o = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            o[i * 2] = fields[i];
            o[i * 2 + 1] = randVals[i].uval();
        }
        return o;
    }

    public void validateControlData(QueryResponse control) throws Exception {
    }

    static {
        ORDERED = 1;
        SKIP = 2;
        SKIPVAL = 4;
        UNORDERED = 8;
        log = LoggerFactory.getLogger(BaseDistributedSearchTestCase.class);
        rint = new RandVal(){

            @Override
            public Object val() {
                return r.nextInt();
            }
        };
        rlong = new RandVal(){

            @Override
            public Object val() {
                return r.nextLong();
            }
        };
        rfloat = new RandVal(){

            @Override
            public Object val() {
                return Float.valueOf(r.nextFloat());
            }
        };
        rdouble = new RandVal(){

            @Override
            public Object val() {
                return r.nextDouble();
            }
        };
        rdate = new RandDate();
        fieldNames = new String[]{"n_ti1", "n_f1", "n_tf1", "n_d1", "n_td1", "n_l1", "n_tl1", "n_dt1", "n_tdt1"};
        randVals = new RandVal[]{rint, rfloat, rfloat, rdouble, rdouble, rlong, rlong, rdate, rdate};
    }

    public static class RandDate
    extends RandVal {
        public static TrieDateField df = new TrieDateField();

        @Override
        public Object val() {
            long v = r.nextLong();
            Date d = new Date(v);
            return df.toExternal(d);
        }
    }

    public static abstract class RandVal {
        public static Set uniqueValues = new HashSet();

        public abstract Object val();

        public Object uval() {
            Object v;
            while (!uniqueValues.add(v = this.val())) {
            }
            return v;
        }
    }
}

