/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.Flushable;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DOMElementFormatter
implements Formatter {
    public static final DOMElementFormatter INSTANCE = new DOMElementFormatter();

    DOMElementFormatter() {
    }

    public boolean format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        int n;
        int n2;
        Element element = (Element)object2;
        outputSource.append('[');
        StringFormatter.serialize(context, element.getTagName(), outputSource);
        outputSource.append(',');
        if (context.isPrettyPrint()) {
            outputSource.append('\n');
            n2 = context.getInitialIndent() + context.getDepth() + 1;
            for (n = 0; n < n2; ++n) {
                outputSource.append(context.getIndentText());
            }
        }
        outputSource.append('{');
        if (element.hasAttributes()) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                Node node;
                if (n != 0) {
                    outputSource.append(',');
                }
                if (context.isPrettyPrint() && namedNodeMap.getLength() > 1) {
                    outputSource.append('\n');
                    for (int i = 0; i < context.getDepth() + 2; ++i) {
                        outputSource.append('\t');
                    }
                }
                if (!((node = namedNodeMap.item(n)) instanceof Attr)) continue;
                StringFormatter.serialize(context, node.getNodeName(), outputSource);
                outputSource.append(':');
                if (context.isPrettyPrint()) {
                    outputSource.append(' ');
                }
                StringFormatter.serialize(context, node.getNodeValue(), outputSource);
            }
            if (context.isPrettyPrint() && namedNodeMap.getLength() > 1) {
                outputSource.append('\n');
                n = context.getInitialIndent() + context.getDepth() + 1;
                for (int i = 0; i < n; ++i) {
                    outputSource.append(context.getIndentText());
                }
            }
        }
        outputSource.append('}');
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            JSONHint jSONHint = context.getHint();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object3 = nodeList.item(i);
                if (!(object3 instanceof Element) && (!(object3 instanceof CharacterData) || object3 instanceof Comment)) continue;
                outputSource.append(',');
                if (context.isPrettyPrint()) {
                    outputSource.append('\n');
                    int n3 = context.getInitialIndent() + context.getDepth() + 1;
                    for (int j = 0; j < n3; ++j) {
                        outputSource.append(context.getIndentText());
                    }
                }
                context.enter(i + 2, jSONHint);
                object3 = context.preformatInternal(object3);
                context.formatInternal(object3, outputSource);
                context.exit();
                if (!(outputSource instanceof Flushable)) continue;
                ((Flushable)((Object)outputSource)).flush();
            }
        }
        if (context.isPrettyPrint()) {
            outputSource.append('\n');
            n2 = context.getInitialIndent() + context.getDepth();
            for (int i = 0; i < n2; ++i) {
                outputSource.append(context.getIndentText());
            }
        }
        outputSource.append(']');
        return true;
    }
}

