/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.digester.json;

import java.io.IOException;
import org.apache.uima.alchemy.digester.json.JsonParser;
import org.apache.uima.alchemy.digester.json.ParseException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

final class JsonXMLReader
implements XMLReader {
    private final String customRootElementName;
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public JsonXMLReader(String customRootElementName) {
        this.customRootElementName = customRootElementName;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        JsonParser jsonParser = new JsonParser(input.getByteStream());
        if (this.customRootElementName != null && this.customRootElementName.length() > 0) {
            jsonParser.setRootElementName(this.customRootElementName);
        }
        jsonParser.setContentHandler(this.contentHandler);
        try {
            jsonParser.json();
        }
        catch (ParseException e) {
            throw new SAXException("An error occurred while parsing JSON", e);
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }
}

