/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.search.suggest.fst.FSTCompletion;
import org.apache.lucene.search.suggest.fst.InMemorySorter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NoOutputs;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class FSTCompletionBuilder {
    public static final int DEFAULT_BUCKETS = 10;
    private final int buckets;
    FST<Object> automaton;
    private final BytesRefSorter sorter;
    private final BytesRef scratch = new BytesRef();
    private final int shareMaxTailLength;

    public FSTCompletionBuilder() {
        this(10, new InMemorySorter(BytesRef.getUTF8SortedAsUnicodeComparator()), Integer.MAX_VALUE);
    }

    public FSTCompletionBuilder(int buckets, BytesRefSorter sorter, int shareMaxTailLength) {
        if (buckets < 1 || buckets > 255) {
            throw new IllegalArgumentException("Buckets must be >= 1 and <= 255: " + buckets);
        }
        if (sorter == null) {
            throw new IllegalArgumentException("BytesRefSorter must not be null.");
        }
        this.sorter = sorter;
        this.buckets = buckets;
        this.shareMaxTailLength = shareMaxTailLength;
    }

    public void add(BytesRef utf8, int bucket) throws IOException {
        if (bucket < 0 || bucket >= this.buckets) {
            throw new IllegalArgumentException("Bucket outside of the allowed range [0, " + this.buckets + "): " + bucket);
        }
        if (this.scratch.bytes.length < utf8.length + 1) {
            this.scratch.grow(utf8.length + 10);
        }
        this.scratch.length = 1;
        this.scratch.bytes[0] = (byte)bucket;
        this.scratch.append(utf8);
        this.sorter.add(this.scratch);
    }

    public FSTCompletion build() throws IOException {
        this.automaton = this.buildAutomaton(this.sorter);
        if (this.sorter instanceof Closeable) {
            ((Closeable)((Object)this.sorter)).close();
        }
        return new FSTCompletion(this.automaton);
    }

    private FST<Object> buildAutomaton(BytesRefSorter sorter) throws IOException {
        BytesRef entry;
        NoOutputs outputs = NoOutputs.getSingleton();
        Object empty = outputs.getNoOutput();
        Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, 0, 0, true, true, this.shareMaxTailLength, (Outputs)outputs, null, false, true);
        BytesRef scratch = new BytesRef();
        IntsRef scratchIntsRef = new IntsRef();
        int count = 0;
        BytesRefIterator iter = sorter.iterator();
        while ((entry = iter.next()) != null) {
            ++count;
            if (scratch.compareTo(entry) == 0) continue;
            builder.add(Util.toIntsRef((BytesRef)entry, (IntsRef)scratchIntsRef), empty);
            scratch.copyBytes(entry);
        }
        return count == 0 ? null : builder.finish();
    }
}

