/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathParser$Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathParser$PathSection;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import java.util.Iterator;
import java.util.LinkedList;

class PathParser
implements Expression {
    private LinkedList indexes = new LinkedList();
    private LinkedList prefixes = new LinkedList();
    private LinkedList names = new LinkedList();
    private StringBuilder builder = new StringBuilder();
    private PathParser$Cache attributes = new PathParser$Cache(this);
    private PathParser$Cache elements = new PathParser$Cache(this);
    private String location;
    private String cache;
    private String path;
    private Type type;
    private boolean attribute;
    private char[] data;
    private int count;
    private int start;
    private int off;

    public PathParser(Type type, String string) {
        this.type = type;
        this.path = string;
        this.parse(string);
    }

    public boolean isEmpty() {
        return this.isEmpty(this.location);
    }

    public boolean isPath() {
        return this.names.size() > 1;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public int getIndex() {
        return (Integer)this.indexes.getFirst();
    }

    public String getPrefix() {
        return (String)this.prefixes.getFirst();
    }

    public String getFirst() {
        return (String)this.names.getFirst();
    }

    public String getLast() {
        return (String)this.names.getLast();
    }

    public String getPath() {
        return this.location;
    }

    public String getElement(String string) {
        String string2 = (String)this.elements.get(string);
        if (string2 == null && (string2 = this.getElementPath(this.location, string)) != null) {
            this.elements.put(string, string2);
        }
        return string2;
    }

    private String getElementPath(String string, String string2) {
        if (this.isEmpty(string2)) {
            return string;
        }
        if (this.isEmpty(string)) {
            return string2;
        }
        return string + "/" + string2 + "[1]";
    }

    public String getAttribute(String string) {
        String string2 = (String)this.attributes.get(string);
        if (string2 == null && (string2 = this.getAttributePath(this.location, string)) != null) {
            this.attributes.put(string, string2);
        }
        return string2;
    }

    private String getAttributePath(String string, String string2) {
        if (this.isEmpty(string)) {
            return string2;
        }
        return string + "/@" + string2;
    }

    public Iterator iterator() {
        return this.names.iterator();
    }

    public Expression getPath(int n) {
        return this.getPath(n, 0);
    }

    public Expression getPath(int n, int n2) {
        int n3 = this.names.size() - 1;
        if (n3 - n2 >= n) {
            return new PathParser$PathSection(this, n, n3 - n2);
        }
        return new PathParser$PathSection(this, n, n);
    }

    private void parse(String string) {
        if (string != null) {
            this.count = string.length();
            this.data = new char[this.count];
            string.getChars(0, this.count, this.data, 0);
        }
        this.path();
    }

    private void path() {
        if (this.data[this.off] == '/') {
            throw new PathException("Path '%s' in %s references document root", this.path, this.type);
        }
        if (this.data[this.off] == '.') {
            this.skip();
        }
        while (this.off < this.count) {
            if (this.attribute) {
                throw new PathException("Path '%s' in %s references an invalid attribute", this.path, this.type);
            }
            this.segment();
        }
        this.truncate();
        this.build();
    }

    private void build() {
        int n = this.names.size();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            String string = (String)this.names.get(i);
            int n3 = (Integer)this.indexes.get(i);
            if (i > 0) {
                this.builder.append('/');
            }
            if (this.attribute && i == n2) {
                this.builder.append('@');
                this.builder.append(string);
                continue;
            }
            this.builder.append(string);
            this.builder.append('[');
            this.builder.append(n3);
            this.builder.append(']');
        }
        this.location = this.builder.toString();
    }

    private void skip() {
        if (this.data.length > 1) {
            if (this.data[this.off + 1] != '/') {
                throw new PathException("Path '%s' in %s has an illegal syntax", this.path, this.type);
            }
            ++this.off;
        }
        this.start = ++this.off;
    }

    private void segment() {
        char c = this.data[this.off];
        if (c == '/') {
            throw new PathException("Invalid path expression '%s' in %s", this.path, this.type);
        }
        if (c == '@') {
            this.attribute();
        } else {
            this.element();
        }
        this.align();
    }

    private void element() {
        int n = this.off;
        int n2 = 0;
        while (this.off < this.count) {
            char c;
            if (!this.isValid(c = this.data[this.off++])) {
                if (c == '@') {
                    --this.off;
                    break;
                }
                if (c == '[') {
                    this.index();
                    break;
                }
                if (c == '/') break;
                throw new PathException("Illegal character '%s' in element for '%s' in %s", Character.valueOf(c), this.path, this.type);
            }
            ++n2;
        }
        this.insert(n, n2);
    }

    private void attribute() {
        int n = ++this.off;
        while (this.off < this.count) {
            char c;
            if (this.isValid(c = this.data[this.off++])) continue;
            throw new PathException("Illegal character '%s' in attribute for '%s' in %s", Character.valueOf(c), this.path, this.type);
        }
        if (this.off <= n) {
            throw new PathException("Attribute reference in '%s' for %s is empty", this.path, this.type);
        }
        this.attribute = true;
        this.insert(n, this.off - n);
    }

    private void index() {
        int n = 0;
        if (this.data[this.off - 1] == '[') {
            char c;
            while (this.off < this.count && this.isDigit(c = this.data[this.off++])) {
                n *= 10;
                n += c;
                n -= 48;
            }
        }
        if (this.data[this.off++ - 1] != ']') {
            throw new PathException("Invalid index for path '%s' in %s", this.path, this.type);
        }
        this.indexes.add(n);
    }

    private void truncate() {
        if (this.off - 1 >= this.data.length) {
            --this.off;
        } else if (this.data[this.off - 1] == '/') {
            --this.off;
        }
    }

    private void align() {
        int n;
        int n2 = this.names.size();
        if (n2 > (n = this.indexes.size())) {
            this.indexes.add(1);
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean isValid(char c) {
        return this.isLetter(c) || this.isSpecial(c);
    }

    private boolean isSpecial(char c) {
        return c == '_' || c == '-' || c == ':';
    }

    private boolean isLetter(char c) {
        return Character.isLetterOrDigit(c);
    }

    private void insert(int n, int n2) {
        String string = new String(this.data, n, n2);
        if (n2 > 0) {
            this.insert(string);
        }
    }

    private void insert(String string) {
        int n = string.indexOf(58);
        String string2 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        this.prefixes.add(string2);
        this.names.add(string);
    }

    public String toString() {
        int n = this.off - this.start;
        if (this.cache == null) {
            this.cache = new String(this.data, this.start, n);
        }
        return this.cache;
    }

    static /* synthetic */ boolean access$000(PathParser pathParser) {
        return pathParser.attribute;
    }

    static /* synthetic */ LinkedList access$100(PathParser pathParser) {
        return pathParser.names;
    }

    static /* synthetic */ String access$200(PathParser pathParser, String string, String string2) {
        return pathParser.getElementPath(string, string2);
    }

    static /* synthetic */ String access$300(PathParser pathParser, String string, String string2) {
        return pathParser.getAttributePath(string, string2);
    }

    static /* synthetic */ LinkedList access$400(PathParser pathParser) {
        return pathParser.indexes;
    }

    static /* synthetic */ LinkedList access$500(PathParser pathParser) {
        return pathParser.prefixes;
    }

    static /* synthetic */ String access$600(PathParser pathParser) {
        return pathParser.location;
    }

    static /* synthetic */ int access$700(PathParser pathParser) {
        return pathParser.start;
    }

    static /* synthetic */ int access$800(PathParser pathParser) {
        return pathParser.count;
    }

    static /* synthetic */ char[] access$900(PathParser pathParser) {
        return pathParser.data;
    }
}

