/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.InputSupplier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.OutputSupplier;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteStreams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] byArray, OutputSupplier outputSupplier) {
        Preconditions.checkNotNull(byArray);
        boolean bl = true;
        OutputStream outputStream = (OutputStream)outputSupplier.getOutput();
        try {
            outputStream.write(byArray);
            bl = false;
        }
        finally {
            Closeables.close(outputStream, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputSupplier inputSupplier, OutputSupplier outputSupplier) {
        boolean bl = true;
        InputStream inputStream = (InputStream)inputSupplier.getInput();
        try {
            long l;
            OutputStream outputStream = (OutputStream)outputSupplier.getOutput();
            try {
                long l2 = ByteStreams.copy(inputStream, outputStream);
                bl = false;
                l = l2;
            }
            catch (Throwable throwable) {
                Closeables.close(outputStream, bl);
                throw throwable;
            }
            Closeables.close(outputStream, bl);
            return l;
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteStreams.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputSupplier inputSupplier) {
        boolean bl = true;
        InputStream inputStream = (InputStream)inputSupplier.getInput();
        try {
            byte[] byArray = ByteStreams.toByteArray(inputStream);
            bl = false;
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            Closeables.close(inputStream, bl);
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) {
        ByteStreams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        if (ByteStreams.read(inputStream, byArray, n, n2) != n2) {
            throw new EOFException();
        }
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) != -1; n3 += n4) {
        }
        return n3;
    }
}

