/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.QParser;

public class StrField
extends PrimitiveFieldType {
    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.getName());
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.utf8ToString();
    }
}

