/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDouble;
import org.apache.solr.util.NumberUtils;

class SortableDoubleFieldSource
extends FieldCacheSource {
    protected double defVal;
    private static int hcode = SortableDoubleFieldSource.class.hashCode();

    public SortableDoubleFieldSource(String field) {
        this(field, 0.0);
    }

    public SortableDoubleFieldSource(String field, double defVal) {
        super(field);
        this.defVal = defVal;
    }

    public String description() {
        return "sdouble(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final double def = this.defVal;
        return new DocTermsIndexDocValues((ValueSource)this, readerContext, this.field){
            private final BytesRef spare;
            {
                super(x0, x1, x2);
                this.spare = new BytesRef();
            }

            protected String toTerm(String readableValue) {
                return NumberUtils.double2sortableStr(readableValue);
            }

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public int intVal(int doc) {
                return (int)this.doubleVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord == 0 ? def : NumberUtils.SortableStr2double(this.termsIndex.lookup(ord, this.spare));
            }

            public String strVal(int doc) {
                return Double.toString(this.doubleVal(doc));
            }

            public Object objectVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord == 0 ? null : Double.valueOf(NumberUtils.SortableStr2double(this.termsIndex.lookup(ord, this.spare)));
            }

            public String toString(int doc) {
                return SortableDoubleFieldSource.this.description() + '=' + this.doubleVal(doc);
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDouble mval = new MutableValueDouble();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        int ord = termsIndex.getOrd(doc);
                        if (ord == 0) {
                            this.mval.value = def;
                            this.mval.exists = false;
                        } else {
                            this.mval.value = NumberUtils.SortableStr2double(termsIndex.lookup(ord, spare));
                            this.mval.exists = true;
                        }
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof SortableDoubleFieldSource && super.equals(o) && this.defVal == ((SortableDoubleFieldSource)((Object)o)).defVal;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.defVal);
        int ibits = (int)(bits ^ bits >>> 32);
        return hcode + super.hashCode() + ibits;
    }
}

