/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.DateField;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    public static Logger log = LoggerFactory.getLogger(PingRequestHandler.class);
    public static final String HEALTHCHECK_FILE_PARAM = "healthcheckFile";
    private String healthFileName = null;
    private File healthcheck = null;

    @Override
    public void init(NamedList args) {
        super.init(args);
        Object tmp = args.get(HEALTHCHECK_FILE_PARAM);
        this.healthFileName = null == tmp ? null : tmp.toString();
    }

    @Override
    public void inform(SolrCore core) {
        if (null != this.healthFileName) {
            this.healthcheck = new File(this.healthFileName);
            if (!this.healthcheck.isAbsolute()) {
                this.healthcheck = new File(core.getDataDir(), this.healthFileName);
                this.healthcheck = this.healthcheck.getAbsoluteFile();
            }
            if (!this.healthcheck.getParentFile().canWrite()) {
                log.warn("Directory for configured healthcheck file is not writable by solr, PingRequestHandler will not be able to control enable/disable: {}", (Object)this.healthcheck.getParentFile().getAbsolutePath());
            }
        }
    }

    public boolean isPingDisabled() {
        return null != this.healthcheck && !this.healthcheck.exists();
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        Boolean distrib = params.getBool("distrib");
        if (distrib == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("distrib", false);
            req.setParams((SolrParams)mparams);
        }
        String actionParam = params.get("action");
        ACTIONS action = null;
        if (actionParam == null) {
            action = ACTIONS.PING;
        } else {
            try {
                action = ACTIONS.valueOf(actionParam.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException iae) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + actionParam);
            }
        }
        switch (action) {
            case PING: {
                if (this.isPingDisabled()) {
                    SolrException e = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Service disabled");
                    rsp.setException((Exception)((Object)e));
                    return;
                }
                this.handlePing(req, rsp);
                break;
            }
            case ENABLE: {
                this.handleEnable(true);
                break;
            }
            case DISABLE: {
                this.handleEnable(false);
                break;
            }
            case STATUS: {
                if (this.healthcheck == null) {
                    SolrException e = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "healthcheck not configured");
                    rsp.setException((Exception)((Object)e));
                    break;
                }
                rsp.add("status", this.isPingDisabled() ? "disabled" : "enabled");
            }
        }
    }

    protected void handlePing(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String qt;
        SolrParams params = req.getParams();
        SolrCore core = req.getCore();
        SolrRequestHandler handler = core.getRequestHandler(qt = params.get("qt"));
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown RequestHandler (qt): " + qt);
        }
        if (handler instanceof PingRequestHandler) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot execute the PingRequestHandler recursively");
        }
        Throwable ex = null;
        try {
            SolrQueryResponse pingrsp = new SolrQueryResponse();
            core.execute(handler, req, pingrsp);
            ex = pingrsp.getException();
        }
        catch (Throwable th) {
            ex = th;
        }
        if (ex != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Ping query caused exception: " + ex.getMessage(), ex);
        }
        rsp.add("status", "OK");
    }

    protected void handleEnable(boolean enable) throws SolrException {
        if (this.healthcheck == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No healthcheck file defined.");
        }
        if (enable) {
            try {
                FileUtils.write((File)this.healthcheck, (CharSequence)DateField.formatExternal(new Date()), (String)"UTF-8");
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to write healthcheck flag file", (Throwable)e);
            }
        } else if (this.healthcheck.exists() && !this.healthcheck.delete()) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Did not successfully delete healthcheck file: " + this.healthcheck.getAbsolutePath());
        }
    }

    @Override
    public String getDescription() {
        return "Reports application health to a load-balancer";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_1/solr/core/src/java/org/apache/solr/handler/PingRequestHandler.java $";
    }

    protected static enum ACTIONS {
        STATUS,
        ENABLE,
        DISABLE,
        PING;

    }
}

