/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.Config;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXMLSerializer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.jul.JulWatcher;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.SystemIdResolver;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CoreContainer {
    private static final String LEADER_VOTE_WAIT = "180000";
    private static final int CORE_LOAD_THREADS = 3;
    private static final String DEFAULT_HOST_CONTEXT = "solr";
    private static final String DEFAULT_HOST_PORT = "8983";
    private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 15000;
    public static final String DEFAULT_DEFAULT_CORE_NAME = "collection1";
    private static final boolean DEFAULT_SHARE_SCHEMA = false;
    protected static Logger log = LoggerFactory.getLogger(CoreContainer.class);
    private static final String CORE_NAME = "name";
    private static final String CORE_CONFIG = "config";
    private static final String CORE_INSTDIR = "instanceDir";
    private static final String CORE_DATADIR = "dataDir";
    private static final String CORE_ULOGDIR = "ulogDir";
    private static final String CORE_SCHEMA = "schema";
    private static final String CORE_SHARD = "shard";
    private static final String CORE_COLLECTION = "collection";
    private static final String CORE_ROLES = "roles";
    private static final String CORE_PROPERTIES = "properties";
    private static final String CORE_LOADONSTARTUP = "loadOnStartup";
    private static final String CORE_TRANSIENT = "transient";
    protected final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    protected Map<String, SolrCore> transientCores = new LinkedHashMap<String, SolrCore>();
    protected final Map<String, CoreDescriptor> dynamicDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    protected final Set<String> pendingDynamicCoreLoads = new HashSet<String>();
    protected final Map<String, Exception> coreInitFailures = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean persistent = false;
    protected String adminPath = null;
    protected String managementPath = null;
    protected String hostPort;
    protected String hostContext;
    protected String host;
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    protected File configFile = null;
    protected String libDir = null;
    protected ClassLoader libLoader = null;
    protected SolrResourceLoader loader = null;
    protected Properties containerProperties;
    protected Map<String, IndexSchema> indexSchemaCache;
    protected String adminHandler;
    protected boolean shareSchema;
    protected Integer zkClientTimeout;
    protected String solrHome;
    protected String defaultCoreName = null;
    private SolrXMLSerializer solrXMLSerializer = new SolrXMLSerializer();
    private ZkController zkController;
    private SolrZkServer zkServer;
    private ShardHandlerFactory shardHandlerFactory;
    protected LogWatcher logging = null;
    private String zkHost;
    private Map<SolrCore, String> coreToOrigName = new ConcurrentHashMap<SolrCore, String>();
    private String leaderVoteWait = "180000";
    private int distribUpdateConnTimeout = 0;
    private int distribUpdateSoTimeout = 0;
    protected int transientCacheSize = Integer.MAX_VALUE;
    private int coreLoadThreads;
    private volatile boolean isShutDown;
    private volatile Config cfg;
    private static final String DEF_SOLR_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>";

    @Deprecated
    public CoreContainer() {
        this(SolrResourceLoader.locateSolrHome());
    }

    public CoreContainer(String dir, File configFile) {
        this(dir);
        this.load(dir, configFile);
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(loader.getInstanceDir());
        this.loader = loader;
    }

    public CoreContainer(String solrHome) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = solrHome;
    }

    protected void initZooKeeper(String zkHost, int zkClientTimeout) {
        String zookeeperHost = zkHost == null ? System.getProperty("zkHost") : zkHost;
        String zkRun = System.getProperty("zkRun");
        if (zkRun == null && zookeeperHost == null) {
            return;
        }
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        if (zkRun != null) {
            String zkDataHome = System.getProperty("zkServerDataDir", this.solrHome + "zoo_data");
            String zkConfHome = System.getProperty("zkServerConfDir", this.solrHome);
            this.zkServer = new SolrZkServer(zkRun, zookeeperHost, zkDataHome, zkConfHome, this.hostPort);
            this.zkServer.parseConfig();
            this.zkServer.start();
            if (zookeeperHost == null) {
                zookeeperHost = this.zkServer.getClientString();
            }
        }
        int zkClientConnectTimeout = 15000;
        if (zookeeperHost != null) {
            try {
                if (zkRun != null && this.zkServer.getServers().size() > 1) {
                    zkClientConnectTimeout = 86400000;
                    log.info("Zookeeper client=" + zookeeperHost + "  Waiting for a quorum.");
                } else {
                    log.info("Zookeeper client=" + zookeeperHost);
                }
                String confDir = System.getProperty("bootstrap_confdir");
                boolean boostrapConf = Boolean.getBoolean("bootstrap_conf");
                if (!ZkController.checkChrootPath(zookeeperHost, confDir != null || boostrapConf)) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A chroot was specified in ZkHost but the znode doesn't exist. ");
                }
                this.zkController = new ZkController(this, zookeeperHost, zkClientTimeout, zkClientConnectTimeout, this.host, this.hostPort, this.hostContext, this.leaderVoteWait, this.distribUpdateConnTimeout, this.distribUpdateSoTimeout, new CurrentCoreDescriptorProvider(){

                    @Override
                    public List<CoreDescriptor> getCurrentDescriptors() {
                        ArrayList<CoreDescriptor> descriptors = new ArrayList<CoreDescriptor>(CoreContainer.this.getCoreNames().size());
                        for (SolrCore core : CoreContainer.this.getCores()) {
                            descriptors.add(core.getCoreDescriptor());
                        }
                        return descriptors;
                    }
                });
                if (zkRun != null && this.zkServer.getServers().size() > 1 && confDir == null && !boostrapConf) {
                    Thread.sleep(10000L);
                }
                if (confDir != null) {
                    File dir = new File(confDir);
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("bootstrap_confdir must be a directory of configuration files");
                    }
                    String confName = System.getProperty("collection.configName", "configuration1");
                    this.zkController.uploadConfigDir(dir, confName);
                }
                if (boostrapConf) {
                    ZkController.bootstrapConf(this.zkController.getZkClient(), this.cfg, this.solrHome);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("Could not connect to ZooKeeper", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getCoreProps(String instanceDir, String file, Properties defaults) {
        File corePropsFile;
        if (file == null) {
            file = "conf" + File.separator + "solrcore.properties";
        }
        if (!(corePropsFile = new File(file)).isAbsolute()) {
            corePropsFile = new File(instanceDir, file);
        }
        Properties p = defaults;
        if (corePropsFile.exists() && corePropsFile.isFile()) {
            p = new Properties(defaults);
            FileInputStream is = null;
            try {
                is = new FileInputStream(corePropsFile);
                p.load(is);
            }
            catch (IOException e) {
                try {
                    log.warn("Error loading properties ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return p;
    }

    private void allocateLazyCores(Config cfg) {
        this.transientCacheSize = cfg.getInt("solr/cores/@transientCacheSize", Integer.MAX_VALUE);
        if (this.transientCacheSize != Integer.MAX_VALUE) {
            this.transientCores = new LinkedHashMap<String, SolrCore>(this.transientCacheSize, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, SolrCore> eldest) {
                    if (this.size() > CoreContainer.this.transientCacheSize) {
                        eldest.getValue().close();
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    public void load(String dir, File configFile) {
        this.configFile = configFile;
        this.load(dir, new InputSource(configFile.toURI().toASCIIString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(String dir, InputSource cfgis) {
        String dcoreName;
        Config cfg;
        ThreadPoolExecutor coreLoadExecutor = null;
        if (null == dir) {
            dir = SolrResourceLoader.locateSolrHome();
        }
        log.info("Loading CoreContainer using Solr Home: '{}'", (Object)dir);
        this.loader = new SolrResourceLoader(dir);
        this.solrHome = this.loader.getInstanceDir();
        try {
            cfg = new Config(this.loader, null, cfgis, null, false);
            this.cfg = new Config(this.loader, null, this.copyDoc(cfg.getDocument()));
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        cfg.substituteProperties();
        this.initShardHandler(cfg);
        this.allocateLazyCores(cfg);
        if (cfg.getBool("solr/logging/@enabled", true)) {
            String slf4jImpl = null;
            String fname = cfg.get("solr/logging/watcher/@class", null);
            try {
                slf4jImpl = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
                if (fname == null) {
                    if (slf4jImpl.indexOf("Log4j") > 0) {
                        log.warn("Log watching is not yet implemented for log4j");
                    } else if (slf4jImpl.indexOf("JDK") > 0) {
                        fname = "JUL";
                    }
                }
            }
            catch (Throwable ex) {
                log.warn("Unable to read SLF4J version.  LogWatcher will be disabled: " + ex);
            }
            if (fname != null) {
                if ("JUL".equalsIgnoreCase(fname)) {
                    this.logging = new JulWatcher(slf4jImpl);
                } else {
                    try {
                        this.logging = this.loader.newInstance(fname, LogWatcher.class);
                    }
                    catch (Throwable e) {
                        log.warn("Unable to load LogWatcher", e);
                    }
                }
                if (this.logging != null) {
                    ListenerConfig v = new ListenerConfig();
                    v.size = cfg.getInt("solr/logging/watcher/@size", 50);
                    v.threshold = cfg.get("solr/logging/watcher/@threshold", null);
                    if (v.size > 0) {
                        log.info("Registering Log Listener");
                        this.logging.registerListener(v, this);
                    }
                }
            }
        }
        if ((dcoreName = cfg.get("solr/cores/@defaultCoreName", null)) != null && !dcoreName.isEmpty()) {
            this.defaultCoreName = dcoreName;
        }
        this.persistent = cfg.getBool("solr/@persistent", false);
        this.libDir = cfg.get("solr/@sharedLib", null);
        this.zkHost = cfg.get("solr/@zkHost", null);
        this.coreLoadThreads = cfg.getInt("solr/@coreLoadThreads", 3);
        this.adminPath = cfg.get("solr/cores/@adminPath", null);
        this.shareSchema = cfg.getBool("solr/cores/@shareSchema", false);
        this.zkClientTimeout = cfg.getInt("solr/cores/@zkClientTimeout", 15000);
        this.distribUpdateConnTimeout = cfg.getInt("solr/cores/@distribUpdateConnTimeout", 0);
        this.distribUpdateSoTimeout = cfg.getInt("solr/cores/@distribUpdateSoTimeout", 0);
        this.hostPort = cfg.get("solr/cores/@hostPort", DEFAULT_HOST_PORT);
        this.hostContext = cfg.get("solr/cores/@hostContext", DEFAULT_HOST_CONTEXT);
        this.host = cfg.get("solr/cores/@host", null);
        this.leaderVoteWait = cfg.get("solr/cores/@leaderVoteWait", LEADER_VOTE_WAIT);
        if (this.shareSchema) {
            this.indexSchemaCache = new ConcurrentHashMap<String, IndexSchema>();
        }
        this.adminHandler = cfg.get("solr/cores/@adminHandler", null);
        this.managementPath = cfg.get("solr/cores/@managementPath", null);
        this.zkClientTimeout = Integer.parseInt(System.getProperty("zkClientTimeout", Integer.toString(this.zkClientTimeout)));
        this.initZooKeeper(this.zkHost, this.zkClientTimeout);
        if (this.isZooKeeperAware() && this.coreLoadThreads <= 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 in solr.xml for coreLoadThreads");
        }
        if (this.libDir != null) {
            File f = FileUtils.resolvePath(new File(dir), this.libDir);
            log.info("loading shared library: " + f.getAbsolutePath());
            this.libLoader = SolrResourceLoader.createClassLoader(f, null);
        }
        if (this.adminPath != null) {
            this.coreAdminHandler = this.adminHandler == null ? new CoreAdminHandler(this) : this.createMultiCoreHandler(this.adminHandler);
        }
        this.collectionsHandler = new CollectionsHandler(this);
        try {
            this.containerProperties = this.readProperties(cfg, ((NodeList)cfg.evaluate(DEFAULT_HOST_CONTEXT, XPathConstants.NODESET)).item(0));
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, null, (Throwable)e);
        }
        NodeList nodes = (NodeList)cfg.evaluate("solr/cores/core", XPathConstants.NODESET);
        coreLoadExecutor = new ThreadPoolExecutor(this.coreLoadThreads, this.coreLoadThreads, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultSolrThreadFactory("coreLoadExecutor"));
        try {
            ExecutorCompletionService<SolrCore> completionService = new ExecutorCompletionService<SolrCore>(coreLoadExecutor);
            HashSet<Future<SolrCore>> pending = new HashSet<Future<SolrCore>>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                try {
                    String rawName = DOMUtil.getAttr(node, CORE_NAME, null);
                    if (null == rawName) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each core in solr.xml must have a 'name'");
                    }
                    final String name = rawName;
                    final CoreDescriptor p = new CoreDescriptor(this, name, DOMUtil.getAttr(node, CORE_INSTDIR, null));
                    String opt = DOMUtil.getAttr(node, CORE_CONFIG, null);
                    if (opt != null) {
                        p.setConfigName(opt);
                    }
                    if ((opt = DOMUtil.getAttr(node, CORE_SCHEMA, null)) != null) {
                        p.setSchemaName(opt);
                    }
                    if (this.zkController != null) {
                        opt = DOMUtil.getAttr(node, CORE_SHARD, null);
                        if (opt != null && opt.length() > 0) {
                            p.getCloudDescriptor().setShardId(opt);
                        }
                        if ((opt = DOMUtil.getAttr(node, CORE_COLLECTION, null)) != null) {
                            p.getCloudDescriptor().setCollectionName(opt);
                        }
                        if ((opt = DOMUtil.getAttr(node, CORE_ROLES, null)) != null) {
                            p.getCloudDescriptor().setRoles(opt);
                        }
                    }
                    if ((opt = DOMUtil.getAttr(node, CORE_PROPERTIES, null)) != null) {
                        p.setPropertiesName(opt);
                    }
                    if ((opt = DOMUtil.getAttr(node, CORE_DATADIR, null)) != null) {
                        p.setDataDir(opt);
                    }
                    p.setCoreProperties(this.readProperties(cfg, node));
                    opt = DOMUtil.getAttr(node, CORE_LOADONSTARTUP, null);
                    if (opt != null) {
                        p.setLoadOnStartup("true".equalsIgnoreCase(opt) || "on".equalsIgnoreCase(opt));
                    }
                    if ((opt = DOMUtil.getAttr(node, CORE_TRANSIENT, null)) != null) {
                        p.setTransient("true".equalsIgnoreCase(opt) || "on".equalsIgnoreCase(opt));
                    }
                    if (p.isLoadOnStartup()) {
                        Callable<SolrCore> task = new Callable<SolrCore>(){

                            @Override
                            public SolrCore call() {
                                SolrCore c;
                                block4: {
                                    c = null;
                                    try {
                                        c = CoreContainer.this.create(p);
                                        if (p.isTransient()) {
                                            CoreContainer.this.registerLazyCore(name, c, false);
                                        } else {
                                            CoreContainer.this.register(name, c, false);
                                        }
                                    }
                                    catch (Throwable t) {
                                        SolrException.log((Logger)log, null, (Throwable)t);
                                        if (c == null) break block4;
                                        c.close();
                                    }
                                }
                                return c;
                            }
                        };
                        pending.add(completionService.submit(task));
                        continue;
                    }
                    this.dynamicDescriptors.put(rawName, p);
                    continue;
                }
                catch (Throwable ex) {
                    SolrException.log((Logger)log, null, (Throwable)ex);
                }
            }
            while (pending != null && pending.size() > 0) {
                Future future;
                block50: {
                    future = completionService.take();
                    if (future != null) break block50;
                    return;
                }
                try {
                    pending.remove(future);
                    try {
                        SolrCore c = (SolrCore)future.get();
                        if (c == null) continue;
                        this.coreToOrigName.put(c, c.getName());
                    }
                    catch (ExecutionException e) {
                        SolrException.log((Logger)SolrCore.log, (String)"error loading core", (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "interrupted while loading core", (Throwable)e);
                    return;
                }
            }
        }
        finally {
            if (coreLoadExecutor != null) {
                ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
    }

    protected void initShardHandler(Config cfg) {
        PluginInfo info = null;
        if (cfg != null) {
            Node shfn = cfg.getNode("solr/cores/shardHandlerFactory", false);
            if (shfn != null) {
                info = new PluginInfo(shfn, "shardHandlerFactory", false, true);
            } else {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("class", HttpShardHandlerFactory.class.getName());
                info = new PluginInfo("shardHandlerFactory", m, null, Collections.<PluginInfo>emptyList());
            }
        }
        HttpShardHandlerFactory fac = new HttpShardHandlerFactory();
        if (info != null) {
            fac.init(info);
        }
        this.shardHandlerFactory = fac;
    }

    private Document copyDoc(Document document) throws TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer tx = tfactory.newTransformer();
        DOMSource source = new DOMSource(document);
        DOMResult result = new DOMResult();
        tx.transform(source, result);
        return (Document)result.getNode();
    }

    private Properties readProperties(Config cfg, Node node) throws XPathExpressionException {
        XPath xpath = cfg.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr(prop, CORE_NAME), DOMUtil.getAttr(prop, "value"));
        }
        return properties;
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        this.isShutDown = true;
        if (this.isZooKeeperAware()) {
            this.cancelCoreRecoveries();
        }
        try {
            Map<String, SolrCore> map = this.cores;
            synchronized (map) {
                for (SolrCore core : this.cores.values()) {
                    try {
                        core.close();
                    }
                    catch (Throwable t) {
                        SolrException.log((Logger)log, (String)"Error shutting down core", (Throwable)t);
                    }
                }
                this.cores.clear();
            }
            map = this.transientCores;
            synchronized (map) {
                for (SolrCore core : this.transientCores.values()) {
                    try {
                        core.close();
                    }
                    catch (Throwable t) {
                        SolrException.log((Logger)log, (String)"Error shutting down core", (Throwable)t);
                    }
                }
                this.transientCores.clear();
            }
        }
        finally {
            if (this.shardHandlerFactory != null) {
                this.shardHandlerFactory.close();
            }
            if (this.zkController != null) {
                this.zkController.close();
            }
            if (this.zkServer != null) {
                this.zkServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCoreRecoveries() {
        ArrayList<SolrCoreState> coreStates = new ArrayList<SolrCoreState>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (SolrCore core : this.cores.values()) {
                coreStates.add(core.getUpdateHandler().getSolrCoreState());
            }
        }
        for (SolrCoreState coreState : coreStates) {
            try {
                coreState.cancelRecovery();
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not shutdown prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public SolrCore register(String name, SolrCore core, boolean returnPrevNotClosed) {
        return this.registerCore(this.cores, name, core, returnPrevNotClosed);
    }

    protected SolrCore registerLazyCore(String name, SolrCore core, boolean returnPrevNotClosed) {
        return this.registerCore(this.transientCores, name, core, returnPrevNotClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore registerCore(Map<String, SolrCore> whichCores, String name, SolrCore core, boolean returnPrevNotClosed) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        if (this.zkController != null) {
            try {
                this.zkController.preRegister(core.getCoreDescriptor());
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        SolrCore old = null;
        Map<String, SolrCore> map = whichCores;
        synchronized (map) {
            if (this.isShutDown) {
                core.close();
                throw new IllegalStateException("This CoreContainer has been shutdown");
            }
            old = whichCores.put(name, core);
            this.coreInitFailures.remove(name);
            core.setName(name);
            core.getCoreDescriptor().name = name;
        }
        if (old == null || old == core) {
            log.info("registering core: " + name);
            this.registerInZk(core);
            return null;
        }
        log.info("replacing core: " + name);
        if (!returnPrevNotClosed) {
            old.close();
        }
        this.registerInZk(core);
        return old;
    }

    private void registerInZk(SolrCore core) {
        if (this.zkController != null) {
            try {
                this.zkController.register(core.getName(), core.getCoreDescriptor());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Exception e) {
                try {
                    this.zkController.publish(core.getCoreDescriptor(), "down");
                }
                catch (KeeperException e1) {
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    public SolrCore register(SolrCore core, boolean returnPrev) {
        return this.register(core.getName(), core, returnPrev);
    }

    private SolrCore createFromZk(String instanceDir, CoreDescriptor dcore) {
        try {
            ZkSolrResourceLoader solrLoader = null;
            SolrConfig config = null;
            String zkConfigName = null;
            String collection = dcore.getCloudDescriptor().getCollectionName();
            this.zkController.createCollectionZkNode(dcore.getCloudDescriptor());
            zkConfigName = this.zkController.readConfigName(collection);
            if (zkConfigName == null) {
                log.error("Could not find config name for collection:" + collection);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find config name for collection:" + collection);
            }
            solrLoader = new ZkSolrResourceLoader(instanceDir, zkConfigName, this.libLoader, CoreContainer.getCoreProps(instanceDir, dcore.getPropertiesName(), dcore.getCoreProperties()), this.zkController);
            config = this.getSolrConfigFromZk(zkConfigName, dcore.getConfigName(), solrLoader);
            IndexSchema schema = this.getSchemaFromZk(zkConfigName, dcore.getSchemaName(), config, solrLoader);
            return new SolrCore(dcore.getName(), null, config, schema, dcore);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    private SolrCore createFromLocal(String instanceDir, CoreDescriptor dcore) {
        SolrCore core;
        SolrResourceLoader solrLoader = null;
        SolrConfig config = null;
        solrLoader = new SolrResourceLoader(instanceDir, this.libLoader, CoreContainer.getCoreProps(instanceDir, dcore.getPropertiesName(), dcore.getCoreProperties()));
        try {
            config = new SolrConfig(solrLoader, dcore.getConfigName(), null);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load config for " + dcore.getConfigName(), (Throwable)e);
        }
        IndexSchema schema = null;
        if (this.indexSchemaCache != null) {
            File schemaFile = new File(dcore.getSchemaName());
            if (!schemaFile.isAbsolute()) {
                schemaFile = new File(solrLoader.getInstanceDir() + "conf" + File.separator + dcore.getSchemaName());
            }
            if (schemaFile.exists()) {
                String key = schemaFile.getAbsolutePath() + ":" + new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT).format(new Date(schemaFile.lastModified()));
                schema = this.indexSchemaCache.get(key);
                if (schema == null) {
                    log.info("creating new schema object for core: " + dcore.name);
                    schema = new IndexSchema(config, dcore.getSchemaName(), null);
                    this.indexSchemaCache.put(key, schema);
                } else {
                    log.info("re-using schema object for core: " + dcore.name);
                }
            }
        }
        if (schema == null) {
            schema = new IndexSchema(config, dcore.getSchemaName(), null);
        }
        if ((core = new SolrCore(dcore.getName(), null, config, schema, dcore)).getUpdateHandler().getUpdateLog() != null) {
            core.getUpdateHandler().getUpdateLog().recoverFromLog();
        }
        return core;
    }

    public SolrCore create(CoreDescriptor dcore) {
        String name = dcore.getName();
        try {
            File idir = new File(dcore.getInstanceDir());
            String instanceDir = idir.getPath();
            log.info("Creating SolrCore '{}' using instanceDir: {}", (Object)dcore.getName(), (Object)instanceDir);
            if (this.zkController != null) {
                return this.createFromZk(instanceDir, dcore);
            }
            return this.createFromLocal(instanceDir, dcore);
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to create core: " + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            lst.addAll(this.cores.values());
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCoreNames() {
        ArrayList<String> lst = new ArrayList<String>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            lst.addAll(this.cores.keySet());
        }
        map = this.transientCores;
        synchronized (map) {
            lst.addAll(this.transientCores.keySet());
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCoreNames(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        map = this.transientCores;
        synchronized (map) {
            for (Map.Entry<String, SolrCore> entry : this.transientCores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> getCoreInitFailures() {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, Exception>(this.coreInitFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name) {
        try {
            SolrResourceLoader solrLoader;
            SolrCore core;
            name = this.checkDefault(name);
            Map<String, SolrCore> map = this.cores;
            synchronized (map) {
                core = this.cores.get(name);
            }
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
            }
            CoreDescriptor cd = core.getCoreDescriptor();
            File instanceDir = new File(cd.getInstanceDir());
            log.info("Reloading SolrCore '{}' using instanceDir: {}", (Object)cd.getName(), (Object)instanceDir.getAbsolutePath());
            if (this.zkController == null) {
                solrLoader = new SolrResourceLoader(instanceDir.getAbsolutePath(), this.libLoader, CoreContainer.getCoreProps(instanceDir.getAbsolutePath(), cd.getPropertiesName(), cd.getCoreProperties()));
            } else {
                try {
                    String collection = cd.getCloudDescriptor().getCollectionName();
                    this.zkController.createCollectionZkNode(cd.getCloudDescriptor());
                    String zkConfigName = this.zkController.readConfigName(collection);
                    if (zkConfigName == null) {
                        log.error("Could not find config name for collection:" + collection);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find config name for collection:" + collection);
                    }
                    solrLoader = new ZkSolrResourceLoader(instanceDir.getAbsolutePath(), zkConfigName, this.libLoader, CoreContainer.getCoreProps(instanceDir.getAbsolutePath(), cd.getPropertiesName(), cd.getCoreProperties()), this.zkController);
                }
                catch (KeeperException e) {
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
            }
            SolrCore newCore = core.reload(solrLoader, core);
            String origName = this.coreToOrigName.remove(core);
            if (origName != null) {
                this.coreToOrigName.put(newCore, origName);
            }
            this.register(name, newCore, false);
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to reload core: " + name, ex);
        }
    }

    private String checkDefault(String name) {
        return null == name || name.isEmpty() ? this.defaultCoreName : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        n0 = this.checkDefault(n0);
        n1 = this.checkDefault(n1);
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c0.getCoreDescriptor().name = n1;
            c1.setName(n0);
            c1.getCoreDescriptor().name = n0;
        }
        log.info("swapped: " + n0 + " with " + n1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore remove(String name) {
        name = this.checkDefault(name);
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore core = this.cores.remove(name);
            if (core != null) {
                this.coreToOrigName.remove(core);
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String name, String toName) {
        block7: {
            SolrCore core = this.getCore(name);
            try {
                if (core == null) break block7;
                this.register(toName, core, false);
                name = this.checkDefault(name);
                Map<String, SolrCore> map = this.cores;
                synchronized (map) {
                    this.cores.remove(name);
                }
            }
            finally {
                if (core != null) {
                    core.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrCore getCoreFromAnyList(String name) {
        SolrCore core;
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            core = this.cores.get(name);
            if (core != null) {
                core.open();
                return core;
            }
        }
        if (this.dynamicDescriptors.size() == 0) {
            return null;
        }
        map = this.transientCores;
        synchronized (map) {
            core = this.transientCores.get(name);
            if (core != null) {
                core.open();
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        SolrCore core = this.getCoreFromAnyList(name = this.checkDefault(name));
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.dynamicDescriptors.get(name);
        if (desc == null) {
            return null;
        }
        try {
            boolean isPending;
            Set<String> set = this.pendingDynamicCoreLoads;
            synchronized (set) {
                isPending = this.pendingDynamicCoreLoads.contains(name);
                if (!isPending) {
                    this.pendingDynamicCoreLoads.add(name);
                }
            }
            while (isPending) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    SolrCore solrCore = null;
                    this.pendingDynamicCoreLoads.remove(name);
                    return solrCore;
                }
                Set<String> e = this.pendingDynamicCoreLoads;
                synchronized (e) {
                    block22: {
                        if (this.pendingDynamicCoreLoads.contains(name)) break block22;
                        SolrCore solrCore = this.getCoreFromAnyList(name);
                        return solrCore;
                    }
                }
            }
            try {
                core = this.create(desc);
                core.open();
                if (desc.isTransient()) {
                    this.registerLazyCore(name, core, false);
                } else {
                    this.register(name, core, false);
                }
            }
            catch (Exception ex) {
                throw this.recordAndThrow(name, "Unable to create core" + name, ex);
            }
        }
        finally {
            this.pendingDynamicCoreLoads.remove(name);
        }
        return core;
    }

    protected CoreAdminHandler createMultiCoreHandler(String adminHandlerClass) {
        SolrResourceLoader loader = new SolrResourceLoader(this.solrHome, this.libLoader, null);
        return loader.newAdminHandlerInstance(this, adminHandlerClass, new String[0]);
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public String getDefaultCoreName() {
        return this.defaultCoreName;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public void setAdminPath(String adminPath) {
        this.adminPath = adminPath;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public void setManagementPath(String path) {
        this.managementPath = path;
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public void setLogging(LogWatcher v) {
        this.logging = v;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void persist() {
        this.persistFile(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFile(File file) {
        log.info("Persisting cores config to " + (file == null ? this.configFile : file));
        HashMap<String, String> rootSolrAttribs = new HashMap<String, String>();
        if (this.libDir != null) {
            rootSolrAttribs.put("sharedLib", this.libDir);
        }
        rootSolrAttribs.put("persistent", Boolean.toString(this.isPersistent()));
        HashMap<String, String> coresAttribs = new HashMap<String, String>();
        this.addCoresAttrib(coresAttribs, "adminPath", this.adminPath, null);
        this.addCoresAttrib(coresAttribs, "adminHandler", this.adminHandler, null);
        this.addCoresAttrib(coresAttribs, "shareSchema", Boolean.toString(this.shareSchema), Boolean.toString(false));
        this.addCoresAttrib(coresAttribs, "host", this.host, null);
        if (null != this.defaultCoreName && !this.defaultCoreName.equals("")) {
            coresAttribs.put("defaultCoreName", this.defaultCoreName);
        }
        if (this.transientCacheSize != Integer.MAX_VALUE) {
            coresAttribs.put("transientCacheSize", Integer.toString(this.transientCacheSize));
        }
        this.addCoresAttrib(coresAttribs, "hostPort", this.hostPort, DEFAULT_HOST_PORT);
        this.addCoresAttrib(coresAttribs, "zkClientTimeout", this.intToString(this.zkClientTimeout), Integer.toString(15000));
        this.addCoresAttrib(coresAttribs, "hostContext", this.hostContext, DEFAULT_HOST_CONTEXT);
        this.addCoresAttrib(coresAttribs, "leaderVoteWait", this.leaderVoteWait, LEADER_VOTE_WAIT);
        this.addCoresAttrib(coresAttribs, "coreLoadThreads", Integer.toString(this.coreLoadThreads), Integer.toString(3));
        ArrayList<SolrXMLSerializer.SolrCoreXMLDef> solrCoreXMLDefs = new ArrayList<SolrXMLSerializer.SolrCoreXMLDef>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (SolrCore solrCore : this.cores.values()) {
                HashMap<String, String> coreAttribs = new HashMap<String, String>();
                CoreDescriptor dcore = solrCore.getCoreDescriptor();
                String coreName = dcore.name;
                Node coreNode = null;
                if (this.cfg != null) {
                    String name;
                    Node node;
                    int i;
                    NodeList nodes = (NodeList)this.cfg.evaluate("solr/cores/core", XPathConstants.NODESET);
                    String origCoreName = this.coreToOrigName.get(solrCore);
                    if (origCoreName == null) {
                        origCoreName = coreName;
                    }
                    for (i = 0; i < nodes.getLength(); ++i) {
                        node = nodes.item(i);
                        name = DOMUtil.getAttr(node, CORE_NAME, null);
                        if (!origCoreName.equals(name)) continue;
                        coreNode = node;
                        if (!coreName.equals(origCoreName)) break;
                        coreName = name;
                        break;
                    }
                    if (coreNode == null) {
                        for (i = 0; i < nodes.getLength(); ++i) {
                            node = nodes.item(i);
                            name = DOMUtil.getAttr(node, CORE_NAME, null);
                            if (!origCoreName.equals(DOMUtil.substituteProperty(name, this.loader.getCoreProperties()))) continue;
                            coreNode = node;
                            if (!coreName.equals(origCoreName)) break;
                            coreName = name;
                            break;
                        }
                    }
                }
                coreAttribs.put(CORE_NAME, coreName);
                String instanceDir = dcore.getRawInstanceDir();
                this.addCoreProperty(coreAttribs, coreNode, CORE_INSTDIR, instanceDir, null);
                String configName = dcore.getConfigName();
                this.addCoreProperty(coreAttribs, coreNode, CORE_CONFIG, configName, dcore.getDefaultConfigName());
                String schema = dcore.getSchemaName();
                this.addCoreProperty(coreAttribs, coreNode, CORE_SCHEMA, schema, dcore.getDefaultSchemaName());
                String dataDir = dcore.dataDir;
                String ulogDir = dcore.ulogDir;
                this.addCoreProperty(coreAttribs, coreNode, CORE_DATADIR, dataDir, null);
                this.addCoreProperty(coreAttribs, coreNode, CORE_ULOGDIR, ulogDir, null);
                this.addCoreProperty(coreAttribs, coreNode, CORE_TRANSIENT, Boolean.toString(dcore.isTransient()), null);
                this.addCoreProperty(coreAttribs, coreNode, CORE_LOADONSTARTUP, Boolean.toString(dcore.isLoadOnStartup()), null);
                CloudDescriptor cd = dcore.getCloudDescriptor();
                String shard = null;
                String roles = null;
                if (cd != null) {
                    shard = cd.getShardId();
                    roles = cd.getRoles();
                }
                this.addCoreProperty(coreAttribs, coreNode, CORE_SHARD, shard, null);
                this.addCoreProperty(coreAttribs, coreNode, CORE_ROLES, roles, null);
                String collection = null;
                if (cd != null) {
                    collection = cd.getCollectionName();
                }
                this.addCoreProperty(coreAttribs, coreNode, CORE_COLLECTION, collection, dcore.name);
                String opt = dcore.getPropertiesName();
                if (opt != null) {
                    coreAttribs.put(CORE_PROPERTIES, opt);
                }
                SolrXMLSerializer.SolrCoreXMLDef solrCoreXMLDef = new SolrXMLSerializer.SolrCoreXMLDef();
                solrCoreXMLDef.coreAttribs = coreAttribs;
                solrCoreXMLDef.coreProperties = dcore.getCoreProperties();
                solrCoreXMLDefs.add(solrCoreXMLDef);
            }
            SolrXMLSerializer.SolrXMLDef solrXMLDef = new SolrXMLSerializer.SolrXMLDef();
            solrXMLDef.coresDefs = solrCoreXMLDefs;
            solrXMLDef.containerProperties = this.containerProperties;
            solrXMLDef.solrAttribs = rootSolrAttribs;
            solrXMLDef.coresAttribs = coresAttribs;
            this.solrXMLSerializer.persistFile(file == null ? this.configFile : file, solrXMLDef);
        }
    }

    private String intToString(Integer integer) {
        if (integer == null) {
            return null;
        }
        return Integer.toString(integer);
    }

    private void addCoresAttrib(Map<String, String> coresAttribs, String attribName, String attribValue, String defaultValue) {
        if (this.cfg == null) {
            coresAttribs.put(attribName, attribValue);
            return;
        }
        if (attribValue != null) {
            String rawValue = this.cfg.get("solr/cores/@" + attribName, null);
            if (rawValue == null && defaultValue != null && attribValue.equals(defaultValue)) {
                return;
            }
            if (attribValue.equals(DOMUtil.substituteProperty(rawValue, this.loader.getCoreProperties()))) {
                coresAttribs.put(attribName, rawValue);
            } else {
                coresAttribs.put(attribName, attribValue);
            }
        }
    }

    private void addCoreProperty(Map<String, String> coreAttribs, Node node, String name, String value, String defaultValue) {
        if (node == null) {
            coreAttribs.put(name, value);
            return;
        }
        if (node != null) {
            String rawAttribValue = DOMUtil.getAttr(node, name, null);
            if (value == null) {
                coreAttribs.put(name, rawAttribValue);
                return;
            }
            if (rawAttribValue == null && defaultValue != null && value.equals(defaultValue)) {
                return;
            }
            if (rawAttribValue != null && value.equals(DOMUtil.substituteProperty(rawAttribValue, this.loader.getCoreProperties()))) {
                coreAttribs.put(name, rawAttribValue);
            } else {
                coreAttribs.put(name, value);
            }
        }
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkController != null;
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public boolean isShareSchema() {
        return this.shareSchema;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    private SolrConfig getSolrConfigFromZk(String zkConfigName, String solrConfigFileName, SolrResourceLoader resourceLoader) {
        SolrConfig cfg = null;
        try {
            byte[] config = this.zkController.getConfigFileData(zkConfigName, solrConfigFileName);
            InputSource is = new InputSource(new ByteArrayInputStream(config));
            is.setSystemId(SystemIdResolver.createSystemIdFromResourceName(solrConfigFileName));
            cfg = solrConfigFileName == null ? new SolrConfig(resourceLoader, "solrconfig.xml", is) : new SolrConfig(resourceLoader, solrConfigFileName, is);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "getSolrConfigFromZK failed for " + zkConfigName + " " + solrConfigFileName, (Throwable)e);
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrException recordAndThrow(String name, String msg, Exception ex) {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
            this.coreInitFailures.put(name, ex);
        }
        log.error(msg, (Throwable)ex);
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)ex);
    }

    private IndexSchema getSchemaFromZk(String zkConfigName, String schemaName, SolrConfig config, SolrResourceLoader resourceLoader) throws KeeperException, InterruptedException {
        byte[] configBytes = this.zkController.getConfigFileData(zkConfigName, schemaName);
        InputSource is = new InputSource(new ByteArrayInputStream(configBytes));
        is.setSystemId(SystemIdResolver.createSystemIdFromResourceName(schemaName));
        IndexSchema schema = new IndexSchema(config, schemaName, is);
        return schema;
    }

    public static class Initializer {
        protected String containerConfigFilename = null;
        protected String dataDir = null;

        public CoreContainer initialize() {
            CoreContainer cores = null;
            String solrHome = SolrResourceLoader.locateSolrHome();
            File fconf = new File(solrHome, this.containerConfigFilename == null ? "solr.xml" : this.containerConfigFilename);
            log.info("looking for solr.xml: " + fconf.getAbsolutePath());
            cores = new CoreContainer(solrHome);
            if (fconf.exists()) {
                cores.load(solrHome, fconf);
            } else {
                log.info("no solr.xml file found - using default");
                try {
                    cores.load(solrHome, new InputSource(new ByteArrayInputStream(CoreContainer.DEF_SOLR_XML.getBytes("UTF-8"))));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreContainer.Initialize failed when trying to load default solr.xml file", (Throwable)e);
                }
                cores.configFile = fconf;
            }
            this.containerConfigFilename = cores.getConfigFile().getName();
            return cores;
        }
    }
}

