/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTokenizer
extends Tokenizer {
    private static final Logger logger = LoggerFactory.getLogger(SuggestTokenizer.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private String inputStr = "";
    private int offset = 0;
    private int readingOffset = 0;
    private final List<String> termListByKuromoji = new ArrayList<String>();
    private final List<String> readingList = new ArrayList<String>();
    private final List<String> partOfSpeechList = new ArrayList<String>();
    private final List<String> suggestStringList = new ArrayList<String>();
    private final UserDictionary userDictionary;
    private final boolean discardPunctuation;
    private final JapaneseTokenizer.Mode tokenizerMode;
    private final String wordSeparator;
    private final TermChecker termChecker;
    private final List<SuggestConverter> preConverterList;
    private final List<SuggestConverter> converterList;

    public SuggestTokenizer(Reader input, int bufferSize, UserDictionary userDictionaryPara, boolean discardPunctuationPara, JapaneseTokenizer.Mode modePara, TermChecker termChecker, List<SuggestConverter> preconverterList, List<SuggestConverter> converterList, String wordSeparator) {
        super(input);
        this.userDictionary = userDictionaryPara;
        this.discardPunctuation = discardPunctuationPara;
        this.tokenizerMode = modePara;
        this.termAtt.resizeBuffer(bufferSize);
        this.wordSeparator = wordSeparator;
        this.termChecker = termChecker;
        this.preConverterList = preconverterList;
        this.converterList = converterList;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.termListByKuromoji.clear();
        this.partOfSpeechList.clear();
        this.readingList.clear();
        this.suggestStringList.clear();
        this.offset = 0;
        this.readingOffset = 0;
        this.inputStr = "";
        try {
            String s = IOUtils.toString((Reader)this.input);
            if (s != null && s.length() > 0) {
                this.inputStr = s;
                for (SuggestConverter converter : this.preConverterList) {
                    this.inputStr = converter.convert(this.inputStr);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        StringReader rd = new StringReader(this.inputStr);
        JapaneseTokenizer stream = null;
        try {
            stream = new JapaneseTokenizer((Reader)rd, this.userDictionary, this.discardPunctuation, this.tokenizerMode);
            while (stream.incrementToken()) {
                CharTermAttribute att = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                this.termListByKuromoji.add(att.toString());
                PartOfSpeechAttribute psAtt = (PartOfSpeechAttribute)stream.getAttribute(PartOfSpeechAttribute.class);
                String pos = psAtt.getPartOfSpeech();
                this.partOfSpeechList.add(pos);
                ReadingAttribute rdAttr = (ReadingAttribute)stream.getAttribute(ReadingAttribute.class);
                String reading = rdAttr.getReading() != null ? rdAttr.getReading() : att.toString();
                for (SuggestConverter converter : this.converterList) {
                    reading = converter.convert(reading);
                }
                this.readingList.add(reading);
            }
        }
        catch (Exception e) {
            logger.warn("JapaneseTokenizer stream error", (Throwable)e);
        }
        finally {
            try {
                this.input.reset();
            }
            catch (Exception e) {}
            try {
                stream.end();
            }
            catch (Exception e) {}
            try {
                ((Reader)rd).close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean incrementToken() throws IOException {
        if (this.offset < this.termListByKuromoji.size()) {
            while (this.partOfSpeechList.get(this.offset).indexOf("\u540d\u8a5e") == -1) {
                ++this.offset;
                if (this.offset < this.termListByKuromoji.size()) continue;
            }
        }
        if (this.offset < this.termListByKuromoji.size()) {
            this.termAtt.setEmpty();
            this.termAtt.append(this.termListByKuromoji.get(this.offset));
            this.suggestStringList.add(this.convertSuggestString(this.termListByKuromoji.get(this.offset), this.readingList.get(this.offset)));
            ++this.offset;
        } else {
            int tmpOffset;
            boolean readingFlg = false;
            if (tmpOffset < this.termListByKuromoji.size()) {
                StringBuilder buffer = null;
                StringBuilder readingBuf = null;
                int end = 1;
                for (tmpOffset = this.offset - this.termListByKuromoji.size(); tmpOffset < this.partOfSpeechList.size(); ++tmpOffset) {
                    buffer = new StringBuilder();
                    readingBuf = new StringBuilder();
                    if (!this.termChecker.check(this.partOfSpeechList.get(tmpOffset), this.termListByKuromoji.get(tmpOffset), "start")) continue;
                    buffer.append(this.termListByKuromoji.get(tmpOffset));
                    readingBuf.append(this.readingList.get(tmpOffset));
                    int i = 1;
                    while (tmpOffset + i < this.partOfSpeechList.size() && this.termChecker.check(this.partOfSpeechList.get(tmpOffset + i), this.termListByKuromoji.get(tmpOffset + i), "middle") && this.inputStr.indexOf(buffer.toString() + this.termListByKuromoji.get(tmpOffset + i)) != -1) {
                        buffer.append(this.termListByKuromoji.get(tmpOffset + i));
                        readingBuf.append(this.readingList.get(tmpOffset + i));
                        ++end;
                        ++i;
                    }
                    if (end > 1) break;
                }
                if (buffer != null && tmpOffset < this.partOfSpeechList.size() && buffer.length() > this.termListByKuromoji.get(tmpOffset).length()) {
                    this.termAtt.setEmpty();
                    this.termAtt.append(buffer.toString());
                    this.suggestStringList.add(this.convertSuggestString(buffer.toString(), readingBuf.toString()));
                } else {
                    readingFlg = true;
                }
                this.offset = tmpOffset + this.termListByKuromoji.size() + end;
            } else {
                readingFlg = true;
            }
            if (readingFlg) {
                if (this.readingOffset < this.suggestStringList.size()) {
                    this.termAtt.setEmpty();
                    this.termAtt.append(this.suggestStringList.get(this.readingOffset));
                    ++this.readingOffset;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.initialize();
    }

    private String convertSuggestString(String term, String reading) {
        String suggestString = reading != null && reading.length() > 0 ? reading + this.wordSeparator + term : term;
        return suggestString;
    }

    public static class TermChecker {
        private final Map<String, Map<String, List<String>>> paramMap = new HashMap<String, Map<String, List<String>>>(2);

        public TermChecker() {
            HashMap startParamMap = new HashMap(3);
            startParamMap.put("includePartOfSpeech", new ArrayList());
            startParamMap.put("excludePartOfSpeech", new ArrayList());
            startParamMap.put("includeCharTerm", new ArrayList());
            this.paramMap.put("start", startParamMap);
            HashMap middleParamMap = new HashMap(3);
            middleParamMap.put("includePartOfSpeech", new ArrayList());
            middleParamMap.put("excludePartOfSpeech", new ArrayList());
            middleParamMap.put("includeCharTerm", new ArrayList());
            this.paramMap.put("middle", middleParamMap);
        }

        public void includePartOfSpeech(String mode, String value) {
            this.updateParam(mode, "includePartOfSpeech", value);
        }

        public void excludePartOfSpeech(String mode, String value) {
            this.updateParam(mode, "excludePartOfSpeech", value);
        }

        public void includeCharTerm(String mode, String value) {
            this.updateParam(mode, "includeCharTerm", value);
        }

        private void updateParam(String mode, String target, String value) {
            List<String> list;
            Map<String, List<String>> modeParamMap = this.paramMap.get(mode);
            if (modeParamMap != null && (list = modeParamMap.get(target)) != null) {
                list.add(value);
            }
        }

        public boolean check(String partOfSpeech, String termByKuromoji, String mode) {
            int i;
            Map<String, List<String>> modeParamMap = this.paramMap.get(mode);
            List<String> includePartOfSpeechList = modeParamMap.get("includePartOfSpeech");
            List<String> excludePartOfSpeechList = modeParamMap.get("excludePartOfSpeech");
            List<String> includeCharTermList = modeParamMap.get("includeCharTerm");
            boolean ret = false;
            for (i = 0; i < includePartOfSpeechList.size(); ++i) {
                if (partOfSpeech.indexOf(includePartOfSpeechList.get(i)) == -1) continue;
                boolean isNg = false;
                for (int j = 0; j < excludePartOfSpeechList.size(); ++j) {
                    if (partOfSpeech.indexOf(excludePartOfSpeechList.get(j)) == -1) continue;
                    isNg = true;
                }
                if (isNg) continue;
                ret = true;
                break;
            }
            if (!ret) {
                for (i = 0; i < includeCharTermList.size(); ++i) {
                    if (!termByKuromoji.equals(includeCharTermList.get(i))) continue;
                    ret = true;
                    break;
                }
            }
            return ret;
        }
    }
}

