/*
 * Decompiled with CFR 0.152.
 */
package org.apache.noggit;

import java.io.IOException;
import java.nio.CharBuffer;

public class CharArr
implements CharSequence,
Appendable {
    protected char[] buf;
    protected int start;
    protected int end;

    public CharArr() {
        this(32);
    }

    public CharArr(int size) {
        this.buf = new char[size];
    }

    public CharArr(char[] arr, int start, int end) {
        this.set(arr, start, end);
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void set(char[] arr, int start, int end) {
        this.buf = arr;
        this.start = start;
        this.end = end;
    }

    public char[] getArray() {
        return this.buf;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public int length() {
        return this.size();
    }

    public int capacity() {
        return this.buf.length;
    }

    @Override
    public char charAt(int index) {
        return this.buf[this.start + index];
    }

    @Override
    public CharArr subSequence(int start, int end) {
        return new CharArr(this.buf, this.start + start, this.start + end);
    }

    public int read() throws IOException {
        if (this.start >= this.end) {
            return -1;
        }
        return this.buf[this.start++];
    }

    public int read(char[] cbuf, int off, int len) {
        return 0;
    }

    public void unsafeWrite(char b) {
        this.buf[this.end++] = b;
    }

    public void unsafeWrite(int b) {
        this.unsafeWrite((char)b);
    }

    public void unsafeWrite(char[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, this.end, len);
        this.end += len;
    }

    protected void resize(int len) {
        char[] newbuf = new char[Math.max(this.buf.length << 1, len)];
        System.arraycopy(this.buf, this.start, newbuf, 0, this.size());
        this.buf = newbuf;
    }

    public void reserve(int num) {
        if (this.end + num > this.buf.length) {
            this.resize(this.end + num);
        }
    }

    public void write(char b) {
        if (this.end >= this.buf.length) {
            this.resize(this.end + 1);
        }
        this.unsafeWrite(b);
    }

    public final void write(int b) {
        this.write((char)b);
    }

    public final void write(char[] b) {
        this.write(b, 0, b.length);
    }

    public void write(char[] b, int off, int len) {
        this.reserve(len);
        this.unsafeWrite(b, off, len);
    }

    public final void write(CharArr arr) {
        this.write(arr.buf, this.start, this.end - this.start);
    }

    public final void write(String s) {
        this.write(s, 0, s.length());
    }

    public void write(String s, int stringOffset, int len) {
        this.reserve(len);
        s.getChars(stringOffset, len, this.buf, this.end);
        this.end += len;
    }

    public void flush() {
    }

    public final void reset() {
        this.end = 0;
        this.start = 0;
    }

    public void close() {
    }

    public char[] toCharArray() {
        char[] newbuf = new char[this.size()];
        System.arraycopy(this.buf, this.start, newbuf, 0, this.size());
        return newbuf;
    }

    @Override
    public String toString() {
        return new String(this.buf, this.start, this.size());
    }

    public int read(CharBuffer cb) throws IOException {
        int sz = this.size();
        if (sz > 0) {
            cb.put(this.buf, this.start, sz);
        }
        this.start = this.end;
        while (true) {
            this.fill();
            int s = this.size();
            if (s == 0) {
                return sz == 0 ? -1 : sz;
            }
            sz += s;
            cb.put(this.buf, this.start, s);
        }
    }

    public int fill() throws IOException {
        return 0;
    }

    @Override
    public final Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.write(((Object)csq.subSequence(start, end)).toString());
        return null;
    }

    @Override
    public final Appendable append(char c) {
        this.write(c);
        return this;
    }
}

