/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.InfoStream;

public class PerDocWriteState {
    public final InfoStream infoStream;
    public final Directory directory;
    public final SegmentInfo segmentInfo;
    public final Counter bytesUsed;
    public final String segmentSuffix;
    public final IOContext context;

    public PerDocWriteState(InfoStream infoStream, Directory directory, SegmentInfo segmentInfo, Counter bytesUsed, String segmentSuffix, IOContext context) {
        this.infoStream = infoStream;
        this.directory = directory;
        this.segmentInfo = segmentInfo;
        this.segmentSuffix = segmentSuffix;
        this.bytesUsed = bytesUsed;
        this.context = context;
    }

    public PerDocWriteState(SegmentWriteState state) {
        this.infoStream = state.infoStream;
        this.directory = state.directory;
        this.segmentInfo = state.segmentInfo;
        this.segmentSuffix = state.segmentSuffix;
        this.bytesUsed = Counter.newCounter();
        this.context = state.context;
    }

    public PerDocWriteState(PerDocWriteState state, String segmentSuffix) {
        this.infoStream = state.infoStream;
        this.directory = state.directory;
        this.segmentInfo = state.segmentInfo;
        this.segmentSuffix = segmentSuffix;
        this.bytesUsed = state.bytesUsed;
        this.context = state.context;
    }
}

