/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteDoubleAssociativeContainer;
import com.carrotsearch.hppc.ByteDoubleMap;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ByteDoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.ByteDoubleProcedure;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ByteDoubleOpenHashMap
implements ByteDoubleMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public byte[] keys;
    public double[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public ByteDoubleOpenHashMap() {
        this(16);
    }

    public ByteDoubleOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteDoubleOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ByteDoubleOpenHashMap(ByteDoubleAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public double put(byte key, double value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0.0;
    }

    @Override
    public final int putAll(ByteDoubleAssociativeContainer container) {
        int count = this.assigned;
        for (ByteDoubleCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends ByteDoubleCursor> iterable) {
        int count = this.assigned;
        for (ByteDoubleCursor byteDoubleCursor : iterable) {
            this.put(byteDoubleCursor.key, byteDoubleCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(byte key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final double putOrAdd(byte key, double putValue, double additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int n = slot;
                double d = this.values[n] + additionValue;
                this.values[n] = d;
                return d;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        double v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        byte[] oldKeys = this.keys;
        double[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            byte key = oldKeys[i];
            double value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new byte[capacity];
        this.values = new double[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public double remove(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                double v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(ByteContainer container) {
        int before = this.assigned;
        for (ByteCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(BytePredicate predicate) {
        int before = this.assigned;
        byte[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public double get(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    public double lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public double lset(double key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        double previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ByteDoubleCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ByteDoubleMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ByteDoubleMap && (other = (ByteDoubleMap)obj).size() == this.size()) {
                for (ByteDoubleCursor c : this) {
                    double v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ByteDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ByteDoubleProcedure> T forEach(T procedure) {
        byte[] keys = this.keys;
        double[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        return new ValuesContainer();
    }

    public ByteDoubleOpenHashMap clone() {
        try {
            ByteDoubleOpenHashMap cloned = (ByteDoubleOpenHashMap)super.clone();
            cloned.keys = (byte[])this.keys.clone();
            cloned.values = (double[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ByteDoubleOpenHashMap from(byte[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteDoubleOpenHashMap map = new ByteDoubleOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ByteDoubleOpenHashMap from(ByteDoubleAssociativeContainer container) {
        return new ByteDoubleOpenHashMap(container);
    }

    public static ByteDoubleOpenHashMap newInstance() {
        return new ByteDoubleOpenHashMap();
    }

    public static ByteDoubleOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new ByteDoubleOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = ByteDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ByteDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ByteDoubleOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ByteDoubleOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            boolean[] allocated = ByteDoubleOpenHashMap.this.allocated;
            double[] values = ByteDoubleOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            boolean[] allocated = ByteDoubleOpenHashMap.this.allocated;
            double[] values = ByteDoubleOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            boolean[] allocated = ByteDoubleOpenHashMap.this.allocated;
            double[] values = ByteDoubleOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(double e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            int max = ByteDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ByteDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteDoubleOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteDoubleOpenHashMap owner;

        public KeysContainer() {
            this.owner = ByteDoubleOpenHashMap.this;
        }

        @Override
        public boolean contains(byte e) {
            return ByteDoubleOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            byte[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            byte[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ByteDoubleCursor> {
        private final ByteDoubleCursor cursor = new ByteDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteDoubleCursor fetch() {
            int i;
            int max = ByteDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ByteDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ByteDoubleOpenHashMap.this.keys[i];
            this.cursor.value = ByteDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

