/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SimilarityFactory;

public class SchemaSimilarityFactory
extends SimilarityFactory
implements SchemaAware {
    private Similarity similarity;
    private Similarity defaultSimilarity = new DefaultSimilarity();

    @Override
    public void inform(final IndexSchema schema) {
        this.similarity = new PerFieldSimilarityWrapper(){

            public Similarity get(String name) {
                FieldType fieldType = schema.getFieldTypeNoEx(name);
                if (fieldType == null) {
                    return SchemaSimilarityFactory.this.defaultSimilarity;
                }
                Similarity similarity = fieldType.getSimilarity();
                return similarity == null ? SchemaSimilarityFactory.this.defaultSimilarity : similarity;
            }
        };
    }

    @Override
    public Similarity getSimilarity() {
        assert (this.similarity != null) : "inform must be called first";
        return this.similarity;
    }
}

