/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv.writer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.solr.internal.csv.writer.CSVField;

public class CSVConfig {
    private boolean fixedWidth;
    private List fields;
    public static final int FILLNONE = 0;
    public static final int FILLLEFT = 1;
    public static final int FILLRIGHT = 2;
    private int fill;
    private char fillChar = (char)32;
    private char delimiter = (char)44;
    private boolean ignoreDelimiter = false;
    private char valueDelimiter = (char)34;
    private boolean ignoreValueDelimiter = true;
    private boolean fieldHeader = false;
    private boolean endTrimmed = false;

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(boolean fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public void addField(CSVField field) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(field);
    }

    public void setFields(CSVField[] csvFields) {
        if (csvFields == null) {
            return;
        }
        this.fields = new ArrayList<CSVField>(Arrays.asList(csvFields));
    }

    public void setFields(Collection csvField) {
        if (csvField == null) {
            return;
        }
        this.fields = new ArrayList(csvField);
    }

    public CSVField[] getFields() {
        CSVField[] csvFields = new CSVField[]{};
        if (this.fields != null) {
            return this.fields.toArray(csvFields);
        }
        return csvFields;
    }

    public CSVField getField(String name) {
        if (this.fields == null || name == null) {
            return null;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            CSVField field = (CSVField)this.fields.get(i);
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public int getFill() {
        return this.fill;
    }

    public void setFill(int fill) {
        this.fill = fill;
    }

    public char getFillChar() {
        return this.fillChar;
    }

    public void setFillChar(char fillChar) {
        this.fillChar = fillChar;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isDelimiterIgnored() {
        return this.ignoreDelimiter;
    }

    public void setIgnoreDelimiter(boolean ignoreDelimiter) {
        this.ignoreDelimiter = ignoreDelimiter;
    }

    public char getValueDelimiter() {
        return this.valueDelimiter;
    }

    public void setValueDelimiter(char valueDelimiter) {
        this.valueDelimiter = valueDelimiter;
    }

    public boolean isValueDelimiterIgnored() {
        return this.ignoreValueDelimiter;
    }

    public void setIgnoreValueDelimiter(boolean ignoreValueDelimiter) {
        this.ignoreValueDelimiter = ignoreValueDelimiter;
    }

    public boolean isFieldHeader() {
        return this.fieldHeader;
    }

    public void setFieldHeader(boolean fieldHeader) {
        this.fieldHeader = fieldHeader;
    }

    public boolean equals(Object obj) {
        if (obj == null && !(obj instanceof CSVConfig)) {
            return false;
        }
        return super.equals(obj);
    }

    public static CSVConfig guessConfig(InputStream inputStream) {
        return null;
    }

    public boolean isEndTrimmed() {
        return this.endTrimmed;
    }

    public void setEndTrimmed(boolean endTrimmed) {
        this.endTrimmed = endTrimmed;
    }
}

