/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.EmptyEntityResolver;
import org.apache.solr.util.xslt.TransformerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLLoader
extends ContentStreamLoader {
    public static Logger log = LoggerFactory.getLogger(XMLLoader.class);
    static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    public static final String CONTEXT_TRANSFORMER_KEY = "xsltupdater.transformer";
    private static final String XSLT_CACHE_PARAM = "xsltCacheLifetimeSeconds";
    public static final int XSLT_CACHE_DEFAULT = 60;
    int xsltCacheLifetimeSeconds;
    XMLInputFactory inputFactory;
    SAXParserFactory saxFactory;

    @Override
    public XMLLoader init(SolrParams args) {
        this.inputFactory = XMLInputFactory.newInstance();
        EmptyEntityResolver.configureXMLInputFactory(this.inputFactory);
        this.inputFactory.setXMLReporter((XMLReporter)xmllog);
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input chain: " + this.inputFactory);
        }
        this.saxFactory = SAXParserFactory.newInstance();
        this.saxFactory.setNamespaceAware(true);
        EmptyEntityResolver.configureSAXParserFactory(this.saxFactory);
        this.xsltCacheLifetimeSeconds = 60;
        if (args != null) {
            this.xsltCacheLifetimeSeconds = args.getInt(XSLT_CACHE_PARAM, 60);
            log.info("xsltCacheLifetimeSeconds=" + this.xsltCacheLifetimeSeconds);
        }
        return this;
    }

    @Override
    public String getDefaultWT() {
        return "xml";
    }

    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        String charset = ContentStreamBase.getCharsetFromContentType((String)stream.getContentType());
        InputStream is = null;
        XMLStreamReader parser = null;
        String tr = req.getParams().get("tr", null);
        if (tr != null) {
            Transformer t = this.getTransformer(tr, req);
            DOMResult result = new DOMResult();
            try {
                is = stream.getStream();
                InputSource isrc = new InputSource(is);
                isrc.setEncoding(charset);
                XMLReader xmlr = this.saxFactory.newSAXParser().getXMLReader();
                xmlr.setErrorHandler((ErrorHandler)xmllog);
                xmlr.setEntityResolver(EmptyEntityResolver.SAX_INSTANCE);
                SAXSource source = new SAXSource(xmlr, isrc);
                t.transform(source, result);
            }
            catch (TransformerException te) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, te.getMessage(), (Throwable)te);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            try {
                parser = this.inputFactory.createXMLStreamReader(new DOMSource(result.getNode()));
                this.processUpdate(req, processor, parser);
            }
            catch (XMLStreamException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        try {
            is = stream.getStream();
            if (UpdateRequestHandler.log.isTraceEnabled()) {
                byte[] body = IOUtils.toByteArray((InputStream)is);
                UpdateRequestHandler.log.trace("body", (Object)new String(body, charset == null ? "utf-8" : charset));
                IOUtils.closeQuietly((InputStream)is);
                is = new ByteArrayInputStream(body);
            }
            parser = charset == null ? this.inputFactory.createXMLStreamReader(is) : this.inputFactory.createXMLStreamReader(is, charset);
            this.processUpdate(req, processor, parser);
        }
        catch (XMLStreamException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    Transformer getTransformer(String xslt, SolrQueryRequest request) throws IOException {
        Map<Object, Object> ctx = request.getContext();
        Transformer result = (Transformer)ctx.get(CONTEXT_TRANSFORMER_KEY);
        if (result == null) {
            SolrConfig solrConfig = request.getCore().getSolrConfig();
            result = TransformerProvider.instance.getTransformer(solrConfig, xslt, this.xsltCacheLifetimeSeconds);
            result.setErrorListener((ErrorListener)xmllog);
            ctx.put(CONTEXT_TRANSFORMER_KEY, result);
        }
        return result;
    }

    void processUpdate(SolrQueryRequest req, UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException, FactoryConfigurationError {
        AddUpdateCommand addCmd = null;
        SolrParams params = req.getParams();
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 8: {
                    parser.close();
                    return;
                }
                case 1: {
                    String currTag = parser.getLocalName();
                    if (currTag.equals("add")) {
                        log.trace("SolrCore.update(add)");
                        addCmd = new AddUpdateCommand(req);
                        addCmd.commitWithin = params.getInt("commitWithin", -1);
                        addCmd.overwrite = params.getBool("overwrite", true);
                        int i = 0;
                        while (true) {
                            if (i >= parser.getAttributeCount()) continue block4;
                            String attrName = parser.getAttributeLocalName(i);
                            String attrVal = parser.getAttributeValue(i);
                            if ("overwrite".equals(attrName)) {
                                addCmd.overwrite = StrUtils.parseBoolean((String)attrVal);
                            } else if ("commitWithin".equals(attrName)) {
                                addCmd.commitWithin = Integer.parseInt(attrVal);
                            } else {
                                log.warn("Unknown attribute id in add:" + attrName);
                            }
                            ++i;
                        }
                    }
                    if ("doc".equals(currTag)) {
                        if (addCmd != null) {
                            log.trace("adding doc...");
                            addCmd.clear();
                            addCmd.solrDoc = this.readDoc(parser);
                            processor.processAdd(addCmd);
                            break;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected <doc> tag without an <add> tag surrounding it.");
                    }
                    if ("commit".equals(currTag) || "optimize".equals(currTag)) {
                        log.trace("parsing " + currTag);
                        CommitUpdateCommand cmd = new CommitUpdateCommand(req, "optimize".equals(currTag));
                        ModifiableSolrParams mp = new ModifiableSolrParams();
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            String attrName = parser.getAttributeLocalName(i);
                            String attrVal = parser.getAttributeValue(i);
                            mp.set(attrName, new String[]{attrVal});
                        }
                        RequestHandlerUtils.validateCommitParams((SolrParams)mp);
                        SolrParams p = SolrParams.wrapDefaults((SolrParams)mp, (SolrParams)req.getParams());
                        RequestHandlerUtils.updateCommit(cmd, p);
                        processor.processCommit(cmd);
                        break;
                    }
                    if ("rollback".equals(currTag)) {
                        log.trace("parsing " + currTag);
                        RollbackUpdateCommand cmd = new RollbackUpdateCommand(req);
                        processor.processRollback(cmd);
                        break;
                    }
                    if (!"delete".equals(currTag)) break;
                    log.trace("parsing delete");
                    this.processDelete(req, processor, parser);
                }
            }
        }
    }

    void processDelete(SolrQueryRequest req, UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException {
        DeleteUpdateCommand deleteCmd = new DeleteUpdateCommand(req);
        SolrParams params = req.getParams();
        deleteCmd.commitWithin = params.getInt("commitWithin", -1);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrName = parser.getAttributeLocalName(i);
            String attrVal = parser.getAttributeValue(i);
            if ("fromPending".equals(attrName) || "fromCommitted".equals(attrName)) continue;
            if ("commitWithin".equals(attrName)) {
                deleteCmd.commitWithin = Integer.parseInt(attrVal);
                continue;
            }
            log.warn("unexpected attribute delete/@" + attrName);
        }
        StringBuilder text = new StringBuilder();
        block6: while (true) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    String mode = parser.getLocalName();
                    if (!"id".equals(mode) && !"query".equals(mode)) {
                        log.warn("unexpected XML tag /delete/" + mode);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag /delete/" + mode);
                    }
                    text.setLength(0);
                    if (!"id".equals(mode)) break;
                    int i = 0;
                    while (true) {
                        if (i >= parser.getAttributeCount()) continue block6;
                        String attrName = parser.getAttributeLocalName(i);
                        String attrVal = parser.getAttributeValue(i);
                        if ("version".equals(attrName)) {
                            deleteCmd.setVersion(Long.parseLong(attrVal));
                        }
                        ++i;
                    }
                }
                case 2: {
                    String currTag = parser.getLocalName();
                    if ("id".equals(currTag)) {
                        deleteCmd.setId(text.toString());
                    } else if ("query".equals(currTag)) {
                        deleteCmd.setQuery(text.toString());
                    } else {
                        if ("delete".equals(currTag)) {
                            return;
                        }
                        log.warn("unexpected XML tag /delete/" + currTag);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag /delete/" + currTag);
                    }
                    processor.processDelete(deleteCmd);
                    deleteCmd.clear();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                }
            }
        }
    }

    public SolrInputDocument readDoc(XMLStreamReader parser) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        String attrName = "";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrName = parser.getAttributeLocalName(i);
            if ("boost".equals(attrName)) {
                doc.setDocumentBoost(Float.parseFloat(parser.getAttributeValue(i)));
                continue;
            }
            log.warn("Unknown attribute doc/@" + attrName);
        }
        StringBuilder text = new StringBuilder();
        String name = null;
        float boost = 1.0f;
        boolean isNull = false;
        String update = null;
        HashMap updateMap = null;
        boolean complete = false;
        while (!complete) {
            int event = parser.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                    break;
                }
                case 2: {
                    String v;
                    if ("doc".equals(parser.getLocalName())) {
                        complete = true;
                        break;
                    }
                    if (!"field".equals(parser.getLocalName())) break;
                    String string = v = isNull ? null : text.toString();
                    if (update != null) {
                        Object val;
                        HashMap<String, Object> extendedValues;
                        if (updateMap == null) {
                            updateMap = new HashMap();
                        }
                        if ((extendedValues = (HashMap<String, Object>)updateMap.get(name)) == null) {
                            extendedValues = new HashMap<String, Object>(1);
                            updateMap.put(name, extendedValues);
                        }
                        if ((val = extendedValues.get(update)) == null) {
                            extendedValues.put(update, v);
                            break;
                        }
                        if (val instanceof List) {
                            List list = (List)val;
                            list.add(v);
                            break;
                        }
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.add(val);
                        values.add(v);
                        extendedValues.put(update, values);
                        break;
                    }
                    doc.addField(name, (Object)v, boost);
                    boost = 1.0f;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = parser.getLocalName();
                    if (!"field".equals(localName)) {
                        log.warn("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    boost = 1.0f;
                    update = null;
                    String attrVal = "";
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        attrVal = parser.getAttributeValue(i);
                        if ("name".equals(attrName)) {
                            name = attrVal;
                            continue;
                        }
                        if ("boost".equals(attrName)) {
                            boost = Float.parseFloat(attrVal);
                            continue;
                        }
                        if ("null".equals(attrName)) {
                            isNull = StrUtils.parseBoolean((String)attrVal);
                            continue;
                        }
                        if ("update".equals(attrName)) {
                            update = attrVal;
                            continue;
                        }
                        log.warn("Unknown attribute doc/field/@" + attrName);
                    }
                    break;
                }
            }
        }
        if (updateMap != null) {
            for (Map.Entry entry : updateMap.entrySet()) {
                name = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                doc.addField(name, (Object)value, 1.0f);
            }
        }
        return doc;
    }
}

