/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.request.FieldAnalysisRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;

public class FieldAnalysisRequestHandler
extends AnalysisRequestHandlerBase {
    @Override
    protected NamedList doAnalysis(SolrQueryRequest req) throws Exception {
        FieldAnalysisRequest analysisRequest = this.resolveAnalysisRequest(req);
        IndexSchema indexSchema = req.getCore().getSchema();
        return this.handleAnalysisRequest(analysisRequest, indexSchema);
    }

    @Override
    public String getDescription() {
        return "Provide a breakdown of the analysis process of field/query text";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_1/solr/core/src/java/org/apache/solr/handler/FieldAnalysisRequestHandler.java $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldAnalysisRequest resolveAnalysisRequest(SolrQueryRequest req) {
        Iterator<ContentStream> i$;
        SolrParams solrParams = req.getParams();
        FieldAnalysisRequest analysisRequest = new FieldAnalysisRequest();
        boolean useDefaultSearchField = true;
        if (solrParams.get("analysis.fieldtype") != null) {
            analysisRequest.setFieldTypes(Arrays.asList(solrParams.get("analysis.fieldtype").split(",")));
            useDefaultSearchField = false;
        }
        if (solrParams.get("analysis.fieldname") != null) {
            analysisRequest.setFieldNames(Arrays.asList(solrParams.get("analysis.fieldname").split(",")));
            useDefaultSearchField = false;
        }
        if (useDefaultSearchField) {
            analysisRequest.addFieldName(req.getSchema().getDefaultSearchFieldName());
        }
        analysisRequest.setQuery(solrParams.get("analysis.query", solrParams.get("q")));
        String value = solrParams.get("analysis.fieldvalue");
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams != null && (i$ = streams.iterator()).hasNext()) {
            ContentStream stream = i$.next();
            Reader reader = null;
            try {
                reader = stream.getReader();
                value = IOUtils.toString((Reader)reader);
            }
            catch (IOException e) {
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        analysisRequest.setFieldValue(value);
        analysisRequest.setShowMatch(solrParams.getBool("analysis.showmatch", false));
        return analysisRequest;
    }

    protected NamedList<NamedList> handleAnalysisRequest(FieldAnalysisRequest request, IndexSchema schema) {
        SimpleOrderedMap analysisResults = new SimpleOrderedMap();
        SimpleOrderedMap fieldTypeAnalysisResults = new SimpleOrderedMap();
        if (request.getFieldTypes() != null) {
            for (String fieldTypeName : request.getFieldTypes()) {
                FieldType fieldType = schema.getFieldTypes().get(fieldTypeName);
                fieldTypeAnalysisResults.add(fieldTypeName, this.analyzeValues(request, fieldType, null));
            }
        }
        SimpleOrderedMap fieldNameAnalysisResults = new SimpleOrderedMap();
        if (request.getFieldNames() != null) {
            for (String fieldName : request.getFieldNames()) {
                FieldType fieldType = schema.getFieldType(fieldName);
                fieldNameAnalysisResults.add(fieldName, this.analyzeValues(request, fieldType, fieldName));
            }
        }
        analysisResults.add("field_types", (Object)fieldTypeAnalysisResults);
        analysisResults.add("field_names", (Object)fieldNameAnalysisResults);
        return analysisResults;
    }

    private NamedList<NamedList> analyzeValues(FieldAnalysisRequest analysisRequest, FieldType fieldType, String fieldName) {
        NamedList<? extends Object> analyzedTokens;
        AnalysisRequestHandlerBase.AnalysisContext context;
        String queryValue = analysisRequest.getQuery();
        Set<BytesRef> termsToMatch = queryValue != null && analysisRequest.isShowMatch() ? this.getQueryTokenSet(queryValue, fieldType.getQueryAnalyzer()) : EMPTY_BYTES_SET;
        SimpleOrderedMap analyzeResults = new SimpleOrderedMap();
        if (analysisRequest.getFieldValue() != null) {
            context = new AnalysisRequestHandlerBase.AnalysisContext(fieldName, fieldType, fieldType.getAnalyzer(), termsToMatch);
            analyzedTokens = this.analyzeValue(analysisRequest.getFieldValue(), context);
            analyzeResults.add("index", analyzedTokens);
        }
        if (analysisRequest.getQuery() != null) {
            context = new AnalysisRequestHandlerBase.AnalysisContext(fieldName, fieldType, fieldType.getQueryAnalyzer());
            analyzedTokens = this.analyzeValue(analysisRequest.getQuery(), context);
            analyzeResults.add("query", analyzedTokens);
        }
        return analyzeResults;
    }
}

