/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Diagnostics {
    protected static Logger log = LoggerFactory.getLogger(Diagnostics.class);

    public static void call(Callable callable, Object ... data) {
        try {
            callable.call(data);
        }
        catch (Throwable th) {
            log.error("TEST HOOK EXCEPTION", th);
        }
    }

    public static void logThreadDumps(String message) {
        ThreadInfo[] threads;
        StringBuilder sb = new StringBuilder(32768);
        if (message == null) {
            message = "============ THREAD DUMP REQUESTED ============";
        }
        sb.append(message);
        sb.append("\n");
        for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
            sb.append(info);
        }
        log.error(sb.toString());
    }

    public static interface Callable {
        public void call(Object ... var1);
    }
}

