/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.handler.impl;

import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.delegate.MethodInvoker;
import org.seasar.chronos.core.task.Transition;
import org.seasar.chronos.core.task.handler.TaskExecuteHandler;
import org.seasar.chronos.core.task.impl.TaskMethodManager;
import org.seasar.chronos.core.task.strategy.TaskExecuteStrategy;
import org.seasar.framework.log.Logger;

public abstract class AbstractTaskExecuteHandler
implements TaskExecuteHandler {
    private static final long serialVersionUID = 1L;
    protected static final String METHOD_PREFIX_NAME_DO = "do";
    protected static final String METHOD_PREFIX_NAME_START = "start";
    protected static final String METHOD_PREFIX_NAME_END = "end";
    private static Logger log = Logger.getLogger(AbstractTaskExecuteHandler.class);
    private MethodInvoker methodInvoker;
    public TaskMethodManager taskMethodManager;
    private TaskExecuteStrategy taskExecuteStrategy;

    public abstract Transition handleRequest(String var1) throws InterruptedException;

    public void setTaskExecuteStrategy(TaskExecuteStrategy taskExecuteStrategy) {
        this.taskExecuteStrategy = taskExecuteStrategy;
    }

    public TaskExecuteStrategy getTaskExecuteStrategy() {
        return this.taskExecuteStrategy;
    }

    public void setMethodInvoker(MethodInvoker methodInvoker) {
        this.methodInvoker = methodInvoker;
    }

    public MethodInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    public void setMethodGroupMap(TaskMethodManager taskMethodManager) {
        this.taskMethodManager = taskMethodManager;
    }

    public TaskMethodManager getMethodGroupMap() {
        return this.taskMethodManager;
    }

    protected String toMethodName(String taskName) {
        StringBuffer sb = new StringBuffer();
        String firstChar = taskName.substring(0, 1);
        String afterString = taskName.substring(1);
        sb.append(METHOD_PREFIX_NAME_DO);
        sb.append(firstChar.toUpperCase());
        sb.append(afterString);
        return sb.toString();
    }

    protected String toTaskName(String functionName) {
        StringBuffer sb = new StringBuffer("");
        if (functionName.startsWith(METHOD_PREFIX_NAME_DO)) {
            functionName = functionName.substring(2);
            String firstChar = functionName.substring(0, 1).toLowerCase();
            String afterString = functionName.substring(1);
            sb.append(firstChar).append(afterString);
        }
        return sb.toString();
    }

    protected Transition getTerminateTransition() {
        return this.getTerminateTransition(null);
    }

    protected Transition getTerminateTransition(String lastTaskName) {
        boolean terminate = false;
        TaskTrigger taskTrigger = this.getTaskExecuteStrategy().getTrigger();
        terminate = taskTrigger != null ? taskTrigger.isEndTask() : this.getTaskExecuteStrategy().isEndTask();
        if (terminate) {
            return new Transition(true, null, lastTaskName);
        }
        return null;
    }
}

