/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.executor.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.executor.ExecutorServiceFactory;
import org.seasar.chronos.core.threadpool.ThreadPool;
import org.seasar.framework.log.Logger;

public class ExecutorServiceFactoryImpl
implements ExecutorServiceFactory {
    private static Logger log = Logger.getLogger(ExecutorServiceFactoryImpl.class);
    private final AtomicLong threadGroupNo = new AtomicLong();
    private ClassLoaderWrapper classLoaderWrapper;

    public ExecutorService create(ThreadPoolType type, Integer threadPoolSize) {
        return this.create(type, threadPoolSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService create(ThreadPoolType type, Integer threadPoolSize, boolean daemon) {
        Class<ClassLoaderWrapper> clazz = ClassLoaderWrapper.class;
        synchronized (ClassLoaderWrapper.class) {
            if (this.classLoaderWrapper == null) {
                this.classLoaderWrapper = new ClassLoaderWrapper(Thread.currentThread().getContextClassLoader());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ExecutorService executorService = null;
            this.threadGroupNo.addAndGet(1L);
            if (type.equals((Object)ThreadPoolType.CACHED)) {
                executorService = Executors.newCachedThreadPool(new ThreadFactoryImpl(daemon, this.classLoaderWrapper));
            } else if (type.equals((Object)ThreadPoolType.FIXED)) {
                executorService = Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryImpl(daemon, this.classLoaderWrapper));
            } else if (type.equals((Object)ThreadPoolType.SCHEDULED)) {
                executorService = Executors.newScheduledThreadPool(threadPoolSize, new ThreadFactoryImpl(daemon, this.classLoaderWrapper));
            } else if (type.equals((Object)ThreadPoolType.SINGLE)) {
                executorService = Executors.newSingleThreadExecutor(new ThreadFactoryImpl(daemon, this.classLoaderWrapper));
            }
            return executorService;
        }
    }

    public ExecutorService create(ThreadPool threadPool) {
        return this.create(threadPool.getThreadPoolType(), threadPool.getThreadPoolSize(), false);
    }

    public ExecutorService create(ThreadPool threadPool, boolean daemon) {
        return this.create(threadPool.getThreadPoolType(), threadPool.getThreadPoolSize(), daemon);
    }

    public void shutdown() {
        this.classLoaderWrapper.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassLoaderWrapper
    extends ClassLoader {
        ClassLoader classLoader;

        ClassLoaderWrapper(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        void destroy() {
            this.classLoader = null;
        }

        @Override
        public synchronized void clearAssertionStatus() {
            if (this.classLoader != null) {
                this.classLoader.clearAssertionStatus();
            }
        }

        @Override
        public URL getResource(String name) {
            if (this.classLoader != null) {
                return this.classLoader.getResource(name);
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            if (this.classLoader != null) {
                return this.classLoader.getResourceAsStream(name);
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.classLoader != null) {
                return this.classLoader.getResources(name);
            }
            return null;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.classLoader != null) {
                return this.classLoader.loadClass(name);
            }
            return null;
        }

        @Override
        public synchronized void setClassAssertionStatus(String className, boolean enabled) {
            if (this.classLoader != null) {
                this.classLoader.setClassAssertionStatus(className, enabled);
            }
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean enabled) {
            if (this.classLoader != null) {
                this.classLoader.setDefaultAssertionStatus(enabled);
            }
        }

        @Override
        public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
            if (this.classLoader != null) {
                this.classLoader.setPackageAssertionStatus(packageName, enabled);
            }
        }
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        private boolean daemon = false;
        private final ClassLoader classLoader;

        public ThreadFactoryImpl(boolean daemon, ClassLoader classLoader) {
            this.daemon = daemon;
            SecurityManager securitymanager = System.getSecurityManager();
            this.group = securitymanager == null ? Thread.currentThread().getThreadGroup() : securitymanager.getThreadGroup();
            StringBuilder sb = new StringBuilder();
            sb.append("chronos-").append("pool-").append(poolNumber.getAndIncrement());
            sb.append("-");
            if (daemon) {
                sb.append("daemon");
            }
            sb.append("thread-");
            this.namePrefix = sb.toString();
            this.classLoader = classLoader;
        }

        public Thread newThread(Runnable runnable) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.namePrefix).append(this.threadNumber.getAndIncrement());
            Thread thread = new Thread(this.group, runnable, sb.toString(), 0L);
            thread.setDaemon(this.daemon);
            thread.setContextClassLoader(this.classLoader);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

