/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.exception.DfBeanIllegalPropertyException;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentListIndexNotNumberException;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentListIndexOutOfBoundsException;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentNotFoundPropertyException;
import org.seasar.dbflute.twowaysql.exception.BindVariableCommentPropertyReadFailureException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentListIndexNotNumberException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentListIndexOutOfBoundsException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentNotFoundPropertyException;
import org.seasar.dbflute.twowaysql.exception.EmbeddedVariableCommentPropertyReadFailureException;
import org.seasar.dbflute.twowaysql.exception.ForCommentListIndexNotNumberException;
import org.seasar.dbflute.twowaysql.exception.ForCommentListIndexOutOfBoundsException;
import org.seasar.dbflute.twowaysql.exception.ForCommentNotFoundPropertyException;
import org.seasar.dbflute.twowaysql.exception.ForCommentPropertyReadFailureException;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.pmbean.MapParameterBean;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueAndTypeSetupper {
    protected static final String LIKE_SEARCH_OPTION_SUFFIX = "InternalLikeSearchOption";
    protected List<String> _nameList;
    protected String _expression;
    protected String _specifiedSql;
    protected CommentType _commentType;

    public ValueAndTypeSetupper(List<String> nameList, String expression, String specifiedSql, CommentType commentType) {
        this._nameList = nameList;
        this._expression = expression;
        this._specifiedSql = specifiedSql;
        this._commentType = commentType;
    }

    public void setupValueAndType(ValueAndType valueAndType) {
        Object value = valueAndType.getFirstValue();
        if (value == null) {
            return;
        }
        Class<?> clazz = valueAndType.getFirstType();
        LikeSearchOption likeSearchOption = null;
        for (int pos = 1; pos < this._nameList.size() && value != null; ++pos) {
            Map map;
            LikeSearchOption currentOption;
            String currentName = this._nameList.get(pos);
            DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(clazz);
            if (this.hasLikeSearchProperty(beanDesc, currentName, value) && (currentOption = this.getLikeSearchOption(beanDesc, currentName, value)) != null) {
                likeSearchOption = currentOption;
            }
            if (beanDesc.hasPropertyDesc(currentName)) {
                DfPropertyDesc pd = beanDesc.getPropertyDesc(currentName);
                clazz = (value = this.getPropertyValue(clazz, value, currentName, pd)) != null ? value.getClass() : pd.getPropertyType();
                continue;
            }
            if (MapParameterBean.class.isInstance(value) && (map = ((MapParameterBean)value).getParameterMap()).containsKey(currentName)) {
                value = map.get(currentName);
                clazz = value != null ? value.getClass() : null;
                continue;
            }
            if (Map.class.isInstance(value)) {
                map = (Map)value;
                clazz = (value = map.get(currentName)) != null ? value.getClass() : null;
                continue;
            }
            if (List.class.isInstance(value) && currentName.startsWith("get(") && currentName.endsWith(")")) {
                List list = (List)value;
                String exp = Srl.extractScopeFirst(currentName, "get(", ")").getContent();
                try {
                    Integer index = DfTypeUtil.toInteger((Object)exp);
                    value = list.get(index);
                }
                catch (NumberFormatException e) {
                    this.throwListIndexNotNumberException(exp, e);
                }
                catch (IndexOutOfBoundsException e) {
                    this.throwListIndexOutOfBoundsException(exp, e);
                }
                clazz = value != null ? value.getClass() : null;
                continue;
            }
            this.throwNotFoundPropertyException(clazz, currentName);
        }
        this.adjustLikeSearchEscape(likeSearchOption);
        valueAndType.setTargetValue(value);
        valueAndType.setTargetType(clazz);
        valueAndType.setLikeSearchOption(likeSearchOption);
    }

    protected boolean hasLikeSearchProperty(DfBeanDesc beanDesc, String currentName, Object pmb) {
        String propertyName = this.buildLikeSearchPropertyName(currentName);
        boolean result = false;
        if (beanDesc.hasPropertyDesc(propertyName)) {
            result = true;
        } else if (MapParameterBean.class.isInstance(pmb)) {
            Map map = ((MapParameterBean)pmb).getParameterMap();
            result = map.containsKey(propertyName);
        } else if (Map.class.isInstance(pmb)) {
            result = ((Map)pmb).containsKey(propertyName);
        }
        return result;
    }

    protected LikeSearchOption getLikeSearchOption(DfBeanDesc beanDesc, String currentName, Object pmb) {
        LikeSearchOption option;
        String propertyName = this.buildLikeSearchPropertyName(currentName);
        if (beanDesc.hasPropertyDesc(propertyName)) {
            DfPropertyDesc pb = beanDesc.getPropertyDesc(propertyName);
            option = (LikeSearchOption)pb.getValue(pmb);
        } else if (MapParameterBean.class.isInstance(pmb)) {
            Map map = ((MapParameterBean)pmb).getParameterMap();
            option = (LikeSearchOption)map.get(propertyName);
        } else if (Map.class.isInstance(pmb)) {
            option = (LikeSearchOption)((Map)pmb).get(propertyName);
        } else {
            String msg = "Not found the like search property: name=" + propertyName;
            throw new IllegalStateException(msg);
        }
        return option;
    }

    protected String buildLikeSearchPropertyName(String resourceName) {
        return resourceName + LIKE_SEARCH_OPTION_SUFFIX;
    }

    protected void adjustLikeSearchEscape(LikeSearchOption option) {
        if (option != null) {
            List<String> wildCardList = ResourceContext.currentDBDef().dbway().getOriginalWildCardList();
            option.acceptOriginalWildCardList(wildCardList);
        }
    }

    protected boolean isLastLoop(int pos) {
        return this._nameList.size() == pos + 1;
    }

    protected Object getPropertyValue(Class<?> beanType, Object beanValue, String currentName, DfPropertyDesc pd) {
        try {
            return pd.getValue(beanValue);
        }
        catch (DfBeanIllegalPropertyException e) {
            this.throwPropertyReadFailureException(beanType, currentName, e);
            return null;
        }
    }

    protected Object invokeGetter(Method method, Object target) {
        return DfReflectionUtil.invoke(method, target, null);
    }

    protected void throwPropertyReadFailureException(Class<?> targetType, String propertyName, DfBeanIllegalPropertyException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Failed to read the property on the " + this._commentType.textName() + ".");
        br.addItem("Advice");
        br.addElement("Please confirm your comment properties.");
        br.addElement("(readable? accessbile? and so on...)");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("Illegal Property");
        br.addElement(DfTypeUtil.toClassTitle(targetType) + "." + propertyName);
        br.addItem("Exception Message");
        br.addElement(e.getClass());
        br.addElement(e.getMessage());
        Throwable cause = e.getCause();
        if (cause != null) {
            br.addElement(cause.getClass());
            br.addElement(cause.getMessage());
            Throwable nextCause = cause.getCause();
            if (nextCause != null) {
                br.addElement(nextCause.getClass());
                br.addElement(nextCause.getMessage());
            }
        }
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (CommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentPropertyReadFailureException(msg, e);
        }
        if (CommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentPropertyReadFailureException(msg, e);
        }
        if (CommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentPropertyReadFailureException(msg, e);
        }
        throw new BindVariableCommentPropertyReadFailureException(msg, e);
    }

    protected void throwNotFoundPropertyException(Class<?> targetType, String notFoundProperty) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The property on the " + this._commentType.textName() + " was not found.");
        br.addItem("Advice");
        br.addElement("Please confirm the existence of your property on your arguments.");
        br.addElement("And has the property had misspelling?");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("NotFound Property");
        br.addElement((targetType != null ? targetType.getName() + "#" : "") + notFoundProperty);
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (CommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentNotFoundPropertyException(msg);
        }
        if (CommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentNotFoundPropertyException(msg);
        }
        if (CommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentNotFoundPropertyException(msg);
        }
        throw new BindVariableCommentNotFoundPropertyException(msg);
    }

    protected void throwListIndexNotNumberException(String notNumberIndex, NumberFormatException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The list index on the " + this._commentType.textName() + " was not number.");
        br.addItem("Advice");
        br.addElement("Please confirm the index on your comment.");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("NotNumber Index");
        br.addElement(notNumberIndex);
        br.addItem("NumberFormatException");
        br.addElement(e.getMessage());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (CommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentListIndexNotNumberException(msg, e);
        }
        if (CommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentListIndexNotNumberException(msg, e);
        }
        if (CommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentListIndexNotNumberException(msg, e);
        }
        throw new BindVariableCommentListIndexNotNumberException(msg, e);
    }

    protected void throwListIndexOutOfBoundsException(String numberIndex, IndexOutOfBoundsException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The list index on the " + this._commentType.textName() + " was out of bounds.");
        br.addItem("Advice");
        br.addElement("Please confirm the index on your comment.");
        br.addItem(this._commentType.titleName());
        br.addElement(this._expression);
        br.addItem("OutOfBounds Index");
        br.addElement(numberIndex);
        br.addItem("IndexOutOfBoundsException");
        br.addElement(e.getMessage());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        if (CommentType.BIND.equals((Object)this._commentType)) {
            throw new BindVariableCommentListIndexOutOfBoundsException(msg, e);
        }
        if (CommentType.EMBEDDED.equals((Object)this._commentType)) {
            throw new EmbeddedVariableCommentListIndexOutOfBoundsException(msg, e);
        }
        if (CommentType.FORCOMMENT.equals((Object)this._commentType)) {
            throw new ForCommentListIndexOutOfBoundsException(msg, e);
        }
        throw new BindVariableCommentListIndexOutOfBoundsException(msg, e);
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommentType {
        BIND("bind variable comment", "Bind Variable Comment"),
        EMBEDDED("embedded variable comment", "Embedded Variable Comment"),
        FORCOMMENT("FOR comment", "FOR COMMENT");

        private String _textName;
        private String _titleName;

        private CommentType(String commentName, String titleName) {
            this._textName = commentName;
            this._titleName = titleName;
        }

        public String textName() {
            return this._textName;
        }

        public String titleName() {
            return this._titleName;
        }
    }
}

