/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.impl.TnFieldBeanAnnotationReader;
import org.seasar.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnDBMetaBeanAnnotationReader
implements TnBeanAnnotationReader {
    public static final String VALUE_TYPE_SUFFIX = "_VALUE_TYPE";
    protected final Class<?> _beanClass;
    protected final boolean _simpleType;
    protected final TnFieldBeanAnnotationReader _fieldBeanAnnotationReader;
    protected final DBMeta _dbmeta;
    protected final DfBeanDesc _beanDesc;

    public TnDBMetaBeanAnnotationReader(Class<?> beanClass) {
        this._beanClass = beanClass;
        this._simpleType = this.isSimpleType(beanClass);
        if (this._simpleType) {
            this._fieldBeanAnnotationReader = null;
            this._dbmeta = null;
            this._beanDesc = null;
        } else if (!Entity.class.isAssignableFrom(beanClass)) {
            this._fieldBeanAnnotationReader = new TnFieldBeanAnnotationReader(beanClass);
            this._dbmeta = null;
            this._beanDesc = null;
        } else {
            this._fieldBeanAnnotationReader = null;
            this._dbmeta = ((Entity)DfReflectionUtil.newInstance(beanClass)).getDBMeta();
            this._beanDesc = DfBeanDescFactory.getBeanDesc(beanClass);
        }
    }

    protected boolean isSimpleType(Class<?> clazz) {
        return clazz == String.class || clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz);
    }

    @Override
    public String getColumnAnnotation(DfPropertyDesc pd) {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getColumnAnnotation(pd);
        }
        if (!this._dbmeta.hasColumn(pd.getPropertyName())) {
            return null;
        }
        return this._dbmeta.findColumnInfo(pd.getPropertyName()).getColumnDbName();
    }

    @Override
    public String getTableAnnotation() {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getTableAnnotation();
        }
        return this._dbmeta.getTableDbName();
    }

    @Override
    public String getVersionNoPropertyName() {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getVersionNoPropertyName();
        }
        if (!this._dbmeta.hasVersionNo()) {
            return null;
        }
        return this._dbmeta.getVersionNoColumnInfo().getPropertyName();
    }

    @Override
    public String getTimestampPropertyName() {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getTimestampPropertyName();
        }
        if (!this._dbmeta.hasUpdateDate()) {
            return null;
        }
        return this._dbmeta.getUpdateDateColumnInfo().getPropertyName();
    }

    @Override
    public String getId(DfPropertyDesc pd) {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getId(pd);
        }
        if (!this._dbmeta.hasColumn(pd.getPropertyName())) {
            return null;
        }
        ColumnInfo columnInfo = this._dbmeta.findColumnInfo(pd.getPropertyName());
        if (this._dbmeta.hasIdentity() && columnInfo.isAutoIncrement()) {
            return "identity";
        }
        return null;
    }

    @Override
    public String getRelationKey(DfPropertyDesc pd) {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getRelationKey(pd);
        }
        if (!this._dbmeta.hasForeign(pd.getPropertyName())) {
            return null;
        }
        ForeignInfo foreignInfo = this._dbmeta.findForeignInfo(pd.getPropertyName());
        Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap = foreignInfo.getLocalForeignColumnInfoMap();
        Set<ColumnInfo> keySet = localForeignColumnInfoMap.keySet();
        StringBuilder sb = new StringBuilder();
        for (ColumnInfo localColumnInfo : keySet) {
            ColumnInfo foreignColumnInfo = localForeignColumnInfoMap.get(localColumnInfo);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(localColumnInfo.getColumnDbName());
            sb.append(":").append(foreignColumnInfo.getColumnDbName());
        }
        return sb.toString();
    }

    @Override
    public int getRelationNo(DfPropertyDesc pd) {
        if (this._simpleType) {
            return 0;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getRelationNo(pd);
        }
        ForeignInfo foreignInfo = this._dbmeta.findForeignInfo(pd.getPropertyName());
        return foreignInfo.getRelationNo();
    }

    @Override
    public boolean hasRelationNo(DfPropertyDesc pd) {
        if (this._simpleType) {
            return false;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.hasRelationNo(pd);
        }
        return this._dbmeta.hasForeign(pd.getPropertyName());
    }

    @Override
    public String getValueType(DfPropertyDesc pd) {
        if (this._simpleType) {
            return null;
        }
        if (this._fieldBeanAnnotationReader != null) {
            return this._fieldBeanAnnotationReader.getValueType(pd);
        }
        String valueTypeKey = pd.getPropertyName() + VALUE_TYPE_SUFFIX;
        if (this._beanDesc.hasField(valueTypeKey)) {
            Field field = this._beanDesc.getField(valueTypeKey);
            return (String)DfReflectionUtil.getValue(field, null);
        }
        return null;
    }
}

