/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.process;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.helper.process.ProcessConsoleReader;
import org.seasar.dbflute.helper.process.ProcessResult;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemScript {
    public static final String WINDOWS_BATCH_EXT = ".bat";
    public static final String SHELL_SCRIPT_EXT = ".sh";
    protected static final List<String> SUPPORTED_EXT_LIST;
    protected String _consoleEncoding;
    protected Map<String, String> _environmentMap;

    public static List<String> getSupportedExtList() {
        return SUPPORTED_EXT_LIST;
    }

    public ProcessResult execute(File baseDir, String scriptName) {
        Process process;
        ProcessResult result = new ProcessResult(scriptName);
        ArrayList<String> cmdList = new ArrayList<String>();
        if (this.isSystemWindowsOS()) {
            if (scriptName.endsWith(WINDOWS_BATCH_EXT)) {
                cmdList.add("cmd.exe");
                cmdList.add("/c");
                cmdList.add(scriptName);
            }
        } else if (scriptName.endsWith(SHELL_SCRIPT_EXT)) {
            cmdList.add("sh");
            cmdList.add(scriptName);
        }
        if (cmdList.isEmpty()) {
            result.setSystemMismatch(true);
            return result;
        }
        ProcessBuilder builder = new ProcessBuilder(cmdList);
        if (this._environmentMap != null && !this._environmentMap.isEmpty()) {
            builder.environment().putAll(this._environmentMap);
        }
        try {
            process = builder.directory(baseDir).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            String msg = "Failed to execute the command: " + scriptName;
            throw new IllegalStateException(msg, e);
        }
        InputStream stdin = null;
        try {
            stdin = process.getInputStream();
            String encoding = this._consoleEncoding != null ? this._consoleEncoding : "UTF-8";
            ProcessConsoleReader reader = new ProcessConsoleReader(stdin, encoding);
            reader.start();
            int exitCode = process.waitFor();
            reader.join();
            String console = reader.read();
            result.setConsole(console);
            result.setExitCode(exitCode);
            return result;
        }
        catch (InterruptedException e) {
            String msg = "The execution was interrupted: " + scriptName;
            throw new IllegalStateException(msg, e);
        }
    }

    protected boolean isSystemWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("windows");
    }

    public String getConsoleEncoding() {
        return this._consoleEncoding;
    }

    public void setConsoleEncoding(String consoleEncoding) {
        this._consoleEncoding = consoleEncoding;
    }

    public Map<String, String> getEnvironmentMap() {
        return this._environmentMap;
    }

    public void setEnvironmentMap(Map<String, String> environmentMap) {
        this._environmentMap = environmentMap;
    }

    static {
        ArrayList<String> tmpList = DfCollectionUtil.newArrayList(WINDOWS_BATCH_EXT, SHELL_SCRIPT_EXT);
        SUPPORTED_EXT_LIST = Collections.unmodifiableList(tmpList);
    }
}

