/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractSelectCBCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCountCBCommand
extends AbstractSelectCBCommand<Integer> {
    protected Boolean _uniqueCount;

    @Override
    public String getCommandName() {
        return "selectCount";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return Integer.class;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        ConditionBean cb = this._conditionBean;
        cb.xsetupSelectCountIgnoreFetchScope(this._uniqueCount);
        ConditionBeanContext.setConditionBeanOnThread(cb);
    }

    @Override
    public void afterExecuting() {
        this.assertStatus("afterExecuting");
        ConditionBean cb = this._conditionBean;
        cb.xafterCareSelectCountIgnoreFetchScope();
    }

    @Override
    public boolean isSelectCount() {
        return true;
    }

    @Override
    public String buildSqlExecutionKey() {
        return super.buildSqlExecutionKey() + ":" + (this._uniqueCount != false ? "unique" : "plain");
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                TnResultSetHandler handler = SelectCountCBCommand.this.createScalarResultSetHandler(SelectCountCBCommand.this.getCommandReturnType());
                return SelectCountCBCommand.this.createSelectCBExecution(SelectCountCBCommand.this._conditionBean.getClass(), handler);
            }
        };
    }

    @Override
    protected void assertStatus(String methodName) {
        super.assertStatus(methodName);
        if (this._uniqueCount == null) {
            throw new IllegalStateException(this.buildAssertMessage("_uniqueCount", methodName));
        }
    }

    public void setUniqueCount(boolean uniqueCount) {
        this._uniqueCount = uniqueCount;
    }
}

