/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.awt.Graphics;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class FileLauncher
extends JApplet {
    private static final int REDIRECT_DELAY_TIME = 2000;
    private static final long serialVersionUID = 1L;
    private String message;
    private transient ResourceBundle resources;
    private File file;

    @Override
    public void paint(Graphics g) {
        g.drawString(this.message, 0, 20);
    }

    @Override
    public void init() {
        this.resources = ResourceBundle.getBundle("messages", this.getLocale());
        try {
            this.file = this.getFile();
        }
        catch (Exception e) {
            this.message = e.getLocalizedMessage();
        }
    }

    @Override
    public void start() {
        if (this.file != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int ret = JOptionPane.showConfirmDialog(FileLauncher.this.getContentPane().getParent(), FileLauncher.this.getMsg("dialog.message"), FileLauncher.this.getMsg("dialog.title"), 0, -1);
                    if (ret == 0) {
                        FileLauncher.this.launch(FileLauncher.this.file);
                    } else if (ret == 1) {
                        FileLauncher.this.showReferrer(0L);
                    }
                }
            }).start();
        }
        if (this.message == null) {
            this.message = "";
        }
    }

    private String getMsg(String key) {
        return this.resources.getString(key);
    }

    private String getMsg(String key, Object ... arguments) {
        return MessageFormat.format(this.resources.getString(key), arguments);
    }

    private File getFile() {
        String uriParam = this.getRequestParameter("uri");
        if (this.isBlank(uriParam)) {
            this.message = this.getMsg("msg.no_uri");
            return null;
        }
        File targetFile = null;
        String path = uriParam.replaceFirst("file:/+", "");
        int pos1 = path.indexOf(58);
        int pos2 = path.indexOf(47);
        targetFile = pos1 > 0 && pos2 > 0 && pos1 < pos2 ? new File(path) : new File(uriParam.replace("file:", ""));
        if (!targetFile.exists()) {
            this.message = this.getMsg("msg.not_found", targetFile.getAbsolutePath());
            return null;
        }
        this.message = this.getMsg("msg.open_file", targetFile.getAbsolutePath());
        return targetFile;
    }

    private void launch(File file) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
            this.message = this.getMsg("msg.opened_file", file.getAbsolutePath());
        }
        catch (Exception e) {
            this.message = e.getMessage();
            this.repaint();
        }
        try {
            this.showReferrer(2000L);
        }
        catch (Exception e) {
            this.message = e.getMessage();
            this.repaint();
        }
    }

    private void showReferrer(long sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String referrer = this.getRequestParameter("referrer");
        if (!this.isBlank(referrer)) {
            try {
                this.getAppletContext().showDocument(new URL(referrer), "_self");
            }
            catch (Exception e) {
                this.message = e.getMessage();
                this.repaint();
            }
        }
    }

    private String getRequestParameter(String key) {
        String value = this.getParameter(key);
        if (this.isBlank(value)) {
            return null;
        }
        return value;
    }

    private boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

