/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.valuetype.plugin;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.seasar.robot.dbflute.Entity;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.jdbc.PhysicalConnectionDigger;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.OracleAgent;
import org.seasar.robot.dbflute.util.DfCollectionUtil;
import org.seasar.robot.dbflute.util.DfReflectionUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GreatWallOfOracleType
implements ValueType {
    protected final int _sqlType;
    protected final String _mainTypeName;
    protected final Class<?> _mainObjectType;
    protected final Entity _mainEntityPrototype;
    protected final OracleAgent _agent;
    protected final PhysicalConnectionDigger _digger;

    public GreatWallOfOracleType(int sqlType, String mainTypeName, Class<?> mainObjectType) {
        this._sqlType = sqlType;
        this._mainTypeName = mainTypeName;
        this._mainObjectType = mainObjectType;
        this._mainEntityPrototype = Entity.class.isAssignableFrom(mainObjectType) ? (Entity)DfReflectionUtil.newInstance(mainObjectType) : null;
        this._agent = this.createOracleAgent();
        this._digger = this._agent.getPhysicalConnectionDigger();
    }

    protected abstract OracleAgent createOracleAgent();

    protected abstract String getTitleName();

    protected List<Object> mappingOracleArrayToList(Object oracleArray, Object elementType) throws SQLException {
        if (oracleArray == null) {
            return DfCollectionUtil.newArrayList();
        }
        Object firstValue = null;
        Object[] plainArray = (Object[])this.toStandardArray(oracleArray);
        if (plainArray == null || plainArray.length == 0) {
            return DfCollectionUtil.newArrayList();
        }
        List objList = DfCollectionUtil.newArrayList();
        for (Object element : plainArray) {
            if (element == null) continue;
            if (firstValue == null) {
                firstValue = element;
            }
            objList.add(element);
        }
        Object[] array = objList.toArray();
        return this.doMappingOracleArrayToList(array, firstValue, elementType);
    }

    protected List<Object> doMappingOracleArrayToList(Object[] array, Object firstValue, Object elementType) throws SQLException {
        if (firstValue == null) {
            return DfCollectionUtil.newArrayList();
        }
        List<Object> resultList = DfCollectionUtil.newArrayList();
        if (this.isOracleArray(firstValue)) {
            throw new UnsupportedOperationException("array in array is unsupported: " + this._mainTypeName);
        }
        if (this.isOracleStruct(firstValue)) {
            for (Object element : array) {
                resultList.add(this.mappingOracleStructToEntity(element, elementType));
            }
        } else {
            if (!Class.class.equals(elementType.getClass())) {
                String msg = "The element type should be class type when scalar element:";
                msg = msg + " firstValue=" + firstValue + " elementType=" + elementType;
                throw new IllegalStateException(msg);
            }
            for (Object element : array) {
                resultList.add(this.adjustScalarToPropertyValue(element, (Class)elementType));
            }
        }
        return resultList;
    }

    protected Entity mappingOracleStructToEntity(Object oracleStruct, Object entityType) throws SQLException {
        Entity prototype;
        if (oracleStruct == null) {
            return null;
        }
        if (entityType instanceof Entity) {
            prototype = (Entity)entityType;
        } else if (entityType instanceof Class) {
            prototype = (Entity)DfReflectionUtil.newInstance((Class)entityType);
        } else {
            String msg = "The entityType should be entity instance or entity type: " + entityType;
            throw new IllegalArgumentException(msg);
        }
        DBMeta dbmeta = prototype.getDBMeta();
        Object[] attrs = this.toStandardStructAttributes(oracleStruct);
        return this.doMappingOracleStructToEntity(dbmeta, attrs);
    }

    protected Entity doMappingOracleStructToEntity(DBMeta dbmeta, Object[] attrs) throws SQLException {
        Entity entity = dbmeta.newEntity();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        this.assertStructAttributeSizeMatched(entity, attrs, columnInfoList);
        for (int i = 0; i < attrs.length; ++i) {
            Object mappedValue;
            Object attr = attrs[i];
            ColumnInfo columnInfo = columnInfoList.get(i);
            String propertyName = columnInfo.getPropertyName();
            Class<?> propertyType = columnInfo.getPropertyType();
            if (attr == null) {
                if (!List.class.isAssignableFrom(propertyType)) continue;
                dbmeta.setupEntityProperty(propertyName, entity, DfCollectionUtil.newArrayList());
                continue;
            }
            if (List.class.isAssignableFrom(propertyType)) {
                Class<?> elementType = columnInfo.getGenericType();
                mappedValue = this.mappingOracleArrayToList(attr, elementType);
            } else {
                mappedValue = Entity.class.isAssignableFrom(propertyType) ? this.mappingOracleStructToEntity(attr, propertyType) : this.adjustScalarToPropertyValue(attr, propertyType);
            }
            dbmeta.setupEntityProperty(propertyName, entity, mappedValue);
        }
        return entity;
    }

    protected Object adjustScalarToPropertyValue(Object value, Class<?> propertyType) throws SQLException {
        if (propertyType == null) {
            return value;
        }
        if (Number.class.isAssignableFrom(propertyType)) {
            value = DfTypeUtil.toNumber(value, propertyType);
        } else if (Date.class.isAssignableFrom(propertyType)) {
            value = DfTypeUtil.toPointDate(value, propertyType);
        }
        return value;
    }

    protected void assertStructAttributeSizeMatched(Entity entity, Object[] attrs, List<ColumnInfo> columnInfoList) {
        if (attrs.length != columnInfoList.size()) {
            this.throwStructAttributeSizeUnmatchedException(entity, attrs, columnInfoList);
        }
    }

    protected void throwStructAttributeSizeUnmatchedException(Entity entity, Object[] attrs, List<ColumnInfo> columnInfoList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The size of struct attributes does not match with column list of entity.");
        br.addItem(this.getTitleName());
        br.addElement(this._mainTypeName);
        br.addItem("Entity");
        br.addElement(DfTypeUtil.toClassTitle(entity));
        br.addItem("Attribute Size");
        br.addElement(attrs.length);
        br.addItem("Column List Size");
        br.addElement(columnInfoList.size());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setObject(index, this.toBindValue(conn, index, value));
        }
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setObject(parameterName, this.toBindValue(conn, parameterName, value));
        }
    }

    protected abstract Object toBindValue(Connection var1, Object var2, Object var3) throws SQLException;

    protected Object mappingListToOracleArray(Connection conn, Object paramExp, List<?> valueList, String arrayTypeName, Class<?> elementType) throws SQLException {
        Object[] preparedArray;
        Object[] array = valueList.toArray();
        if (array.length == 0) {
            return array;
        }
        if (List.class.isAssignableFrom(elementType)) {
            throw new UnsupportedOperationException("array in array is unsupported: " + this._mainTypeName);
        }
        if (Entity.class.isAssignableFrom(elementType)) {
            List structList = DfCollectionUtil.newArrayList();
            for (Object element : array) {
                if (element == null) continue;
                this.assertArrayElementValueStructEntity(paramExp, element, arrayTypeName, elementType);
                Entity entity = (Entity)element;
                structList.add(this.mappingEntityToOracleStruct(conn, paramExp, entity));
            }
            preparedArray = structList.toArray();
        } else {
            List elementList = DfCollectionUtil.newArrayList();
            for (Object element : array) {
                if (element == null) continue;
                elementList.add(this.mappingScalarToSqlValue(conn, paramExp, element, null));
            }
            preparedArray = elementList.toArray();
        }
        return this.toOracleArray(conn, arrayTypeName, preparedArray);
    }

    protected Object mappingEntityToOracleStruct(Connection conn, Object paramExp, Entity entity) throws SQLException {
        DBMeta dbmeta = entity.getDBMeta();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        ArrayList<Object> attrList = new ArrayList<Object>();
        for (ColumnInfo columnInfo : columnInfoList) {
            Object mappedValue;
            Object propertyValue = columnInfo.read(entity);
            if (propertyValue instanceof List) {
                Class<?> firstElementType;
                Class<?> propertyType;
                List nested = (List)propertyValue;
                String arrayTypeName = columnInfo.getColumnDbType();
                Class<?> elementType = propertyType = columnInfo.getPropertyType();
                if (List.class.isAssignableFrom(propertyType)) {
                    elementType = columnInfo.getGenericType();
                } else if (Object.class.equals(propertyType) && DfCollectionUtil.hasValidElement(nested) && (firstElementType = DfCollectionUtil.findFirstElementType(nested)) != null) {
                    elementType = nested.iterator().next().getClass();
                }
                mappedValue = this.mappingListToOracleArray(conn, paramExp, nested, arrayTypeName, elementType);
            } else {
                mappedValue = propertyValue instanceof Entity ? this.mappingEntityToOracleStruct(conn, paramExp, (Entity)propertyValue) : this.mappingScalarToSqlValue(conn, paramExp, propertyValue, columnInfo);
            }
            attrList.add(mappedValue);
        }
        String structTypeName = dbmeta.getTableSqlName().toString();
        return this.toOracleStruct(this.getOracleConnection(conn), structTypeName, attrList.toArray());
    }

    protected Object mappingScalarToSqlValue(Connection conn, Object paramExp, Object value, ColumnInfo columnInfo) throws SQLException {
        if (value == null) {
            return null;
        }
        Class<?> propertyType = value.getClass();
        if (Date.class.equals(propertyType)) {
            return DfTypeUtil.toTimestamp(value);
        }
        return value;
    }

    protected void assertArrayElementValueStructEntity(Object paramExp, Object element, String arrayTypeName, Class<?> elementType) {
        if (!(element instanceof Entity)) {
            this.throwArrayElementValueNotStructEntityException(paramExp, element, arrayTypeName, elementType);
        }
    }

    protected void throwArrayElementValueNotStructEntityException(Object parameterExp, Object element, String arrayTypeName, Class<?> elementType) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The element value of array for struct should be entity type:");
        br.addItem(this.getTitleName());
        br.addElement(this._mainTypeName);
        br.addItem("Parameter");
        br.addElement(parameterExp);
        br.addItem("Array Type");
        br.addElement(arrayTypeName + "<" + elementType + ">");
        br.addItem("Element Value");
        if (element != null) {
            br.addElement(element.getClass());
        }
        br.addElement(element);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected void setNull(PreparedStatement ps, int index) throws SQLException {
        ps.setNull(index, this.getSqlType(), this._mainTypeName);
    }

    protected void setNull(CallableStatement cs, String parameterName) throws SQLException {
        cs.setNull(parameterName, this.getSqlType(), this._mainTypeName);
    }

    @Override
    public void registerOutParameter(Connection conn, CallableStatement cs, int index) throws SQLException {
        cs.registerOutParameter(index, this.getSqlType(), this._mainTypeName);
    }

    @Override
    public void registerOutParameter(Connection conn, CallableStatement cs, String parameterName) throws SQLException {
        cs.registerOutParameter(parameterName, this.getSqlType(), this._mainTypeName);
    }

    protected Object toOracleArray(Connection conn, String arrayTypeName, Object arrayValue) throws SQLException {
        return this._agent.toOracleArray(this.getOracleConnection(conn), arrayTypeName, arrayValue);
    }

    protected Object toStandardArray(Object oracleArray) throws SQLException {
        return this._agent.toStandardArray(oracleArray);
    }

    protected boolean isOracleArray(Object obj) {
        return this._agent.isOracleArray(obj);
    }

    protected Object toOracleStruct(Connection conn, String structTypeName, Object[] attrs) throws SQLException {
        return this._agent.toOracleStruct(this.getOracleConnection(conn), structTypeName, attrs);
    }

    protected Object[] toStandardStructAttributes(Object oracleStruct) throws SQLException {
        return this._agent.toStandardStructAttributes(oracleStruct);
    }

    protected boolean isOracleStruct(Object obj) {
        return this._agent.isOracleStruct(obj);
    }

    protected Connection getOracleConnection(Connection conn) throws SQLException {
        return this._digger.digUp(conn);
    }

    @Override
    public int getSqlType() {
        return this._sqlType;
    }
}

