/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mobylet.core.Carrier;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.detector.CarrierDetector;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.http.MobyletRequest;
import org.mobylet.core.http.MobyletResponse;
import org.mobylet.core.launcher.LaunchConfig;
import org.mobylet.core.launcher.MobyletLauncher;
import org.mobylet.core.selector.DialectSelector;
import org.mobylet.core.session.MobyletSessionManager;
import org.mobylet.core.type.DispatchType;
import org.mobylet.core.util.LaunchUtils;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
        HttpServletResponse httpResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
        MobyletSessionManager sessionManager = SingletonUtils.get(MobyletSessionManager.class);
        if (sessionManager != null && sessionManager.isManaged(httpRequest)) {
            sessionManager.invoke(httpRequest, httpResponse);
            return;
        }
        HttpServletRequest parentRequest = RequestUtils.get();
        RequestUtils.set(httpRequest);
        boolean isRootInclude = false;
        if (parentRequest != null && RequestUtils.getMobyletContext().get(DispatchType.class) == null) {
            RequestUtils.getMobyletContext().set((Object)DispatchType.INCLUDE_OR_FORWARD);
            isRootInclude = true;
        }
        try {
            this.processFilter(chain, httpRequest, httpResponse);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            RequestUtils.remove();
            if (parentRequest != null) {
                RequestUtils.set(parentRequest);
                if (isRootInclude) {
                    RequestUtils.getMobyletContext().remove(DispatchType.class);
                }
            }
        }
    }

    protected void processFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, IOException, ServletException {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        Carrier carrier = SingletonUtils.get(CarrierDetector.class).getCarrier((HttpServletRequest)request);
        MobyletDialect dialect = SingletonUtils.get(DialectSelector.class).getDialect(carrier);
        String charsetName = dialect.getCharacterEncodingCharsetName();
        request.setCharacterEncoding(charsetName);
        if (RequestUtils.getMobyletContext().get(NativeUrl.class) == null) {
            RequestUtils.getMobyletContext().set(new NativeUrl(request.getRequestURL().toString(), request.getQueryString()));
        }
        if (config.containsThroughCarrier(carrier)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            request = new MobyletRequest((HttpServletRequest)request);
            RequestUtils.set(request);
            ((MobyletRequest)((Object)MobyletRequest.class.cast(request))).parseParameters();
            MobyletResponse mResponse = this.wrapResponse(response, dialect);
            if (RequestUtils.getMobyletContext().get(MobyletResponse.class) == null) {
                RequestUtils.getMobyletContext().set((Object)mResponse);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)mResponse);
            mResponse.flushByMobylet();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LaunchConfig launchConfig = LaunchUtils.getLaunchConfig(filterConfig);
        this.initSingletonContainer(filterConfig);
        this.initLogger(launchConfig);
        this.initDefaultCharset(launchConfig);
        this.initInitializer(launchConfig);
    }

    protected void initSingletonContainer(FilterConfig filterConfig) {
        MobyletLauncher.initSingletonContainer();
        if (filterConfig != null) {
            SingletonUtils.put(filterConfig);
            SingletonUtils.put(filterConfig.getServletContext());
        }
    }

    protected void initLogger(LaunchConfig launchConfig) {
        MobyletLauncher.initLogger(launchConfig);
    }

    protected void initInitializer(LaunchConfig launchConfig) {
        MobyletLauncher.initInitializer(launchConfig);
    }

    protected void initDefaultCharset(LaunchConfig launchConfig) {
        MobyletLauncher.initDefaultCharset(launchConfig);
    }

    protected MobyletResponse wrapResponse(HttpServletResponse response, MobyletDialect dialect) {
        return new MobyletResponse(response, dialect);
    }

    public static class NativeUrl {
        protected String url;
        protected String queryString;

        public NativeUrl(String url, String queryString) {
            this.url = url;
            this.queryString = queryString;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            if (StringUtils.isEmpty(this.queryString)) {
                return this.url;
            }
            return this.url + "?" + this.queryString;
        }
    }
}

