/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.uima.processor.SolrUIMAConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrUIMAConfigurationReader {
    private NamedList<Object> args;

    public SolrUIMAConfigurationReader(NamedList<Object> args) {
        this.args = args;
    }

    public SolrUIMAConfiguration readSolrUIMAConfiguration() {
        return new SolrUIMAConfiguration(this.readAEPath(), this.readFieldsToAnalyze(), this.readFieldsMerging(), this.readTypesFeaturesFieldsMapping(), this.readAEOverridingParameters(), this.readIgnoreErrors(), this.readLogField());
    }

    private String readAEPath() {
        return (String)this.args.get("analysisEngine");
    }

    private NamedList getAnalyzeFields() {
        return (NamedList)this.args.get("analyzeFields");
    }

    private String[] readFieldsToAnalyze() {
        List fields = (List)this.getAnalyzeFields().get("fields");
        return fields.toArray(new String[fields.size()]);
    }

    private boolean readFieldsMerging() {
        return (Boolean)this.getAnalyzeFields().get("merge");
    }

    private Map<String, Map<String, SolrUIMAConfiguration.MapField>> readTypesFeaturesFieldsMapping() {
        HashMap<String, Map<String, SolrUIMAConfiguration.MapField>> map = new HashMap<String, Map<String, SolrUIMAConfiguration.MapField>>();
        NamedList fieldMappings = (NamedList)this.args.get("fieldMappings");
        for (int i = 0; i < fieldMappings.size(); ++i) {
            NamedList type = (NamedList)fieldMappings.get("type", i);
            String typeName = (String)type.get("name");
            HashMap<String, SolrUIMAConfiguration.MapField> subMap = new HashMap<String, SolrUIMAConfiguration.MapField>();
            for (int j = 0; j < type.size() - 1; ++j) {
                NamedList mapping = (NamedList)type.get("mapping", j + 1);
                String featureName = (String)mapping.get("feature");
                String fieldNameFeature = null;
                String mappedFieldName = (String)mapping.get("field");
                if (mappedFieldName == null) {
                    fieldNameFeature = (String)mapping.get("fieldNameFeature");
                    mappedFieldName = (String)mapping.get("dynamicField");
                }
                if (mappedFieldName == null) {
                    throw new RuntimeException("either of field or dynamicField should be defined for feature " + featureName);
                }
                SolrUIMAConfiguration.MapField mapField = new SolrUIMAConfiguration.MapField(mappedFieldName, fieldNameFeature);
                subMap.put(featureName, mapField);
            }
            map.put(typeName, subMap);
        }
        return map;
    }

    private Map<String, Object> readAEOverridingParameters() {
        HashMap<String, Object> runtimeParameters = new HashMap<String, Object>();
        NamedList runtimeParams = (NamedList)this.args.get("runtimeParameters");
        for (int i = 0; i < runtimeParams.size(); ++i) {
            String name = runtimeParams.getName(i);
            Object value = runtimeParams.getVal(i);
            runtimeParameters.put(name, value);
        }
        return runtimeParameters;
    }

    private boolean readIgnoreErrors() {
        Object ignoreErrors = this.args.get("ignoreErrors");
        return ignoreErrors == null ? false : (Boolean)ignoreErrors;
    }

    private String readLogField() {
        return (String)this.args.get("logField");
    }
}

