/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import org.carrot2.core.Jdk15;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.factory.IFactory;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnowballStemmerFactory
implements IFactory<IStemmer> {
    private final Class<? extends SnowballProgram> clazz;
    private final String stemmerClazz;

    public SnowballStemmerFactory(String snowballClazz) {
        this.stemmerClazz = snowballClazz;
        Class<?> clz = null;
        try {
            clz = Class.forName(snowballClazz, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(snowballClazz, true, this.getClass().getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.clazz = clz;
    }

    @Override
    public IStemmer createInstance() {
        if (this.clazz == null) {
            throw new RuntimeException("Snowball stemmer not available: " + this.stemmerClazz);
        }
        try {
            return new SnowballStemmerAdapter(this.clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class SnowballStemmerAdapter
    implements IStemmer {
        private final SnowballProgram snowballStemmer;

        public SnowballStemmerAdapter(SnowballProgram snowballStemmer) {
            this.snowballStemmer = snowballStemmer;
        }

        public CharSequence stem(CharSequence word) {
            int len = word.length();
            char[] buffer = this.snowballStemmer.getCurrentBuffer();
            if (buffer.length < len) {
                buffer = new char[len];
            }
            int i = word.length();
            while (--i >= 0) {
                buffer[i] = word.charAt(i);
            }
            this.snowballStemmer.setCurrent(buffer, len);
            if (this.snowballStemmer.stem()) {
                return new MutableCharArray(Jdk15.copyOf(this.snowballStemmer.getCurrentBuffer(), this.snowballStemmer.getCurrentBufferLength()));
            }
            return null;
        }
    }
}

