/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.solr;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="SolrDocumentSource")
public class SolrDocumentSource
extends RemoteXmlSimpleSearchEngineBase {
    @Input
    @Processing
    @Attribute
    public String serviceUrlBase = "http://localhost:8983/solr/select";
    @Input
    @Processing
    @Attribute
    public String solrTitleFieldName = "title";
    @Input
    @Processing
    @Attribute
    public String solrSummaryFieldName = "description";
    @Input
    @Processing
    @Attribute
    public String solrUrlFieldName = "url";

    @Override
    protected String buildServiceUrl() {
        return this.serviceUrlBase + "?q=" + SolrDocumentSource.urlEncode(this.query) + "&start=" + this.start + "&rows=" + this.results + "&indent=off";
    }

    @Override
    protected IResource getXsltResource() {
        return new ClassResource(SolrDocumentSource.class, "solr-to-c2.xsl");
    }

    @Override
    protected Map<String, String> getXsltParameters() {
        HashMap parameters = Maps.newHashMap();
        parameters.put("solr.title-field", this.solrTitleFieldName);
        parameters.put("solr.summary-field", this.solrSummaryFieldName);
        parameters.put("solr.url-field", this.solrUrlFieldName);
        return parameters;
    }
}

