/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.db.allcommon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.robot.db.allcommon.DBCurrent;
import org.seasar.robot.db.allcommon.DBFluteConfig;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.jdbc.DataSourceHandler;
import org.seasar.robot.dbflute.s2dao.extension.TnSqlLogRegistry;
import org.seasar.robot.dbflute.util.DfSystemUtil;

public class DBFluteInitializer {
    private static final Log _log = LogFactory.getLog(DBFluteInitializer.class);

    public DBFluteInitializer() {
        this.announce();
        this.prologue();
        this.standBy();
    }

    protected void announce() {
        _log.info((Object)"...Initializing DBFlute components");
    }

    protected void prologue() {
        this.handleSqlLogRegistry();
        this.loadCoolClasses();
    }

    protected void standBy() {
        if (!DBFluteConfig.getInstance().isLocked()) {
            DBFluteConfig.getInstance().lock();
        }
    }

    protected void handleSqlLogRegistry() {
        if (DBFluteConfig.getInstance().isUseSqlLogRegistry()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{SqlLog Information}").append(this.ln());
            sb.append("  [SqlLogRegistry]").append(this.ln());
            if (TnSqlLogRegistry.setupSqlLogRegistry()) {
                sb.append("    ...Setting up sqlLogRegistry(org.seasar.extension.jdbc)").append(this.ln());
                sb.append("    because the property 'useSqlLogRegistry' of the config of DBFlute is true");
            } else {
                sb.append("    The sqlLogRegistry(org.seasar.extension.jdbc) is not supported at the version");
            }
            _log.info((Object)sb);
        } else {
            Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
            if (sqlLogRegistry != null) {
                TnSqlLogRegistry.closeRegistration();
            }
        }
    }

    protected void loadCoolClasses() {
        ConditionBeanContext.loadCoolClasses();
    }

    protected void setupDataSourceHandler(String dataSourceFqcn) {
        DBFluteConfig config = DBFluteConfig.getInstance();
        DataSourceHandler dataSourceHandler = config.getDataSourceHandler();
        if (dataSourceHandler != null) {
            return;
        }
        if (dataSourceFqcn.startsWith("org.apache.commons.dbcp.")) {
            config.unlock();
            config.setDataSourceHandler(new DBFluteConfig.SpringDBCPDataSourceHandler());
        }
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return DBCurrent.getInstance().isCurrentDBDef(currentDBDef);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

