/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.valuetype.basic;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.robot.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.robot.dbflute.util.DfTypeUtil;

public class CharacterType
extends TnAbstractValueType {
    public CharacterType() {
        super(1);
    }

    public Object getValue(ResultSet rs, int index) throws SQLException {
        return this.toCharacter(rs.getString(index));
    }

    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return this.toCharacter(rs.getString(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toCharacter(cs.getString(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toCharacter(cs.getString(parameterName));
    }

    private Character toCharacter(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        if (chars.length == 1) {
            return Character.valueOf(chars[0]);
        }
        if (chars.length == 0) {
            return null;
        }
        throw new IllegalStateException("length of String should be 1. actual is [" + value + "]");
    }

    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setString(index, DfTypeUtil.toString(value));
        }
    }

    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setString(parameterName, DfTypeUtil.toString(value));
        }
    }
}

