/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.character.impl;

import org.seasar.robot.dbflute.helper.character.JapaneseCharacter;

public class JapaneseCharacterImpl
implements JapaneseCharacter {
    protected static final String TABLE_ZENKANA = "\u3002\u300c\u300d\u3001\u30fb\u30f2\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3\u30fc\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3\u309b\u309c";
    protected static final String DEF_DOUBLE_BYTE_VOICED_SOUND_NORMAL_KATAKANA = "\u30a2\u30a4\u30f4\u30a8\u30aa\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30d0\u30d3\u30d6\u30d9\u30dc\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3";
    protected static final String DEF_DOUBLE_BYTE_VOICED_SOUND_SPECIAL_KATAKANA = "\u30fa\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7";
    protected static final String DEF_DOUBLE_BYTE_SEMI_VOICED_SOUND_KATAKANA = "\u30d1\u30d4\u30d7\u30da\u30dd";

    public String toDoubleByteKatakana(String target) {
        if (target == null) {
            return target;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < target.length(); ++i) {
            char nextChar;
            char currentChar = target.charAt(i);
            if (this.isVoicedSoundKatakana(currentChar, nextChar = i < target.length() - 1 ? (char)target.charAt(i + 1) : (char)' ')) {
                if (currentChar >= '\uff66' && currentChar <= '\uff6f') {
                    sb.append(DEF_DOUBLE_BYTE_VOICED_SOUND_SPECIAL_KATAKANA.charAt(currentChar - 65382));
                    ++i;
                    continue;
                }
                if (currentChar < '\uff71' || currentChar > '\uff9d') continue;
                sb.append(DEF_DOUBLE_BYTE_VOICED_SOUND_NORMAL_KATAKANA.charAt(currentChar - 65393));
                ++i;
                continue;
            }
            if (this.isSemiVoicedSoundKatakana(currentChar, nextChar)) {
                sb.append(DEF_DOUBLE_BYTE_SEMI_VOICED_SOUND_KATAKANA.charAt(currentChar - 65418));
                ++i;
                continue;
            }
            if (currentChar == '\uff9e' || currentChar == '\uff9f') continue;
            if (currentChar >= '\uff61' && currentChar <= '\uff9f') {
                sb.append(TABLE_ZENKANA.charAt(currentChar - 65377));
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    protected boolean isVoicedSoundKatakana(char currentChar, char nextChar) {
        return (currentChar >= '\uff66' && currentChar <= '\uff6f' || currentChar >= '\uff71' && currentChar <= '\uff9d') && nextChar == '\uff9e';
    }

    protected boolean isSemiVoicedSoundKatakana(char currentChar, char nextChar) {
        return currentChar >= '\uff8a' && currentChar <= '\uff8e' && nextChar == '\uff9f';
    }
}

