/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.exception.handler;

import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.exception.EntityAlreadyExistsException;
import org.seasar.robot.dbflute.exception.SQLFailureException;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.resource.InternalMapContext;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.util.DfSystemUtil;

public class SQLExceptionHandler {
    public void handleSQLException(SQLException e) {
        this.handleSQLException(e, null, false);
    }

    public void handleSQLException(SQLException e, Statement st) {
        this.handleSQLException(e, st, false);
    }

    public void handleSQLException(SQLException e, Statement st, boolean uniqueConstraintValid) {
        this.handleSQLException(e, st, uniqueConstraintValid, null, null);
    }

    public void handleSQLException(SQLException e, Statement st, boolean uniqueConstraintValid, String executedSql, String displaySql) {
        if (uniqueConstraintValid && this.isUniqueConstraintException(e)) {
            this.throwEntityAlreadyExistsException(e, st, executedSql, displaySql);
        }
        this.throwSQLFailureException(e, st, executedSql, displaySql);
    }

    protected boolean isUniqueConstraintException(SQLException e) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        return ResourceContext.isUniqueConstraintException(this.extractSQLState(e), e.getErrorCode());
    }

    protected void throwEntityAlreadyExistsException(SQLException e, Statement st, String executedSql, String displaySql) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity already exists on the database!");
        br.addItem("Advice");
        br.addElement("Please confirm the primary key whether it already exists on the database.");
        br.addElement("And confirm the unique constraint for other columns.");
        this.setupCommonElement(br, e, st, executedSql, displaySql);
        String msg = br.buildExceptionMessage();
        throw new EntityAlreadyExistsException(msg, e);
    }

    protected void throwSQLFailureException(SQLException e, Statement st, String executedSql, String displaySql) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The SQL failed to execute!");
        br.addItem("Advice");
        br.addElement("Please confirm the SQLException message.");
        this.setupCommonElement(br, e, st, executedSql, displaySql);
        String msg = br.buildExceptionMessage();
        throw new SQLFailureException(msg, e);
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected void setupCommonElement(ExceptionMessageBuilder br, SQLException e, Statement st, String executedSql, String displaySql) {
        br.addItem("SQLState");
        br.addElement(this.extractSQLState(e));
        br.addItem("ErrorCode");
        br.addElement(e.getErrorCode());
        this.setupSQLExceptionElement(br, e);
        this.setupBehaviorElement(br);
        this.setupConditionBeanElement(br);
        this.setupOutsideSqlElement(br);
        this.setupStatementElement(br, st);
        this.setupTargetSqlElement(br, executedSql, displaySql);
    }

    protected void setupSQLExceptionElement(ExceptionMessageBuilder br, SQLException e) {
        br.addItem("SQLException");
        br.addElement(e.getClass().getName());
        br.addElement(this.extractMessage(e));
        SQLException nextEx = e.getNextException();
        if (nextEx != null) {
            br.addItem("NextException");
            br.addElement(nextEx.getClass().getName());
            br.addElement(this.extractMessage(nextEx));
            SQLException nextNextEx = nextEx.getNextException();
            if (nextNextEx != null) {
                br.addItem("NextNextException");
                br.addElement(nextNextEx.getClass().getName());
                br.addElement(this.extractMessage(nextNextEx));
            }
        }
    }

    protected void setupBehaviorElement(ExceptionMessageBuilder br) {
        String invokeName = this.extractBehaviorInvokeName();
        if (invokeName != null) {
            br.addItem("Behavior");
            br.addElement(invokeName);
        }
    }

    protected void setupConditionBeanElement(ExceptionMessageBuilder br) {
        if (this.hasConditionBean()) {
            br.addItem("ConditionBean");
            br.addElement(this.getConditionBean().getClass().getName());
        }
    }

    protected void setupOutsideSqlElement(ExceptionMessageBuilder br) {
        if (this.hasOutsideSqlContext()) {
            br.addItem("OutsideSql");
            br.addElement(this.getOutsideSqlContext().getOutsideSqlPath());
        }
    }

    protected void setupStatementElement(ExceptionMessageBuilder br, Statement st) {
        if (st != null) {
            br.addItem("Statement");
            br.addElement(st.getClass().getName());
        }
    }

    protected void setupTargetSqlElement(ExceptionMessageBuilder br, String executedSql, String displaySql) {
        if (displaySql != null) {
            br.addItem("Display SQL");
            br.addElement(displaySql);
        }
    }

    protected String extractMessage(SQLException e) {
        String message = e.getMessage();
        return message != null ? message.trim() : message;
    }

    protected String extractSQLState(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextEx = e.getNextException();
        if (nextEx == null) {
            return null;
        }
        sqlState = nextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextEx = nextEx.getNextException();
        if (nextNextEx == null) {
            return null;
        }
        sqlState = nextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        SQLException nextNextNextEx = nextNextEx.getNextException();
        if (nextNextNextEx == null) {
            return null;
        }
        sqlState = nextNextNextEx.getSQLState();
        if (sqlState != null) {
            return sqlState;
        }
        return null;
    }

    protected String extractBehaviorInvokeName() {
        String behaviorInvokeName = InternalMapContext.getBehaviorInvokeName();
        if (behaviorInvokeName == null) {
            return null;
        }
        String clientInvokeName = InternalMapContext.getClientInvokeName();
        String byPassInvokeName = InternalMapContext.getByPassInvokeName();
        StringBuilder sb = new StringBuilder();
        boolean existsPath = false;
        if (clientInvokeName != null) {
            existsPath = true;
            sb.append((Object)clientInvokeName);
        }
        if (byPassInvokeName != null) {
            existsPath = true;
            sb.append((Object)byPassInvokeName);
        }
        sb.append((Object)behaviorInvokeName);
        if (existsPath) {
            sb.append("...");
        }
        return sb.toString();
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected ConditionBean getConditionBean() {
        return ConditionBeanContext.getConditionBeanOnThread();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

