/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLFUCache<K, V> {
    private static Logger log = LoggerFactory.getLogger(ConcurrentLFUCache.class);
    private final ConcurrentHashMap<Object, CacheEntry<K, V>> map;
    private final int upperWaterMark;
    private final int lowerWaterMark;
    private final ReentrantLock markAndSweepLock = new ReentrantLock(true);
    private boolean isCleaning = false;
    private final boolean newThreadForCleanup;
    private volatile boolean islive = true;
    private final Stats stats = new Stats();
    private final int acceptableWaterMark;
    private long lowHitCount = 0L;
    private final EvictionListener<K, V> evictionListener;
    private CleanupThread cleanupThread;
    private final boolean timeDecay;
    private boolean isDestroyed = false;

    public ConcurrentLFUCache(int upperWaterMark, int lowerWaterMark, int acceptableSize, int initialSize, boolean runCleanupThread, boolean runNewThreadForCleanup, EvictionListener<K, V> evictionListener, boolean timeDecay) {
        if (upperWaterMark < 1) {
            throw new IllegalArgumentException("upperWaterMark must be > 0");
        }
        if (lowerWaterMark >= upperWaterMark) {
            throw new IllegalArgumentException("lowerWaterMark must be  < upperWaterMark");
        }
        this.map = new ConcurrentHashMap(initialSize);
        this.newThreadForCleanup = runNewThreadForCleanup;
        this.upperWaterMark = upperWaterMark;
        this.lowerWaterMark = lowerWaterMark;
        this.acceptableWaterMark = acceptableSize;
        this.evictionListener = evictionListener;
        this.timeDecay = timeDecay;
        if (runCleanupThread) {
            this.cleanupThread = new CleanupThread(this);
            this.cleanupThread.start();
        }
    }

    public ConcurrentLFUCache(int size, int lowerWatermark) {
        this(size, lowerWatermark, (int)Math.floor((lowerWatermark + size) / 2), (int)Math.ceil(0.75 * (double)size), false, false, null, true);
    }

    public void setAlive(boolean live) {
        this.islive = live;
    }

    public V get(K key) {
        CacheEntry<K, V> e = this.map.get(key);
        if (e == null) {
            if (this.islive) {
                this.stats.missCounter.incrementAndGet();
            }
            return null;
        }
        if (this.islive) {
            e.lastAccessed = this.stats.accessCounter.incrementAndGet();
            e.hits.incrementAndGet();
        }
        return e.value;
    }

    public V remove(K key) {
        CacheEntry<K, V> cacheEntry = this.map.remove(key);
        if (cacheEntry != null) {
            this.stats.size.decrementAndGet();
            return cacheEntry.value;
        }
        return null;
    }

    public V put(K key, V val) {
        if (val == null) {
            return null;
        }
        CacheEntry<K, V> e = new CacheEntry<K, V>(key, val, this.stats.accessCounter.incrementAndGet());
        CacheEntry<K, V> oldCacheEntry = this.map.put(key, e);
        int currentSize = oldCacheEntry == null ? this.stats.size.incrementAndGet() : this.stats.size.get();
        if (this.islive) {
            this.stats.putCounter.incrementAndGet();
        } else {
            this.stats.nonLivePutCounter.incrementAndGet();
        }
        if (currentSize > this.upperWaterMark && !this.isCleaning) {
            if (this.newThreadForCleanup) {
                new Thread(){

                    public void run() {
                        ConcurrentLFUCache.this.markAndSweep();
                    }
                }.start();
            } else if (this.cleanupThread != null) {
                this.cleanupThread.wakeThread();
            } else {
                this.markAndSweep();
            }
        }
        return oldCacheEntry == null ? null : (V)oldCacheEntry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAndSweep() {
        if (!this.markAndSweepLock.tryLock()) {
            return;
        }
        try {
            long lowHitCount = this.lowHitCount;
            this.isCleaning = true;
            this.lowHitCount = lowHitCount;
            int sz = this.stats.size.get();
            int wantToRemove = sz - this.lowerWaterMark;
            TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
            for (CacheEntry<K, V> ce : this.map.values()) {
                ce.hitsCopy = ce.hits.get();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (this.timeDecay) {
                    ce.hits.set(ce.hitsCopy >>> 1);
                }
                if (tree.size() < wantToRemove) {
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy < ((CacheEntry)tree.first()).hitsCopy) {
                    tree.remove(tree.first());
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy != ((CacheEntry)tree.first()).hitsCopy) continue;
                tree.add(ce);
                tree.remove(tree.first());
            }
            for (CacheEntry<K, V> e : tree) {
                this.evictEntry(e.key);
            }
            Object var9_7 = null;
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
            throw throwable;
        }
    }

    private void evictEntry(K key) {
        CacheEntry<K, V> o = this.map.remove(key);
        if (o == null) {
            return;
        }
        this.stats.size.decrementAndGet();
        this.stats.evictionCounter.incrementAndGet();
        if (this.evictionListener != null) {
            this.evictionListener.evictedEntry(o.key, o.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getLeastUsedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry<Object, CacheEntry<K, V>> entry : this.map.entrySet()) {
                CacheEntry<K, V> ce = entry.getValue();
                ce.hitsCopy = ce.hits.get();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy < ((CacheEntry)tree.first()).hitsCopy) {
                    tree.remove(tree.first());
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy != ((CacheEntry)tree.first()).hitsCopy) continue;
                tree.add(ce);
                tree.remove(tree.first());
            }
            Object var8_9 = null;
            this.markAndSweepLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.markAndSweepLock.unlock();
            throw throwable;
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getMostUsedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry<Object, CacheEntry<K, V>> entry : this.map.entrySet()) {
                CacheEntry<K, V> ce = entry.getValue();
                ce.hitsCopy = ce.hits.get();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy > ((CacheEntry)tree.last()).hitsCopy) {
                    tree.remove(tree.last());
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy != ((CacheEntry)tree.last()).hitsCopy) continue;
                tree.add(ce);
                tree.remove(tree.last());
            }
            Object var8_9 = null;
            this.markAndSweepLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.markAndSweepLock.unlock();
            throw throwable;
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    public int size() {
        return this.stats.size.get();
    }

    public void clear() {
        this.map.clear();
    }

    public Map<Object, CacheEntry<K, V>> getMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.cleanupThread != null) {
                this.cleanupThread.stopThread();
            }
            Object var2_1 = null;
            this.isDestroyed = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isDestroyed = true;
            throw throwable;
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isDestroyed) {
                log.error("ConcurrentLFUCache was not destroyed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.destroy();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private static class CleanupThread
    extends Thread {
        private WeakReference<ConcurrentLFUCache> cache;
        private boolean stop = false;

        public CleanupThread(ConcurrentLFUCache c) {
            this.cache = new WeakReference<ConcurrentLFUCache>(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                ConcurrentLFUCache c;
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.stop) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.stop || (c = (ConcurrentLFUCache)this.cache.get()) == null) break;
                c.markAndSweep();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.stop = true;
                this.notify();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictionListener<K, V> {
        public void evictedEntry(K var1, V var2);
    }

    public static class Stats {
        private final AtomicLong accessCounter = new AtomicLong(0L);
        private final AtomicLong putCounter = new AtomicLong(0L);
        private final AtomicLong nonLivePutCounter = new AtomicLong(0L);
        private final AtomicLong missCounter = new AtomicLong();
        private final AtomicInteger size = new AtomicInteger();
        private AtomicLong evictionCounter = new AtomicLong();

        public long getCumulativeLookups() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get() + this.missCounter.get();
        }

        public long getCumulativeHits() {
            return this.accessCounter.get() - this.putCounter.get() - this.nonLivePutCounter.get();
        }

        public long getCumulativePuts() {
            return this.putCounter.get();
        }

        public long getCumulativeEvictions() {
            return this.evictionCounter.get();
        }

        public int getCurrentSize() {
            return this.size.get();
        }

        public long getCumulativeNonLivePuts() {
            return this.nonLivePutCounter.get();
        }

        public long getCumulativeMisses() {
            return this.missCounter.get();
        }

        public void add(Stats other) {
            this.accessCounter.addAndGet(other.accessCounter.get());
            this.putCounter.addAndGet(other.putCounter.get());
            this.nonLivePutCounter.addAndGet(other.nonLivePutCounter.get());
            this.missCounter.addAndGet(other.missCounter.get());
            this.evictionCounter.addAndGet(other.evictionCounter.get());
            this.size.set(Math.max(this.size.get(), other.size.get()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry<K, V>
    implements Comparable<CacheEntry<K, V>> {
        K key;
        V value;
        volatile AtomicLong hits = new AtomicLong(0L);
        long hitsCopy = 0L;
        volatile long lastAccessed = 0L;
        long lastAccessedCopy = 0L;

        public CacheEntry(K key, V value, long lastAccessed) {
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
        }

        @Override
        public int compareTo(CacheEntry<K, V> that) {
            if (this.hitsCopy == that.hitsCopy) {
                if (this.lastAccessedCopy == that.lastAccessedCopy) {
                    return 0;
                }
                return this.lastAccessedCopy < that.lastAccessedCopy ? 1 : -1;
            }
            return this.hitsCopy < that.hitsCopy ? 1 : -1;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public String toString() {
            return "key: " + this.key + " value: " + this.value + " hits:" + this.hits.get();
        }
    }
}

