/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedTreeSet<E>
extends TreeSet<E> {
    private int maxSize = Integer.MAX_VALUE;

    public BoundedTreeSet(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public BoundedTreeSet(int maxSize, Collection<? extends E> c) {
        super(c);
        this.setMaxSize(maxSize);
    }

    public BoundedTreeSet(int maxSize, Comparator<? super E> c) {
        super(c);
        this.setMaxSize(maxSize);
    }

    public BoundedTreeSet(int maxSize, SortedSet<E> s) {
        super(s);
        this.setMaxSize(maxSize);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int max) {
        this.maxSize = max;
        this.adjust();
    }

    private void adjust() {
        while (this.maxSize < this.size()) {
            this.remove(this.last());
        }
    }

    @Override
    public boolean add(E item) {
        boolean out = super.add(item);
        this.adjust();
        return out;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean out = super.addAll(c);
        this.adjust();
        return out;
    }
}

