/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.lucene.spatial.tier.InvalidGeoException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.CoordinateFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PointTypeValueSource;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointType
extends CoordinateFieldType
implements SpatialQueryable {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        MapSolrParams p = new MapSolrParams(args);
        this.dimension = p.getInt("dimension", 2);
        if (this.dimension < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The dimension must be > 0: " + this.dimension);
        }
        args.remove("dimension");
        this.schema = schema;
        super.init(schema, args);
        this.createSuffixCache(this.dimension);
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public Fieldable[] createFields(SchemaField field, String externalVal, float boost) {
        String[] point = new String[]{};
        try {
            point = DistanceUtils.parsePoint(null, (String)externalVal, (int)this.dimension);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        Fieldable[] f = new Fieldable[(field.indexed() ? this.dimension : 0) + (field.stored() ? 1 : 0)];
        if (field.indexed()) {
            for (int i = 0; i < this.dimension; ++i) {
                f[i] = this.subField(field, i).createField(point[i], boost);
            }
        }
        if (field.stored()) {
            String storedVal = externalVal;
            f[f.length - 1] = this.createField(field.getName(), storedVal, this.getFieldStore(field, storedVal), Field.Index.NO, Field.TermVector.NO, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, boost);
        }
        return f;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        ArrayList<ValueSource> vs = new ArrayList<ValueSource>(this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            SchemaField sub = this.subField(field, i);
            vs.add(sub.getType().getValueSource(sub, parser));
        }
        return new PointTypeValueSource(field, vs);
    }

    @Override
    public Fieldable createField(SchemaField field, String externalVal, float boost) {
        throw new UnsupportedOperationException("PointType uses multiple fields.  field=" + field.getName());
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, f.stringValue(), false);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not suported on PointType " + field.getName());
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        String[] p2;
        String[] p1;
        try {
            p1 = DistanceUtils.parsePoint(null, (String)part1, (int)this.dimension);
            p2 = DistanceUtils.parsePoint(null, (String)part2, (int)this.dimension);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BooleanQuery result = new BooleanQuery(true);
        for (int i = 0; i < this.dimension; ++i) {
            SchemaField subSF = this.subField(field, i);
            result.add(subSF.getType().getRangeQuery(parser, subSF, p1[i], p2[i], minInclusive, maxInclusive), BooleanClause.Occur.MUST);
        }
        return result;
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        String[] p1 = new String[]{};
        try {
            p1 = DistanceUtils.parsePoint(null, (String)externalVal, (int)this.dimension);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BooleanQuery bq = new BooleanQuery(true);
        for (int i = 0; i < this.dimension; ++i) {
            SchemaField sf = this.subField(field, i);
            Query tq = sf.getType().getFieldQuery(parser, sf, p1[i]);
            bq.add(tq, BooleanClause.Occur.MUST);
        }
        return bq;
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        BooleanQuery result = null;
        double[] point = new double[]{};
        try {
            point = DistanceUtils.parsePointDouble(null, (String)options.pointStr, (int)this.dimension);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        if (this.dimension == 1) {
            String lower = String.valueOf(point[0] - options.distance);
            String upper = String.valueOf(point[0] + options.distance);
            SchemaField subSF = this.subField(options.field, 0);
            result = subSF.getType().getRangeQuery(parser, subSF, lower, upper, true, true);
        } else {
            BooleanQuery tmp = new BooleanQuery();
            double[] ur = DistanceUtils.vectorBoxCorner((double[])point, null, (double)options.distance, (boolean)true);
            double[] ll = DistanceUtils.vectorBoxCorner((double[])point, null, (double)options.distance, (boolean)false);
            for (int i = 0; i < ur.length; ++i) {
                SchemaField subSF = this.subField(options.field, i);
                Query range = subSF.getType().getRangeQuery(parser, subSF, String.valueOf(ll[i]), String.valueOf(ur[i]), true, true);
                tmp.add(range, BooleanClause.Occur.MUST);
            }
            result = tmp;
        }
        return result;
    }
}

