/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.util.Map;
import org.apache.lucene.spatial.DistanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DistanceHandler {
    private Map<Integer, Double> distances;
    private Map<String, Double> distanceLookupCache;
    private Precision precise;

    public DistanceHandler(Map<Integer, Double> distances, Map<String, Double> distanceLookupCache, Precision precise) {
        this.distances = distances;
        this.distanceLookupCache = distanceLookupCache;
        this.precise = precise;
    }

    public static double getPrecision(double x, Precision thisPrecise) {
        if (thisPrecise != null) {
            double dif = 0.0;
            switch (thisPrecise) {
                case EXACT: {
                    return x;
                }
                case TWOFEET: {
                    dif = x % 1.0E-4;
                    break;
                }
                case TWENTYFEET: {
                    dif = x % 0.001;
                    break;
                }
                case TWOHUNDREDFEET: {
                    dif = x % 0.01;
                }
            }
            return x - dif;
        }
        return x;
    }

    public Precision getPrecision() {
        return this.precise;
    }

    public double getDistance(int docid, double centerLat, double centerLng, double lat, double lng) {
        if (this.distances == null) {
            return DistanceUtils.getDistanceMi(centerLat, centerLng, lat, lng);
        }
        Double docd = this.distances.get(docid);
        if (docd != null) {
            return docd;
        }
        if (this.precise != null) {
            double xLat = DistanceHandler.getPrecision(lat, this.precise);
            double xLng = DistanceHandler.getPrecision(lng, this.precise);
            String k = Double.valueOf(xLat).toString() + "," + Double.valueOf(xLng).toString();
            Double d = this.distanceLookupCache.get(k);
            if (d != null) {
                return d;
            }
        }
        return DistanceUtils.getDistanceMi(centerLat, centerLng, lat, lng);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Precision {
        EXACT,
        TWOFEET,
        TWENTYFEET,
        TWOHUNDREDFEET;

    }
}

