/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import org.simpleframework.xml.stream.EventNode;
import org.simpleframework.xml.stream.EventReader;
import org.simpleframework.xml.stream.InputElement;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.InputStack;

class NodeReader {
    private final EventReader reader;
    private final InputStack stack = new InputStack();

    public NodeReader(EventReader reader) {
        this.reader = reader;
    }

    public InputNode readRoot() throws Exception {
        if (this.stack.isEmpty()) {
            return this.readElement(null);
        }
        return null;
    }

    public boolean isRoot(InputNode node) {
        return this.stack.bottom() == node;
    }

    public InputNode readElement(InputNode from) throws Exception {
        if (!this.stack.isRelevant(from)) {
            return null;
        }
        EventNode event = this.reader.next();
        while (event != null) {
            if (event.isEnd()) {
                if (this.stack.pop() == from) {
                    return null;
                }
            } else if (event.isStart()) {
                return this.readStart(from, event);
            }
            event = this.reader.next();
        }
        return null;
    }

    public InputNode readElement(InputNode from, String name) throws Exception {
        if (!this.stack.isRelevant(from)) {
            return null;
        }
        EventNode event = this.reader.peek();
        while (event != null) {
            if (event.isEnd()) {
                if (this.stack.top() == from) {
                    return null;
                }
                this.stack.pop();
            } else if (event.isStart()) {
                if (!this.isName(event, name)) break;
                return this.readElement(from);
            }
            event = this.reader.next();
            event = this.reader.peek();
        }
        return null;
    }

    private InputNode readStart(InputNode from, EventNode event) throws Exception {
        InputElement input = new InputElement(from, this, event);
        if (event.isStart()) {
            return this.stack.push(input);
        }
        return input;
    }

    private boolean isName(EventNode node, String name) {
        String local = node.getName();
        if (local == null) {
            return false;
        }
        return local.equals(name);
    }

    public String readValue(InputNode from) throws Exception {
        StringBuilder value = new StringBuilder();
        while (this.stack.top() == from) {
            EventNode event = this.reader.peek();
            if (!event.isText()) {
                if (value.length() == 0) {
                    return null;
                }
                return value.toString();
            }
            String data = event.getValue();
            value.append(data);
            this.reader.next();
        }
        return null;
    }

    public boolean isEmpty(InputNode from) throws Exception {
        EventNode event;
        return this.stack.top() == from && (event = this.reader.peek()).isEnd();
    }

    public void skipElement(InputNode from) throws Exception {
        while (this.readElement(from) != null) {
        }
    }
}

