/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityDuplicatedException;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlhandler.TnAbstractEntityHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractBatchHandler
extends TnAbstractEntityHandler {
    private static final Log _log = LogFactory.getLog(TnAbstractBatchHandler.class);
    protected StringBuilder _batchLoggingSb;
    protected int _loggingRecordCount;
    protected int _loggingScopeSize;
    protected boolean _existsSkippedLogging;
    protected boolean _alreadySavedToResultInfo;

    public TnAbstractBatchHandler(DataSource dataSource, StatementFactory statementFactory, String sql, TnBeanMetaData beanMetaData, TnPropertyType[] boundPropTypes) {
        super(dataSource, statementFactory, sql, beanMetaData, boundPropTypes);
    }

    @Override
    public int execute(Object[] args) {
        String msg = "This method should not be called when BatchUpdate.";
        throw new IllegalStateException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(List<?> beanList) {
        if (beanList == null) {
            String msg = "The argument 'beanList' should not be null";
            throw new IllegalArgumentException(msg);
        }
        if (beanList.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skip executeBatch() bacause of the empty list.");
            }
            return new int[0];
        }
        this.processBefore(beanList);
        Connection conn = this.getConnection();
        try {
            RuntimeException sqlEx = null;
            PreparedStatement ps = this.prepareStatement(conn);
            int[] result = null;
            try {
                for (Object bean : beanList) {
                    this.processBatchBefore(bean);
                    this.prepareBatchElement(conn, ps, bean);
                }
                this.handleBatchLogging();
                result = this.executeBatch(ps, beanList);
                this.handleBatchUpdateResultWithOptimisticLock(ps, beanList, result);
            }
            catch (RuntimeException e) {
                sqlEx = e;
                throw e;
            }
            finally {
                this.close(ps);
                this.processFinally(beanList, sqlEx);
            }
            int index = 0;
            for (Object bean : beanList) {
                this.processBatchSuccess(bean, index);
                ++index;
            }
            this.processSuccess(beanList, result.length);
            int[] nArray = result;
            return nArray;
        }
        finally {
            this.close(conn);
        }
    }

    protected void prepareBatchElement(Connection conn, PreparedStatement ps, Object bean) {
        this.setupBindVariables(bean);
        Object[] bindVariables = this._bindVariables;
        this.logSql(bindVariables, this.getArgTypes(bindVariables));
        this.bindArgs(conn, ps, bindVariables, this._bindVariableValueTypes);
        this.addBatch(ps);
    }

    @Override
    protected void logSql(Object[] args, Class<?>[] argTypes) {
        if (this.isBatchLoggingOver()) {
            this._existsSkippedLogging = true;
            return;
        }
        super.logSql(args, argTypes);
    }

    @Override
    protected void logDisplaySql(String displaySql) {
        if (this._batchLoggingSb == null) {
            this._batchLoggingSb = new StringBuilder(1000);
        }
        this.saveBatchLoggingSql(displaySql);
        if (this.needsBreakLoggingScope()) {
            this.handleBatchLogging();
        }
    }

    protected boolean isBatchLoggingOver() {
        Integer batchLoggingLimit = this.getBatchLoggingLimit();
        if (batchLoggingLimit == null || batchLoggingLimit < 0) {
            return false;
        }
        return this._loggingRecordCount >= batchLoggingLimit;
    }

    protected void noticeBatchLoggingOver() {
        if (this._existsSkippedLogging && XLog.isLogEnabled()) {
            Integer batchLoggingLimit = this.getBatchLoggingLimit();
            XLog.log("...Skipping several loggings by the limit option: " + batchLoggingLimit);
        }
    }

    protected abstract Integer getBatchLoggingLimit();

    protected void saveBatchLoggingSql(String displaySql) {
        ++this._loggingRecordCount;
        ++this._loggingScopeSize;
        this._batchLoggingSb.append(this.ln()).append(displaySql).append(";");
    }

    protected boolean needsBreakLoggingScope() {
        return this._loggingScopeSize >= 100;
    }

    @Override
    protected void saveDisplaySqlForResultInfo(String displaySql) {
    }

    protected String handleBatchLogging() {
        if (this._batchLoggingSb == null) {
            return null;
        }
        String batchSql = this._batchLoggingSb.toString();
        if (this.isLogEnabled()) {
            this.log(batchSql);
        }
        this.clearBatchLogging();
        if (!this._alreadySavedToResultInfo && this.hasSqlResultHandler()) {
            String savedDisplaySql = batchSql.trim();
            super.saveDisplaySqlForResultInfo(savedDisplaySql);
            this._alreadySavedToResultInfo = true;
        }
        return batchSql;
    }

    protected void clearBatchLogging() {
        this._batchLoggingSb = null;
        this._loggingScopeSize = 0;
    }

    @Override
    protected void processBefore(Object beanList) {
        super.processBefore(beanList);
    }

    @Override
    protected void processFinally(Object beanList, RuntimeException sqlEx) {
        super.processFinally(beanList, sqlEx);
        this.noticeBatchLoggingOver();
        this._existsSkippedLogging = false;
        this._alreadySavedToResultInfo = false;
    }

    @Override
    protected void processSuccess(Object beanList, int ret) {
        super.processSuccess(beanList, ret);
    }

    protected void processBatchBefore(Object bean) {
    }

    protected void processBatchSuccess(Object bean, int index) {
        this.updateTimestampIfNeed(bean, index);
        this.updateVersionNoIfNeed(bean, index);
    }

    protected void handleBatchUpdateResultWithOptimisticLock(PreparedStatement ps, List<?> list, int[] result) {
        if (this.isCurrentDBDef(DBDef.Oracle)) {
            int updateCount;
            try {
                updateCount = ps.getUpdateCount();
            }
            catch (SQLException e) {
                this.handleSQLException(e, ps);
                return;
            }
            this.handleBatchUpdateResultWithOptimisticLockByUpdateCount(list, updateCount);
        } else {
            this.handleBatchUpdateResultWithOptimisticLockByResult(list, result);
        }
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    protected void handleBatchUpdateResultWithOptimisticLockByUpdateCount(List<?> list, int updateCount) {
        if (list.isEmpty()) {
            return;
        }
        if (updateCount < 0) {
            return;
        }
        int entityCount = list.size();
        if (updateCount < entityCount) {
            if (this._optimisticLockHandling) {
                throw new BatchEntityAlreadyUpdatedException(list.get(0), 0, updateCount);
            }
            String msg = "The entity was NOT found! it has already been deleted.";
            msg = msg + " updateCount=" + updateCount;
            msg = msg + " entityCount=" + entityCount;
            msg = msg + " allEntities=" + list;
            throw new EntityAlreadyDeletedException(msg);
        }
    }

    protected void handleBatchUpdateResultWithOptimisticLockByResult(List<?> list, int[] result) {
        if (list.isEmpty()) {
            return;
        }
        int[] updatedCountArray = result;
        int entityCount = list.size();
        int index = 0;
        boolean alreadyUpdated = false;
        for (int oneUpdateCount : updatedCountArray) {
            if (entityCount <= index) break;
            if (oneUpdateCount == 0) {
                alreadyUpdated = true;
                break;
            }
            if (oneUpdateCount > 1) {
                String msg = "The entity updated two or more records in batch update:";
                msg = msg + " entity=" + list.get(index);
                msg = msg + " updatedCount=" + oneUpdateCount;
                msg = msg + " allEntities=" + list;
                throw new EntityDuplicatedException(msg);
            }
            ++index;
        }
        if (alreadyUpdated) {
            int updateCount = 0;
            for (int oneUpdateCount : updatedCountArray) {
                updateCount += oneUpdateCount;
            }
            if (this._optimisticLockHandling) {
                throw new BatchEntityAlreadyUpdatedException(list.get(index), 0, updateCount);
            }
            String msg = "The entity was NOT found! it has already been deleted:";
            msg = msg + " entity=" + list.get(index);
            msg = msg + " updateCount=" + updateCount;
            msg = msg + " allEntities=" + list;
            throw new EntityAlreadyDeletedException(msg);
        }
    }

    @Override
    protected String buildExceptionMessageSql() {
        if (this._exceptionMessageSqlArgs == null && this._bindVariables != null) {
            this._exceptionMessageSqlArgs = this._bindVariables;
        }
        return super.buildExceptionMessageSql();
    }

    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
        try {
            return ps.executeBatch();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps, true);
            return null;
        }
    }

    protected void addBatch(PreparedStatement ps) {
        try {
            ps.addBatch();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
        }
    }
}

